/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing.connection;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnectionDefinition;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class SharedConnection
implements Connection {
    public static final String CONNECTION_OWNER = "jdbc-shared-by";
    @Inject
    private GuacamoleTunnelService tunnelService;
    private RemoteAuthenticatedUser user;
    private SharedConnectionDefinition definition;

    public void init(RemoteAuthenticatedUser user, SharedConnectionDefinition definition) {
        this.user = user;
        this.definition = definition;
    }

    public String getIdentifier() {
        return this.definition.getShareKey();
    }

    public void setIdentifier(String identifier) {
        throw new UnsupportedOperationException("Shared connections are immutable.");
    }

    public String getName() {
        return this.definition.getActiveConnection().getConnection().getName();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Shared connections are immutable.");
    }

    public String getParentIdentifier() {
        return "ROOT";
    }

    public void setParentIdentifier(String parentIdentifier) {
        throw new UnsupportedOperationException("Shared connections are immutable.");
    }

    public GuacamoleConfiguration getConfiguration() {
        ModeledConnection primaryConnection = this.definition.getActiveConnection().getConnection();
        GuacamoleConfiguration config = new GuacamoleConfiguration();
        config.setProtocol(primaryConnection.getConfiguration().getProtocol());
        return config;
    }

    public void setConfiguration(GuacamoleConfiguration config) {
        throw new UnsupportedOperationException("Shared connections are immutable.");
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        return this.tunnelService.getGuacamoleTunnel(this.user, this.definition, info, tokens);
    }

    public Map<String, String> getAttributes() {
        String sharedBy = this.definition.getActiveConnection().getUser().getIdentifier();
        return Collections.singletonMap(CONNECTION_OWNER, sharedBy);
    }

    public void setAttributes(Map<String, String> attributes) {
    }

    public Date getLastActive() {
        return null;
    }

    public List<? extends ConnectionRecord> getHistory() throws GuacamoleException {
        return Collections.emptyList();
    }

    public Set<String> getSharingProfileIdentifiers() throws GuacamoleException {
        return Collections.emptySet();
    }

    public int getActiveConnections() {
        return 0;
    }
}

