/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.postgresql;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.auth.postgresql.PostgreSQLGuacamoleProperties;
import org.apache.guacamole.auth.postgresql.PostgreSQLPasswordPolicy;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLEnvironment
extends JDBCEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLEnvironment.class);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5432;
    private static final boolean DEFAULT_USER_REQUIRED = false;
    private final int DEFAULT_ABSOLUTE_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS = 0;

    @Override
    public boolean isUserRequired() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_USER_REQUIRED, false);
    }

    @Override
    public int getAbsoluteMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_ABSOLUTE_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxGroupConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_GROUP_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public int getDefaultMaxGroupConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() {
        return new PostgreSQLPasswordPolicy(this);
    }

    public String getPostgreSQLHostname() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_HOSTNAME, DEFAULT_HOSTNAME);
    }

    public int getPostgreSQLPort() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_PORT, 5432);
    }

    public String getPostgreSQLDatabase() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DATABASE);
    }

    public String getPostgreSQLUsername() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_USERNAME);
    }

    public String getPostgreSQLPassword() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_PASSWORD);
    }

    @Override
    public boolean isRecursiveQuerySupported(SqlSession session) {
        return true;
    }
}

