/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.tunnel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceConflictException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.GuacamoleUpstreamException;
import org.apache.guacamole.auth.jdbc.connection.ConnectionMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionParameterMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionParameterModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionRecordMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionRecordModel;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnectionDefinition;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileParameterMapper;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileParameterModel;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionMultimap;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.tunnel.ManagedInetGuacamoleSocket;
import org.apache.guacamole.auth.jdbc.tunnel.ManagedSSLGuacamoleSocket;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.apache.guacamole.protocol.FailoverGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.TokenFilter;
import org.mybatis.guice.transactional.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGuacamoleTunnelService
implements GuacamoleTunnelService {
    private final Logger logger = LoggerFactory.getLogger(AbstractGuacamoleTunnelService.class);
    @Inject
    private ConnectionMapper connectionMapper;
    @Inject
    private Provider<ModeledConnection> connectionProvider;
    @Inject
    private ConnectionParameterMapper connectionParameterMapper;
    @Inject
    private SharingProfileParameterMapper sharingProfileParameterMapper;
    @Inject
    private ConnectionRecordMapper connectionRecordMapper;
    @Inject
    private Provider<ActiveConnectionRecord> activeConnectionRecordProvider;
    private final Map<String, ActiveConnectionRecord> activeTunnels = new ConcurrentHashMap<String, ActiveConnectionRecord>();
    private final ActiveConnectionMultimap activeConnections = new ActiveConnectionMultimap();
    private final ActiveConnectionMultimap activeConnectionGroups = new ActiveConnectionMultimap();

    protected abstract ModeledConnection acquire(RemoteAuthenticatedUser var1, List<ModeledConnection> var2, boolean var3) throws GuacamoleException;

    protected abstract void release(RemoteAuthenticatedUser var1, ModeledConnection var2);

    protected abstract void acquire(RemoteAuthenticatedUser var1, ModeledConnectionGroup var2) throws GuacamoleException;

    protected abstract void release(RemoteAuthenticatedUser var1, ModeledConnectionGroup var2);

    private GuacamoleConfiguration getGuacamoleConfiguration(RemoteAuthenticatedUser user, ModeledConnection connection, String connectionID) {
        GuacamoleConfiguration config = new GuacamoleConfiguration();
        if (connectionID != null) {
            config.setConnectionID(connectionID);
        } else {
            ConnectionModel model = (ConnectionModel)connection.getModel();
            config.setProtocol(model.getProtocol());
        }
        Collection<ConnectionParameterModel> parameters = this.connectionParameterMapper.select(connection.getIdentifier());
        for (ConnectionParameterModel parameter : parameters) {
            config.setParameter(parameter.getName(), parameter.getValue());
        }
        return config;
    }

    private GuacamoleConfiguration getGuacamoleConfiguration(RemoteAuthenticatedUser user, ModeledSharingProfile sharingProfile, String connectionID) {
        GuacamoleConfiguration config = new GuacamoleConfiguration();
        config.setConnectionID(connectionID);
        Collection<SharingProfileParameterModel> parameters = this.sharingProfileParameterMapper.select(sharingProfile.getIdentifier());
        for (SharingProfileParameterModel parameter : parameters) {
            config.setParameter(parameter.getName(), parameter.getValue());
        }
        return config;
    }

    private void saveConnectionRecord(ActiveConnectionRecord record) {
        ConnectionRecordModel recordModel = new ConnectionRecordModel();
        recordModel.setUsername(record.getUsername());
        recordModel.setConnectionIdentifier(record.getConnectionIdentifier());
        recordModel.setConnectionName(record.getConnectionName());
        recordModel.setRemoteHost(record.getRemoteHost());
        recordModel.setSharingProfileIdentifier(record.getSharingProfileIdentifier());
        recordModel.setSharingProfileName(record.getSharingProfileName());
        recordModel.setStartDate(record.getStartDate());
        recordModel.setEndDate(new Date());
        this.connectionRecordMapper.insert(recordModel);
    }

    private GuacamoleSocket getUnconfiguredGuacamoleSocket(GuacamoleProxyConfiguration proxyConfig, Runnable socketClosedCallback) throws GuacamoleException {
        switch (proxyConfig.getEncryptionMethod()) {
            case SSL: {
                return new ManagedSSLGuacamoleSocket(proxyConfig.getHostname(), proxyConfig.getPort(), socketClosedCallback);
            }
            case NONE: {
                return new ManagedInetGuacamoleSocket(proxyConfig.getHostname(), proxyConfig.getPort(), socketClosedCallback);
            }
        }
        throw new GuacamoleServerException("Unimplemented encryption method.");
    }

    private GuacamoleTunnel assignGuacamoleTunnel(ActiveConnectionRecord activeConnection, GuacamoleClientInformation info, Map<String, String> tokens, boolean interceptErrors) throws GuacamoleException {
        ConnectionCleanupTask cleanupTask = new ConnectionCleanupTask(activeConnection);
        this.activeTunnels.put(activeConnection.getUUID().toString(), activeConnection);
        try {
            GuacamoleConfiguration config;
            ModeledConnection connection = activeConnection.getConnection();
            if (activeConnection.isPrimaryConnection()) {
                this.activeConnections.put(connection.getIdentifier(), activeConnection);
                this.activeConnectionGroups.put(connection.getParentIdentifier(), activeConnection);
                config = this.getGuacamoleConfiguration(activeConnection.getUser(), connection, activeConnection.getConnectionID());
            } else {
                String connectionID = activeConnection.getConnectionID();
                if (connectionID == null) {
                    throw new GuacamoleResourceNotFoundException("No existing connection to be joined.");
                }
                config = this.getGuacamoleConfiguration(activeConnection.getUser(), activeConnection.getSharingProfile(), connectionID);
            }
            TokenFilter tokenFilter = new TokenFilter();
            tokenFilter.setTokens(tokens);
            tokenFilter.filterValues(config.getParameters());
            ConfiguredGuacamoleSocket socket = new ConfiguredGuacamoleSocket(this.getUnconfiguredGuacamoleSocket(connection.getGuacamoleProxyConfiguration(), cleanupTask), config, info);
            if (interceptErrors) {
                return activeConnection.assignGuacamoleTunnel((GuacamoleSocket)new FailoverGuacamoleSocket((GuacamoleSocket)socket), socket.getConnectionID());
            }
            return activeConnection.assignGuacamoleTunnel((GuacamoleSocket)socket, socket.getConnectionID());
        }
        catch (GuacamoleException e) {
            cleanupTask.run();
            throw e;
        }
    }

    private Collection<String> getPreferredConnections(ModeledAuthenticatedUser user, Collection<String> identifiers) {
        for (String identifier : identifiers) {
            if (!user.isPreferredConnection(identifier)) continue;
            return Collections.singletonList(identifier);
        }
        return identifiers;
    }

    private List<ModeledConnection> getBalancedConnections(ModeledAuthenticatedUser user, ModeledConnectionGroup connectionGroup) {
        if (connectionGroup.getType() != ConnectionGroup.Type.BALANCING) {
            return Collections.emptyList();
        }
        Collection<String> identifiers = this.connectionMapper.selectIdentifiersWithin(connectionGroup.getIdentifier());
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        if (connectionGroup.isSessionAffinityEnabled()) {
            identifiers = this.getPreferredConnections(user, identifiers);
        }
        Collection models = this.connectionMapper.select(identifiers);
        ArrayList<ModeledConnection> connections = new ArrayList<ModeledConnection>(models.size());
        for (ConnectionModel model : models) {
            ModeledConnection connection = this.connectionProvider.get();
            connection.init(user, model);
            connections.add(connection);
        }
        return connections;
    }

    @Override
    public Collection<ActiveConnectionRecord> getActiveConnections(ModeledAuthenticatedUser user) throws GuacamoleException {
        Collection<ActiveConnectionRecord> records = this.activeTunnels.values();
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        if (user.getUser().isAdministrator()) {
            return records;
        }
        HashSet<String> identifiers = new HashSet<String>(records.size());
        for (ActiveConnectionRecord activeConnectionRecord : records) {
            identifiers.add(activeConnectionRecord.getConnection().getIdentifier());
        }
        Collection connections = this.connectionMapper.selectReadable((UserModel)user.getUser().getModel(), identifiers, user.getEffectiveUserGroups());
        identifiers.clear();
        for (ConnectionModel connection : connections) {
            identifiers.add(connection.getIdentifier());
        }
        ArrayList<ActiveConnectionRecord> arrayList = new ArrayList<ActiveConnectionRecord>(records.size());
        for (ActiveConnectionRecord record : records) {
            if (!identifiers.contains(record.getConnection().getIdentifier())) continue;
            arrayList.add(record);
        }
        return arrayList;
    }

    @Override
    @Transactional
    public GuacamoleTunnel getGuacamoleTunnel(ModeledAuthenticatedUser user, ModeledConnection connection, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        this.acquire(user, Collections.singletonList(connection), true);
        ActiveConnectionRecord connectionRecord = this.activeConnectionRecordProvider.get();
        connectionRecord.init(user, connection);
        return this.assignGuacamoleTunnel(connectionRecord, info, tokens, false);
    }

    @Override
    public Collection<ActiveConnectionRecord> getActiveConnections(Connection connection) {
        return this.activeConnections.get(connection.getIdentifier());
    }

    @Override
    @Transactional
    public GuacamoleTunnel getGuacamoleTunnel(ModeledAuthenticatedUser user, ModeledConnectionGroup connectionGroup, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        boolean upstreamHasFailed = false;
        List<ModeledConnection> connections = this.getBalancedConnections(user, connectionGroup);
        if (connections.isEmpty()) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        while (true) {
            ModeledConnection connection;
            this.acquire(user, connectionGroup);
            try {
                connection = this.acquire(user, connections, upstreamHasFailed);
            }
            catch (GuacamoleException e) {
                this.release((RemoteAuthenticatedUser)user, connectionGroup);
                throw e;
            }
            try {
                ActiveConnectionRecord connectionRecord = this.activeConnectionRecordProvider.get();
                connectionRecord.init((RemoteAuthenticatedUser)user, connectionGroup, connection);
                GuacamoleTunnel tunnel = this.assignGuacamoleTunnel(connectionRecord, info, tokens, connections.size() > 1);
                if (connectionGroup.isSessionAffinityEnabled()) {
                    user.preferConnection(connection.getIdentifier());
                }
                if (connection.isFailoverOnly()) {
                    this.logger.warn("One or more normal connections within group \"{}\" have failed. Some connection attempts are being routed to designated failover-only connections.", (Object)connectionGroup.getIdentifier());
                }
                return tunnel;
            }
            catch (GuacamoleUpstreamException e) {
                this.logger.info("Upstream error intercepted for connection \"{}\". Failing over to next connection in group...", (Object)connection.getIdentifier());
                this.logger.debug("Upstream remote desktop reported an error during connection.", (Throwable)e);
                connections.remove(connection);
                upstreamHasFailed = true;
                if (!connections.isEmpty()) continue;
                throw new GuacamoleResourceConflictException("Cannot connect. All upstream connections are unavailable.");
            }
            break;
        }
    }

    @Override
    public Collection<ActiveConnectionRecord> getActiveConnections(ConnectionGroup connectionGroup) {
        if (connectionGroup.getType() != ConnectionGroup.Type.BALANCING) {
            return Collections.emptyList();
        }
        return this.activeConnectionGroups.get(connectionGroup.getIdentifier());
    }

    @Override
    @Transactional
    public GuacamoleTunnel getGuacamoleTunnel(RemoteAuthenticatedUser user, SharedConnectionDefinition definition, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        ActiveConnectionRecord connectionRecord = this.activeConnectionRecordProvider.get();
        connectionRecord.init(user, definition.getActiveConnection(), definition.getSharingProfile());
        GuacamoleTunnel tunnel = this.assignGuacamoleTunnel(connectionRecord, info, tokens, false);
        definition.registerTunnel(tunnel);
        return tunnel;
    }

    private class ConnectionCleanupTask
    implements Runnable {
        private final AtomicBoolean hasRun = new AtomicBoolean(false);
        private final ActiveConnectionRecord activeConnection;

        public ConnectionCleanupTask(ActiveConnectionRecord activeConnection) {
            this.activeConnection = activeConnection;
        }

        @Override
        public void run() {
            if (!this.hasRun.compareAndSet(false, true)) {
                return;
            }
            this.activeConnection.invalidate();
            AbstractGuacamoleTunnelService.this.activeTunnels.remove(this.activeConnection.getUUID().toString());
            RemoteAuthenticatedUser user = this.activeConnection.getUser();
            if (this.activeConnection.isPrimaryConnection()) {
                ModeledConnection connection = this.activeConnection.getConnection();
                String identifier = connection.getIdentifier();
                String parentIdentifier = connection.getParentIdentifier();
                AbstractGuacamoleTunnelService.this.activeConnections.remove(identifier, this.activeConnection);
                AbstractGuacamoleTunnelService.this.activeConnectionGroups.remove(parentIdentifier, this.activeConnection);
                AbstractGuacamoleTunnelService.this.release(user, connection);
            }
            if (this.activeConnection.hasBalancingGroup()) {
                AbstractGuacamoleTunnelService.this.release(user, this.activeConnection.getBalancingGroup());
            }
            AbstractGuacamoleTunnelService.this.saveConnectionRecord(this.activeConnection);
        }
    }
}

