/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing.user;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.sharing.permission.SharedObjectPermissionSet;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedUserContext;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.RelatedObjectSet;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;

public class SharedUser
implements User {
    private final AuthenticatedUser user;
    private final SharedUserContext userContext;

    public SharedUser(AuthenticatedUser user, SharedUserContext userContext) {
        this.user = user;
        this.userContext = userContext;
    }

    public String getIdentifier() {
        return this.user.getIdentifier();
    }

    public void setIdentifier(String identifier) {
        throw new UnsupportedOperationException("Users authenticated via share keys are immutable.");
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public void setAttributes(Map<String, String> attributes) {
    }

    public Date getLastActive() {
        return null;
    }

    public List<ActivityRecord> getHistory() throws GuacamoleException {
        return Collections.emptyList();
    }

    public String getPassword() {
        return null;
    }

    public void setPassword(String password) {
        throw new UnsupportedOperationException("Users authenticated via share keys are immutable.");
    }

    public SystemPermissionSet getSystemPermissions() throws GuacamoleException {
        return SystemPermissionSet.EMPTY_SET;
    }

    public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
        Directory<Connection> connectionDirectory = this.userContext.getConnectionDirectory();
        return new SharedObjectPermissionSet(connectionDirectory.getIdentifiers());
    }

    public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
        Directory connectionGroupDirectory = this.userContext.getConnectionGroupDirectory();
        return new SharedObjectPermissionSet(connectionGroupDirectory.getIdentifiers());
    }

    public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
        Directory userDirectory = this.userContext.getUserDirectory();
        return new SharedObjectPermissionSet(userDirectory.getIdentifiers());
    }

    public ObjectPermissionSet getUserGroupPermissions() throws GuacamoleException {
        return ObjectPermissionSet.EMPTY_SET;
    }

    public ObjectPermissionSet getSharingProfilePermissions() throws GuacamoleException {
        return ObjectPermissionSet.EMPTY_SET;
    }

    public ObjectPermissionSet getActiveConnectionPermissions() throws GuacamoleException {
        return ObjectPermissionSet.EMPTY_SET;
    }

    public RelatedObjectSet getUserGroups() throws GuacamoleException {
        return RelatedObjectSet.EMPTY_SET;
    }

    public Permissions getEffectivePermissions() throws GuacamoleException {
        return this;
    }
}

