/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing;

import com.google.inject.Inject;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.sharing.ShareKeyGenerator;
import org.apache.guacamole.auth.jdbc.sharing.SharedConnectionMap;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnectionDefinition;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileService;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.UserCredentials;

public class ConnectionSharingService {
    public static final String SHARE_KEY_NAME = "key";
    @Inject
    private ShareKeyGenerator keyGenerator;
    @Inject
    private SharedConnectionMap connectionMap;
    @Inject
    private SharingProfileService sharingProfileService;
    public static final CredentialsInfo SHARE_KEY = new CredentialsInfo(Collections.singletonList(new Field("key", Field.Type.QUERY_PARAMETER)));

    public SharedConnectionDefinition shareConnection(ModeledAuthenticatedUser user, ActiveConnectionRecord activeConnection, String sharingProfileIdentifier) throws GuacamoleException {
        ModeledSharingProfile sharingProfile = null;
        if (sharingProfileIdentifier != null) {
            sharingProfile = (ModeledSharingProfile)this.sharingProfileService.retrieveObject(user, sharingProfileIdentifier);
            String connectionIdentifier = activeConnection.getConnectionIdentifier();
            if (sharingProfile == null || !sharingProfile.getPrimaryConnectionIdentifier().equals(connectionIdentifier)) {
                throw new GuacamoleSecurityException("Permission denied.");
            }
        }
        String key = this.keyGenerator.getShareKey();
        SharedConnectionDefinition definition = new SharedConnectionDefinition(activeConnection, sharingProfile, key);
        this.connectionMap.add(definition);
        activeConnection.registerShareKey(key);
        return definition;
    }

    public UserCredentials getSharingCredentials(SharedConnectionDefinition definition) {
        return new UserCredentials(SHARE_KEY, Collections.singletonMap(SHARE_KEY_NAME, definition.getShareKey()));
    }

    public String getShareKey(Credentials credentials) {
        HttpServletRequest request = credentials.getRequest();
        if (request == null) {
            return null;
        }
        return request.getParameter(SHARE_KEY_NAME);
    }

    public SharedAuthenticatedUser retrieveSharedConnectionUser(AuthenticationProvider authProvider, Credentials credentials) {
        String shareKey = this.getShareKey(credentials);
        if (shareKey == null || this.connectionMap.get(shareKey) == null) {
            return null;
        }
        return new SharedAuthenticatedUser(authProvider, credentials, shareKey);
    }
}

