/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas.ticket;

import com.google.inject.Inject;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.cas.conf.ConfigurationService;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.token.TokenName;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketValidationService {
    private static final Logger logger = LoggerFactory.getLogger(TicketValidationService.class);
    public static final String CAS_ATTRIBUTE_TOKEN_PREFIX = "CAS_";
    @Inject
    private ConfigurationService confService;

    public Map<String, String> validateTicket(String ticket, Credentials credentials) throws GuacamoleException {
        String casServerUrl = this.confService.getAuthorizationEndpoint();
        Cas20ProxyTicketValidator validator = new Cas20ProxyTicketValidator(casServerUrl);
        validator.setAcceptAnyProxy(true);
        validator.setEncoding("UTF-8");
        try {
            String clearPass;
            HashMap<String, String> tokens = new HashMap<String, String>();
            String confRedirectURI = this.confService.getRedirectURI();
            Assertion a = validator.validate(ticket, confRedirectURI);
            AttributePrincipal principal = a.getPrincipal();
            HashMap<String, Object> ticketAttrs = new HashMap<String, Object>(principal.getAttributes());
            String username = principal.getName();
            if (username == null) {
                throw new GuacamoleSecurityException("No username provided by CAS.");
            }
            credentials.setUsername(username);
            Object credObj = ticketAttrs.remove("credential");
            if (credObj != null && (clearPass = this.decryptPassword(credObj.toString())) != null && !clearPass.isEmpty()) {
                credentials.setPassword(clearPass);
            }
            for (Map.Entry attr : ticketAttrs.entrySet()) {
                String tokenName = TokenName.canonicalize((String)((String)attr.getKey()), (String)CAS_ATTRIBUTE_TOKEN_PREFIX);
                Object value = attr.getValue();
                if (value == null) continue;
                tokens.put(tokenName, value.toString());
            }
            return tokens;
        }
        catch (TicketValidationException e) {
            throw new GuacamoleException("Ticket validation failed.", (Throwable)e);
        }
    }

    private final String decryptPassword(String encryptedPassword) throws GuacamoleException {
        if (encryptedPassword == null || encryptedPassword.isEmpty()) {
            logger.warn("No or empty encrypted password, no password will be available.");
            return null;
        }
        PrivateKey clearpassKey = this.confService.getClearpassKey();
        if (clearpassKey == null) {
            logger.debug("No private key available to decrypt password.");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(clearpassKey.getAlgorithm());
            if (cipher == null) {
                throw new GuacamoleServerException("Failed to initialize cipher object with private key.");
            }
            cipher.init(2, clearpassKey);
            byte[] pass64 = DatatypeConverter.parseBase64Binary((String)encryptedPassword);
            byte[] cipherData = cipher.doFinal(pass64);
            return new String(cipherData, Charset.forName("UTF-8"));
        }
        catch (BadPaddingException e) {
            throw new GuacamoleServerException("Bad padding when decrypting cipher data.", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new GuacamoleServerException("Illegal block size while opening private key.", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new GuacamoleServerException("Specified private key for ClearPass decryption is invalid.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuacamoleServerException("Unexpected algorithm for the private key.", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new GuacamoleServerException("No such padding trying to initialize cipher with private key.", (Throwable)e);
        }
    }
}

