/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Controller for the "GUAC_TOTP_CODE" field which prompts the user to enter
 * the code generated by their authentication device.
 */
angular.module('guacTOTP').controller('authenticationCodeFieldController', ['$scope', '$window',
    function authenticationCodeFieldController($scope, $window) {

    /**
     * The secret key split into groups of at most four characters each, or
     * null if the secret key is not exposed.
     *
     * @type String[]
     */
    $scope.groupedSecret = $scope.field.secret && $scope.field.secret.match(/.{1,4}/g);

    /**
     * Whether the raw details of the secret key and TOTP configuration should
     * be shown. By default, such details are hidden. If the secret key is not
     * exposed, this property has no effect.
     */
    $scope.detailsShown = false;

    /**
     * Shows the raw details of the secret key and TOTP configuration. If the
     * secret key is not exposed, or the details are already shown, this
     * function has no effect.
     */
    $scope.showDetails = function showDetails() {
        $scope.detailsShown = true;
    };

    /**
     * Hides the raw details of the secret key and TOTP configuration. If the
     * details are already hidden, this function has no effect.
     */
    $scope.hideDetails = function hideDetails() {
        $scope.detailsShown = false;
    };

    /**
     * Attempts to open the "otpauth" URI containing the user's TOTP key,
     * invoking whichever application may be installed locally for handling
     * multi-factor authentication.
     */
    $scope.openKeyURI = function openKeyURI() {
        $window.open($scope.field.keyUri);
    };

}]);
angular.module('templates-main', ['app/ext/totp/templates/authenticationCodeField.html']);

angular.module('app/ext/totp/templates/authenticationCodeField.html', []).run(['$templateCache', function($templateCache) {
	$templateCache.put('app/ext/totp/templates/authenticationCodeField.html',
	"<div class=\"totp-code-field\" ng-class=\"{ 'totp-details-visible' : detailsShown }\">\n" +
	"\n" +
	"    <!-- Enroll user if necessary -->\n" +
	"    <div class=\"totp-enroll\" ng-show=\"field.qrCode\">\n" +
	"\n" +
	"        <p translate=\"TOTP.HELP_ENROLL_BARCODE\"></p>\n" +
	"\n" +
	"        <!-- Barcode and key details -->\n" +
	"        <div class=\"totp-qr-code\"><img ng-src=\"{{field.qrCode}}\" ng-click=\"openKeyURI()\"></div>\n" +
	"        <h3 class=\"totp-details-header\">\n" +
	"            {{'TOTP.SECTION_HEADER_DETAILS' | translate}}\n" +
	"            <a class=\"totp-show-details\" ng-click=\"showDetails()\">{{'TOTP.ACTION_SHOW_DETAILS' | translate}}</a>\n" +
	"            <a class=\"totp-hide-details\" ng-click=\"hideDetails()\">{{'TOTP.ACTION_HIDE_DETAILS' | translate}}</a>\n" +
	"        </h3>\n" +
	"        <table class=\"totp-details\">\n" +
	"            <tr>\n" +
	"                <th>{{'TOTP.FIELD_HEADER_SECRET_KEY' | translate}}</th>\n" +
	"                <td><span ng-repeat=\"group in groupedSecret\"\n" +
	"                          class=\"totp-detail\">{{ group }}</span></td>\n" +
	"            </tr>\n" +
	"            <tr>\n" +
	"                <th>{{'TOTP.FIELD_HEADER_DIGITS' | translate}}</th>\n" +
	"                <td><span class=\"totp-detail\">{{ field.digits }}</span></td>\n" +
	"            </tr>\n" +
	"            <tr>\n" +
	"                <th>{{'TOTP.FIELD_HEADER_ALGORITHM' | translate}}</th>\n" +
	"                <td><span class=\"totp-detail\">{{ field.mode }}</span></td>\n" +
	"            </tr>\n" +
	"            <tr>\n" +
	"                <th>{{'TOTP.FIELD_HEADER_INTERVAL' | translate}}</th>\n" +
	"                <td><span class=\"totp-detail\">{{ field.period }}</span></td>\n" +
	"            </tr>\n" +
	"        </table>\n" +
	"\n" +
	"        <p translate=\"TOTP.HELP_ENROLL_VERIFY\"\n" +
	"           translate-values=\"{ DIGITS : field.digits }\"></p>\n" +
	"\n" +
	"    </div>\n" +
	"\n" +
	"    <!-- Field for entry of the current TOTP code -->\n" +
	"    <div class=\"totp-code\">\n" +
	"        <input type=\"text\"\n" +
	"               placeholder=\"{{'TOTP.FIELD_PLACEHOLDER_CODE' |translate}}\"\n" +
	"               ng-model=\"model\" autocorrect=\"off\" autocapitalize=\"off\"/>\n" +
	"    </div>\n" +
	"\n" +
	"</div>");
}]);

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Config block which registers TOTP-specific field types.
 */
angular.module('guacTOTP').config(['formServiceProvider',
    function guacTOTPConfig(formServiceProvider) {

    // Define field for the TOTP code provided by the user
    formServiceProvider.registerFieldType('GUAC_TOTP_CODE', {
        module      : 'guacTOTP',
        controller  : 'authenticationCodeFieldController',
        templateUrl : 'app/ext/totp/templates/authenticationCodeField.html'
    });

}]);
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Module which provides handling for TOTP multi-factor authentication.
 */
angular.module('guacTOTP', [
    'form'
]);

// Ensure the guacTOTP module is loaded along with the rest of the app
angular.module('index').requires.push('guacTOTP');
