/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect;

import java.util.Collection;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.quickconnect.QuickConnectDirectory;
import org.apache.guacamole.auth.quickconnect.QuickConnectionGroup;
import org.apache.guacamole.auth.quickconnect.rest.QuickConnectREST;
import org.apache.guacamole.net.auth.AbstractUserContext;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleUser;

public class QuickConnectUserContext
extends AbstractUserContext {
    public static final String ROOT_IDENTIFIER = "ROOT";
    private final AuthenticationProvider authProvider;
    private final User self;
    private final QuickConnectDirectory connectionDirectory;
    private final ConnectionGroup rootGroup = new QuickConnectionGroup("ROOT", "ROOT");

    public QuickConnectUserContext(AuthenticationProvider authProvider, String username) throws GuacamoleException {
        this.connectionDirectory = new QuickConnectDirectory(this.rootGroup);
        this.self = new SimpleUser(username){

            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection)QuickConnectUserContext.this.connectionDirectory.getIdentifiers());
            }

            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(Collections.singleton(QuickConnectUserContext.ROOT_IDENTIFIER));
            }
        };
        this.authProvider = authProvider;
    }

    public QuickConnectDirectory getConnectionDirectory() {
        return this.connectionDirectory;
    }

    public User self() {
        return this.self;
    }

    public Object getResource() throws GuacamoleException {
        return new QuickConnectREST(this.connectionDirectory);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        return this.rootGroup;
    }
}

