/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.quickconnect.QuickConnectionGroup;
import org.apache.guacamole.auth.quickconnect.utility.QCParser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class QuickConnectDirectory
extends SimpleDirectory<Connection> {
    private final Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private final QuickConnectionGroup rootGroup;
    private final AtomicInteger connectionId;

    public QuickConnectDirectory(ConnectionGroup rootGroup) {
        this.rootGroup = (QuickConnectionGroup)rootGroup;
        this.connectionId = new AtomicInteger();
        super.setObjects(this.connections);
    }

    private int getNextConnectionID() {
        return this.connectionId.getAndIncrement();
    }

    public void add(Connection connection) throws GuacamoleException {
        this.connections.put(connection.getIdentifier(), connection);
    }

    public String create(GuacamoleConfiguration config) throws GuacamoleException {
        String newConnectionId = Integer.toString(this.getNextConnectionID());
        String name = QCParser.getName(config);
        SimpleConnection connection = new SimpleConnection(name, newConnectionId, config);
        connection.setParentIdentifier("ROOT");
        this.add((Connection)connection);
        this.rootGroup.addConnectionIdentifier(newConnectionId);
        return newConnectionId;
    }
}

