/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid.token;

import com.google.inject.Inject;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.openid.conf.ConfigurationService;
import org.apache.guacamole.auth.openid.token.NonceService;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidationService {
    private final Logger logger = LoggerFactory.getLogger(TokenValidationService.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private NonceService nonceService;

    public String processUsername(String token) throws GuacamoleException {
        HttpsJwks jwks = new HttpsJwks(this.confService.getJWKSEndpoint());
        HttpsJwksVerificationKeyResolver resolver = new HttpsJwksVerificationKeyResolver(jwks);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setMaxFutureValidityInMinutes(this.confService.getMaxTokenValidity()).setAllowedClockSkewInSeconds(this.confService.getAllowedClockSkew()).setRequireSubject().setExpectedIssuer(this.confService.getIssuer()).setExpectedAudience(this.confService.getClientID()).setVerificationKeyResolver(resolver).build();
        try {
            String usernameClaim = this.confService.getUsernameClaimType();
            JwtClaims claims = jwtConsumer.processToClaims(token);
            String nonce = claims.getStringClaimValue("nonce");
            if (nonce == null) {
                this.logger.info("Rejected OpenID token without nonce.");
                return null;
            }
            if (!this.nonceService.isValid(nonce)) {
                this.logger.debug("Rejected OpenID token with invalid/old nonce.");
                return null;
            }
            String username = claims.getStringClaimValue(usernameClaim);
            if (username != null) {
                return username;
            }
            this.logger.warn("Username claim \"{}\" missing from token. Perhaps the OpenID scope and/or username claim type are misconfigured?", (Object)usernameClaim);
        }
        catch (InvalidJwtException e) {
            this.logger.info("Rejected invalid OpenID token: {}", (Object)e.getMessage());
            this.logger.debug("Invalid JWT received.", (Throwable)e);
        }
        catch (MalformedClaimException e) {
            this.logger.info("Rejected OpenID token with malformed claim: {}", (Object)e.getMessage());
            this.logger.debug("Malformed claim within received JWT.", (Throwable)e);
        }
        return null;
    }
}

