/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.user;

import com.google.inject.Inject;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.EscapingService;
import org.apache.guacamole.auth.ldap.LDAPGuacamoleProperties;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.simple.SimpleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService {
    private final Logger logger = LoggerFactory.getLogger(UserService.class);
    @Inject
    private EscapingService escapingService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private ObjectQueryService queryService;

    public Map<String, User> getUsers(LDAPConnection ldapConnection) throws GuacamoleException {
        List<String> attributes = this.confService.getUsernameAttributes();
        List<LDAPEntry> results = this.queryService.search(ldapConnection, this.confService.getUserBaseDN(), this.confService.getUserSearchFilter(), attributes, null);
        return this.queryService.asMap(results, entry -> {
            String username = this.queryService.getIdentifier((LDAPEntry)entry, (Collection<String>)attributes);
            if (username == null) {
                this.logger.warn("User \"{}\" is missing a username attribute and will be ignored.", (Object)entry.getDN());
                return null;
            }
            return new SimpleUser(username);
        });
    }

    public List<String> getUserDNs(LDAPConnection ldapConnection, String username) throws GuacamoleException {
        List<LDAPEntry> results = this.queryService.search(ldapConnection, this.confService.getUserBaseDN(), this.confService.getUserSearchFilter(), this.confService.getUsernameAttributes(), username);
        ArrayList<String> userDNs = new ArrayList<String>(results.size());
        results.forEach(entry -> userDNs.add(entry.getDN()));
        return userDNs;
    }

    public String deriveUserDN(String username) throws GuacamoleException {
        List<String> usernameAttributes = this.confService.getUsernameAttributes();
        if (usernameAttributes.size() != 1) {
            this.logger.warn(String.format("Cannot directly derive user DN when multiple username attributes are specified. Please define an LDAP search DN using the \"%s\" property in your \"guacamole.properties\".", LDAPGuacamoleProperties.LDAP_SEARCH_BIND_DN.getName()));
            return null;
        }
        return this.escapingService.escapeDN(usernameAttributes.get(0)) + "=" + this.escapingService.escapeDN(username) + "," + this.confService.getUserBaseDN();
    }
}

