/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.group;

import com.google.inject.Inject;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.simple.SimpleUserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupService {
    private final Logger logger = LoggerFactory.getLogger(UserGroupService.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private ObjectQueryService queryService;

    private String getGroupSearchFilter() throws GuacamoleException {
        if (this.confService.getConfigurationBaseDN() != null) {
            return "(!(objectClass=guacConfigGroup))";
        }
        return "(objectClass=*)";
    }

    public Map<String, UserGroup> getUserGroups(LDAPConnection ldapConnection) throws GuacamoleException {
        String groupBaseDN = this.confService.getGroupBaseDN();
        if (groupBaseDN == null) {
            return Collections.emptyMap();
        }
        List<String> attributes = this.confService.getGroupNameAttributes();
        List<LDAPEntry> results = this.queryService.search(ldapConnection, groupBaseDN, this.getGroupSearchFilter(), attributes, null);
        return this.queryService.asMap(results, entry -> {
            String name = this.queryService.getIdentifier((LDAPEntry)entry, (Collection<String>)attributes);
            if (name != null) {
                return new SimpleUserGroup(name);
            }
            this.logger.debug("User group \"{}\" is missing a name attribute and will be ignored.", (Object)entry.getDN());
            return null;
        });
    }

    public List<LDAPEntry> getParentUserGroupEntries(LDAPConnection ldapConnection, String userDN) throws GuacamoleException {
        String groupBaseDN = this.confService.getGroupBaseDN();
        if (groupBaseDN == null) {
            return Collections.emptyList();
        }
        return this.queryService.search(ldapConnection, groupBaseDN, this.getGroupSearchFilter(), Collections.singleton("member"), userDN);
    }

    public Set<String> getParentUserGroupIdentifiers(LDAPConnection ldapConnection, String userDN) throws GuacamoleException {
        List<String> attributes = this.confService.getGroupNameAttributes();
        List<LDAPEntry> userGroups = this.getParentUserGroupEntries(ldapConnection, userDN);
        HashSet<String> identifiers = new HashSet<String>(userGroups.size());
        userGroups.forEach(entry -> {
            String name = this.queryService.getIdentifier((LDAPEntry)entry, (Collection<String>)attributes);
            if (name != null) {
                identifiers.add(name);
            } else {
                this.logger.debug("User group \"{}\" is missing a name attribute and will be ignored.", (Object)entry.getDN());
            }
        });
        return identifiers;
    }
}

