/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.connection;

import com.google.inject.Inject;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.EscapingService;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.auth.ldap.group.UserGroupService;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.StandardTokens;
import org.apache.guacamole.token.TokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    @Inject
    private EscapingService escapingService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private ObjectQueryService queryService;
    @Inject
    private UserGroupService userGroupService;

    public Map<String, Connection> getConnections(AuthenticatedUser user, LDAPConnection ldapConnection) throws GuacamoleException {
        String configurationBaseDN = this.confService.getConfigurationBaseDN();
        if (configurationBaseDN == null) {
            return Collections.emptyMap();
        }
        try {
            String userDN = ldapConnection.getAuthenticationDN();
            assert (userDN != null);
            String connectionSearchFilter = this.getConnectionSearchFilter(userDN, ldapConnection);
            List<LDAPEntry> results = this.queryService.search(ldapConnection, configurationBaseDN, connectionSearchFilter);
            TokenFilter tokenFilter = new TokenFilter();
            StandardTokens.addStandardTokens((TokenFilter)tokenFilter, (AuthenticatedUser)user);
            return this.queryService.asMap(results, entry -> {
                LDAPAttribute cn = entry.getAttribute("cn");
                if (cn == null) {
                    this.logger.warn("guacConfigGroup is missing a cn.");
                    return null;
                }
                LDAPAttribute protocol = entry.getAttribute("guacConfigProtocol");
                if (protocol == null) {
                    this.logger.warn("guacConfigGroup \"{}\" is missing the required \"guacConfigProtocol\" attribute.", (Object)cn.getStringValue());
                    return null;
                }
                GuacamoleConfiguration config = new GuacamoleConfiguration();
                config.setProtocol(protocol.getStringValue());
                LDAPAttribute parameterAttribute = entry.getAttribute("guacConfigParameter");
                if (parameterAttribute != null) {
                    Enumeration parameters = parameterAttribute.getStringValues();
                    while (parameters.hasMoreElements()) {
                        String parameter = (String)parameters.nextElement();
                        int equals = parameter.indexOf(61);
                        if (equals == -1) continue;
                        String name = parameter.substring(0, equals);
                        String value = parameter.substring(equals + 1);
                        config.setParameter(name, value);
                    }
                }
                tokenFilter.filterValues(config.getParameters());
                String name = cn.getStringValue();
                SimpleConnection connection = new SimpleConnection(name, name, config);
                connection.setParentIdentifier("ROOT");
                return connection;
            });
        }
        catch (LDAPException e) {
            throw new GuacamoleServerException("Error while querying for connections.", (Throwable)e);
        }
    }

    private String getConnectionSearchFilter(String userDN, LDAPConnection ldapConnection) throws LDAPException, GuacamoleException {
        StringBuilder connectionSearchFilter = new StringBuilder();
        connectionSearchFilter.append("(&(objectClass=guacConfigGroup)(|(member=");
        connectionSearchFilter.append(this.escapingService.escapeLDAPSearchFilter(userDN));
        connectionSearchFilter.append(")");
        List<LDAPEntry> userGroups = this.userGroupService.getParentUserGroupEntries(ldapConnection, userDN);
        if (!userGroups.isEmpty()) {
            for (LDAPEntry entry : userGroups) {
                connectionSearchFilter.append("(seeAlso=").append(this.escapingService.escapeLDAPSearchFilter(entry.getDN())).append(")");
            }
        }
        connectionSearchFilter.append("))");
        return connectionSearchFilter.toString();
    }
}

