/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralAuthHandler
implements LDAPAuthHandler {
    private final Logger logger = LoggerFactory.getLogger(ReferralAuthHandler.class);
    private final LDAPAuthProvider ldapAuth;

    public ReferralAuthHandler(String dn, String password) {
        byte[] passwordBytes;
        try {
            passwordBytes = password != null ? password.getBytes("UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Unexpected lack of support for UTF-8: {}", (Object)e.getMessage());
            this.logger.debug("Support for UTF-8 (as required by Java spec) not found.", (Throwable)e);
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
        this.ldapAuth = new LDAPAuthProvider(dn, passwordBytes);
    }

    @Override
    public LDAPAuthProvider getAuthProvider(String host, int port) {
        return this.ldapAuth;
    }
}

