/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPSearchResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.EscapingService;
import org.apache.guacamole.net.auth.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectQueryService {
    private final Logger logger = LoggerFactory.getLogger(ObjectQueryService.class);
    @Inject
    private EscapingService escapingService;
    @Inject
    private ConfigurationService confService;

    public String getIdentifier(LDAPEntry entry, Collection<String> attributes) {
        for (String identifierAttribute : attributes) {
            LDAPAttribute identifier = entry.getAttribute(identifierAttribute);
            if (identifier == null) continue;
            return identifier.getStringValue();
        }
        return null;
    }

    public String generateQuery(String filter, Collection<String> attributes, String attributeValue) {
        StringBuilder ldapQuery = new StringBuilder();
        ldapQuery.append("(&");
        ldapQuery.append(filter);
        if (attributes.size() > 1) {
            ldapQuery.append("(|");
        }
        for (String attribute : attributes) {
            ldapQuery.append("(");
            ldapQuery.append(this.escapingService.escapeLDAPSearchFilter(attribute));
            if (attributeValue != null) {
                ldapQuery.append("=");
                ldapQuery.append(this.escapingService.escapeLDAPSearchFilter(attributeValue));
                ldapQuery.append(")");
                continue;
            }
            ldapQuery.append("=*)");
        }
        if (attributes.size() > 1) {
            ldapQuery.append(")");
        }
        ldapQuery.append(")");
        return ldapQuery.toString();
    }

    public List<LDAPEntry> search(LDAPConnection ldapConnection, String baseDN, String query) throws GuacamoleException {
        this.logger.debug("Searching \"{}\" for objects matching \"{}\".", (Object)baseDN, (Object)query);
        try {
            LDAPSearchResults results = ldapConnection.search(baseDN, 2, query, null, false, this.confService.getLDAPSearchConstraints());
            ArrayList<LDAPEntry> entries = new ArrayList<LDAPEntry>(results.getCount());
            while (results.hasMore()) {
                try {
                    entries.add(results.next());
                }
                catch (LDAPReferralException e) {
                    if (this.confService.getFollowReferrals()) {
                        this.logger.error("Could not follow referral: {}", (Object)e.getFailedReferral());
                        this.logger.debug("Error encountered trying to follow referral.", (Throwable)e);
                        throw new GuacamoleServerException("Could not follow LDAP referral.", (Throwable)e);
                    }
                    this.logger.warn("Given a referral, but referrals are disabled. Error was: {}", (Object)e.getMessage());
                    this.logger.debug("Got a referral, but configured to not follow them.", (Throwable)e);
                }
            }
            return entries;
        }
        catch (LDAPException | GuacamoleException e) {
            throw new GuacamoleServerException("Unable to query list of objects from LDAP directory.", e);
        }
    }

    public List<LDAPEntry> search(LDAPConnection ldapConnection, String baseDN, String filter, Collection<String> attributes, String attributeValue) throws GuacamoleException {
        String query = this.generateQuery(filter, attributes, attributeValue);
        return this.search(ldapConnection, baseDN, query);
    }

    public <ObjectType extends Identifiable> Map<String, ObjectType> asMap(List<LDAPEntry> entries, Function<LDAPEntry, ObjectType> mapper) {
        HashMap<String, Identifiable> objects = new HashMap<String, Identifiable>(entries.size());
        for (LDAPEntry entry : entries) {
            Identifiable object = (Identifiable)mapper.apply(entry);
            if (object == null) {
                this.logger.debug("Ignoring object \"{}\".", (Object)entry.getDN());
                continue;
            }
            String identifier = object.getIdentifier();
            if (objects.putIfAbsent(identifier, object) == null) continue;
            this.logger.warn("Multiple objects ambiguously map to the same identifier (\"{}\"). Ignoring \"{}\" as a duplicate.", (Object)identifier, (Object)entry.getDN());
        }
        return objects;
    }
}

