/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPJSSEStartTLSFactory;
import java.io.UnsupportedEncodingException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.EncryptionMethod;
import org.apache.guacamole.auth.ldap.ReferralAuthHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConnectionService {
    private final Logger logger = LoggerFactory.getLogger(LDAPConnectionService.class);
    @Inject
    private ConfigurationService confService;

    private LDAPConnection createLDAPConnection() throws GuacamoleException {
        EncryptionMethod encryptionMethod = this.confService.getEncryptionMethod();
        switch (encryptionMethod) {
            case NONE: {
                this.logger.debug("Connection to LDAP server without encryption.");
                return new LDAPConnection();
            }
            case SSL: {
                this.logger.debug("Connecting to LDAP server using SSL/TLS.");
                return new LDAPConnection(new LDAPJSSESecureSocketFactory());
            }
            case STARTTLS: {
                this.logger.debug("Connecting to LDAP server using STARTTLS.");
                return new LDAPConnection(new LDAPJSSEStartTLSFactory());
            }
        }
        throw new GuacamoleUnsupportedException("Unimplemented encryption method: " + (Object)((Object)encryptionMethod));
    }

    public LDAPConnection bindAs(String userDN, String password) throws GuacamoleException {
        LDAPConnection ldapConnection = this.createLDAPConnection();
        LDAPConstraints ldapConstraints = ldapConnection.getConstraints();
        if (ldapConstraints == null) {
            ldapConstraints = new LDAPConstraints();
        }
        ldapConstraints.setReferralFollowing(this.confService.getFollowReferrals());
        if (userDN != null && !userDN.isEmpty()) {
            ldapConstraints.setReferralHandler(new ReferralAuthHandler(userDN, password));
        }
        ldapConstraints.setHopLimit(this.confService.getMaxReferralHops());
        ldapConstraints.setTimeLimit(this.confService.getOperationTimeout() * 1000);
        ldapConnection.setConstraints(ldapConstraints);
        try {
            ldapConnection.connect(this.confService.getServerHostname(), this.confService.getServerPort());
            if (this.confService.getEncryptionMethod() == EncryptionMethod.STARTTLS) {
                ldapConnection.startTLS();
            }
        }
        catch (LDAPException e) {
            this.logger.error("Unable to connect to LDAP server: {}", (Object)e.getMessage());
            this.logger.debug("Failed to connect to LDAP server.", (Throwable)e);
            return null;
        }
        try {
            byte[] passwordBytes;
            try {
                passwordBytes = password != null ? password.getBytes("UTF-8") : null;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Unexpected lack of support for UTF-8: {}", (Object)e.getMessage());
                this.logger.debug("Support for UTF-8 (as required by Java spec) not found.", (Throwable)e);
                this.disconnect(ldapConnection);
                return null;
            }
            ldapConnection.bind(3, userDN, passwordBytes);
        }
        catch (LDAPException e) {
            this.logger.debug("LDAP bind failed.", (Throwable)e);
            this.disconnect(ldapConnection);
            return null;
        }
        return ldapConnection;
    }

    public void disconnect(LDAPConnection ldapConnection) {
        try {
            ldapConnection.disconnect();
        }
        catch (LDAPException e) {
            this.logger.warn("Unable to disconnect from LDAP server: {}", (Object)e.getMessage());
            this.logger.debug("LDAP disconnect failed.", (Throwable)e);
        }
    }
}

