/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import com.novell.ldap.LDAPSearchConstraints;
import java.util.Collections;
import java.util.List;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.DereferenceAliasesMode;
import org.apache.guacamole.auth.ldap.EncryptionMethod;
import org.apache.guacamole.auth.ldap.LDAPGuacamoleProperties;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService {
    private final Logger logger = LoggerFactory.getLogger(ConfigurationService.class);
    @Inject
    private Environment environment;

    public String getServerHostname() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_HOSTNAME, (Object)"localhost");
    }

    public int getServerPort() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_PORT, (Object)this.getEncryptionMethod().DEFAULT_PORT);
    }

    public List<String> getUsernameAttributes() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USERNAME_ATTRIBUTE, Collections.singletonList("uid"));
    }

    public String getUserBaseDN() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USER_BASE_DN);
    }

    public String getConfigurationBaseDN() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_CONFIG_BASE_DN);
    }

    public List<String> getGroupNameAttributes() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_GROUP_NAME_ATTRIBUTE, Collections.singletonList("cn"));
    }

    public String getGroupBaseDN() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_GROUP_BASE_DN);
    }

    public String getSearchBindDN() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_SEARCH_BIND_DN);
    }

    public String getSearchBindPassword() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_SEARCH_BIND_PASSWORD);
    }

    public EncryptionMethod getEncryptionMethod() throws GuacamoleException {
        return (EncryptionMethod)((Object)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_ENCRYPTION_METHOD, (Object)EncryptionMethod.NONE));
    }

    private int getMaxResults() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MAX_SEARCH_RESULTS, (Object)1000);
    }

    private DereferenceAliasesMode getDereferenceAliases() throws GuacamoleException {
        return (DereferenceAliasesMode)((Object)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_DEREFERENCE_ALIASES, (Object)DereferenceAliasesMode.NEVER));
    }

    public boolean getFollowReferrals() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_FOLLOW_REFERRALS, (Object)false);
    }

    public LDAPSearchConstraints getLDAPSearchConstraints() throws GuacamoleException {
        LDAPSearchConstraints constraints = new LDAPSearchConstraints();
        constraints.setMaxResults(this.getMaxResults());
        constraints.setDereference(this.getDereferenceAliases().DEREF_VALUE);
        return constraints;
    }

    public int getMaxReferralHops() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MAX_REFERRAL_HOPS, (Object)5);
    }

    public String getUserSearchFilter() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USER_SEARCH_FILTER, (Object)"(objectClass=*)");
    }

    public int getOperationTimeout() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_OPERATION_TIMEOUT, (Object)30);
    }
}

