/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.novell.ldap.LDAPConnection;
import java.util.List;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.ConfigurationService;
import org.apache.guacamole.auth.ldap.LDAPConnectionService;
import org.apache.guacamole.auth.ldap.group.UserGroupService;
import org.apache.guacamole.auth.ldap.user.AuthenticatedUser;
import org.apache.guacamole.auth.ldap.user.UserContext;
import org.apache.guacamole.auth.ldap.user.UserService;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderService {
    private final Logger logger = LoggerFactory.getLogger(AuthenticationProviderService.class);
    @Inject
    private LDAPConnectionService ldapService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private UserService userService;
    @Inject
    private UserGroupService userGroupService;
    @Inject
    private Provider<AuthenticatedUser> authenticatedUserProvider;
    @Inject
    private Provider<UserContext> userContextProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserBindDN(String username) throws GuacamoleException {
        String searchBindDN = this.confService.getSearchBindDN();
        if (searchBindDN != null) {
            LDAPConnection searchConnection = this.ldapService.bindAs(searchBindDN, this.confService.getSearchBindPassword());
            if (searchConnection == null) {
                this.logger.error("Unable to bind using search DN \"{}\"", (Object)searchBindDN);
                return null;
            }
            try {
                List<String> userDNs = this.userService.getUserDNs(searchConnection, username);
                if (userDNs.isEmpty()) {
                    String string = null;
                    return string;
                }
                if (userDNs.size() != 1) {
                    this.logger.warn("Multiple DNs possible for user \"{}\": {}", (Object)username, userDNs);
                    String string = null;
                    return string;
                }
                String string = userDNs.get(0);
                return string;
            }
            finally {
                this.ldapService.disconnect(searchConnection);
            }
        }
        return this.userService.deriveUserDN(username);
    }

    private LDAPConnection bindAs(Credentials credentials) throws GuacamoleException {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (username == null || username.isEmpty()) {
            this.logger.debug("Anonymous bind is not currently allowed by the LDAP authentication provider.");
            return null;
        }
        if (password == null || password.isEmpty()) {
            this.logger.debug("Anonymous bind is not currently allowed by the LDAP authentication provider.");
            return null;
        }
        String userDN = this.getUserBindDN(username);
        if (userDN == null) {
            this.logger.debug("Unable to determine DN for user \"{}\".", (Object)username);
            return null;
        }
        return this.ldapService.bindAs(userDN, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        LDAPConnection ldapConnection;
        try {
            ldapConnection = this.bindAs(credentials);
        }
        catch (GuacamoleException e) {
            this.logger.error("Cannot bind with LDAP server: {}", (Object)e.getMessage());
            this.logger.debug("Error binding with LDAP server.", (Throwable)e);
            ldapConnection = null;
        }
        if (ldapConnection == null) {
            throw new GuacamoleInvalidCredentialsException("Permission denied.", CredentialsInfo.USERNAME_PASSWORD);
        }
        try {
            Set<String> effectiveGroups = this.userGroupService.getParentUserGroupIdentifiers(ldapConnection, ldapConnection.getAuthenticationDN());
            AuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
            authenticatedUser.init(credentials, effectiveGroups);
            AuthenticatedUser authenticatedUser2 = authenticatedUser;
            return authenticatedUser2;
        }
        finally {
            this.ldapService.disconnect(ldapConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserContext getUserContext(org.apache.guacamole.net.auth.AuthenticatedUser authenticatedUser) throws GuacamoleException {
        Credentials credentials = authenticatedUser.getCredentials();
        LDAPConnection ldapConnection = this.bindAs(credentials);
        if (ldapConnection == null) {
            return null;
        }
        try {
            UserContext userContext = this.userContextProvider.get();
            userContext.init(authenticatedUser, ldapConnection);
            UserContext userContext2 = userContext;
            return userContext2;
        }
        finally {
            this.ldapService.disconnect(ldapConnection);
        }
    }
}

