/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.postgresql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.postgresql.PostgreSQLEnvironment;
import org.mybatis.guice.datasource.helper.JdbcHelper;

public class PostgreSQLAuthenticationProviderModule
implements Module {
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();

    public PostgreSQLAuthenticationProviderModule(PostgreSQLEnvironment environment) throws GuacamoleException {
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getPostgreSQLHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getPostgreSQLPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getPostgreSQLDatabase());
        this.myBatisProperties.setProperty("JDBC.username", environment.getPostgreSQLUsername());
        this.myBatisProperties.setProperty("JDBC.password", environment.getPostgreSQLPassword());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
    }

    @Override
    public void configure(Binder binder) {
        JdbcHelper.PostgreSQL.configure(binder);
        Names.bindProperties(binder, this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith(Names.named("JDBC.driverProperties")).toInstance(this.driverProperties);
    }
}

