/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.activeconnection.ActiveConnectionPermissionService;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.EntityService;
import org.apache.guacamole.auth.jdbc.base.EntityType;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObject;
import org.apache.guacamole.auth.jdbc.permission.ConnectionGroupPermissionService;
import org.apache.guacamole.auth.jdbc.permission.ConnectionPermissionService;
import org.apache.guacamole.auth.jdbc.permission.SharingProfilePermissionService;
import org.apache.guacamole.auth.jdbc.permission.SystemPermissionService;
import org.apache.guacamole.auth.jdbc.permission.UserGroupPermissionService;
import org.apache.guacamole.auth.jdbc.permission.UserPermissionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;

public abstract class ModeledPermissions<ModelType extends EntityModel>
extends ModeledDirectoryObject<ModelType>
implements Permissions {
    @Inject
    private EntityService entityService;
    @Inject
    private SystemPermissionService systemPermissionService;
    @Inject
    private ConnectionPermissionService connectionPermissionService;
    @Inject
    private ConnectionGroupPermissionService connectionGroupPermissionService;
    @Inject
    private SharingProfilePermissionService sharingProfilePermissionService;
    @Inject
    private ActiveConnectionPermissionService activeConnectionPermissionService;
    @Inject
    private UserPermissionService userPermissionService;
    @Inject
    private UserGroupPermissionService userGroupPermissionService;

    public boolean isUser() {
        return ((EntityModel)this.getModel()).getEntityType() == EntityType.USER;
    }

    public boolean isUserGroup() {
        return ((EntityModel)this.getModel()).getEntityType() == EntityType.USER_GROUP;
    }

    public boolean isAdministrator() throws GuacamoleException {
        SystemPermissionSet systemPermissionSet = this.getEffective().getSystemPermissions();
        return systemPermissionSet.hasPermission(SystemPermission.Type.ADMINISTER);
    }

    public SystemPermissionSet getSystemPermissions() throws GuacamoleException {
        return this.systemPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
        return this.connectionPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
        return this.connectionGroupPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getSharingProfilePermissions() throws GuacamoleException {
        return this.sharingProfilePermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getActiveConnectionPermissions() throws GuacamoleException {
        return this.activeConnectionPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
        return this.userPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public ObjectPermissionSet getUserGroupPermissions() throws GuacamoleException {
        return this.userGroupPermissionService.getPermissionSet(this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)this, Collections.emptySet());
    }

    public Set<String> getEffectiveUserGroups() {
        return this.entityService.retrieveEffectiveGroups(this, Collections.emptySet());
    }

    public Permissions getEffective() {
        final ModeledAuthenticatedUser authenticatedUser = this.getCurrentUser();
        final Set<String> effectiveGroups = authenticatedUser.getIdentifier().equals(this.getIdentifier()) ? this.entityService.retrieveEffectiveGroups(this, authenticatedUser.getEffectiveUserGroups()) : this.getEffectiveUserGroups();
        return new Permissions(){

            public ObjectPermissionSet getActiveConnectionPermissions() throws GuacamoleException {
                return ModeledPermissions.this.activeConnectionPermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return ModeledPermissions.this.connectionGroupPermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return ModeledPermissions.this.connectionPermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public ObjectPermissionSet getSharingProfilePermissions() throws GuacamoleException {
                return ModeledPermissions.this.sharingProfilePermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public SystemPermissionSet getSystemPermissions() throws GuacamoleException {
                return ModeledPermissions.this.systemPermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
                return ModeledPermissions.this.userPermissionService.getPermissionSet(authenticatedUser, (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }

            public ObjectPermissionSet getUserGroupPermissions() throws GuacamoleException {
                return ModeledPermissions.this.userGroupPermissionService.getPermissionSet(ModeledPermissions.this.getCurrentUser(), (ModeledPermissions<? extends EntityModel>)ModeledPermissions.this, (Set<String>)effectiveGroups);
            }
        };
    }
}

