/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.DirectoryObjectService;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObject;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.base.ModeledObject;
import org.apache.guacamole.auth.jdbc.base.ObjectModel;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionModel;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.mybatis.guice.transactional.Transactional;

public abstract class ModeledDirectoryObjectService<InternalType extends ModeledDirectoryObject<ModelType>, ExternalType extends Identifiable, ModelType extends ObjectModel>
implements DirectoryObjectService<InternalType, ExternalType> {
    private static final ObjectPermission.Type[] IMPLICIT_OBJECT_PERMISSIONS = new ObjectPermission.Type[]{ObjectPermission.Type.READ, ObjectPermission.Type.UPDATE, ObjectPermission.Type.DELETE, ObjectPermission.Type.ADMINISTER};

    protected abstract ModeledDirectoryObjectMapper<ModelType> getObjectMapper();

    protected abstract ObjectPermissionMapper getPermissionMapper();

    protected abstract InternalType getObjectInstance(ModeledAuthenticatedUser var1, ModelType var2) throws GuacamoleException;

    protected abstract ModelType getModelInstance(ModeledAuthenticatedUser var1, ExternalType var2) throws GuacamoleException;

    protected abstract boolean hasCreatePermission(ModeledAuthenticatedUser var1) throws GuacamoleException;

    protected boolean hasObjectPermission(ModeledAuthenticatedUser user, String identifier, ObjectPermission.Type type) throws GuacamoleException {
        ObjectPermissionSet permissionSet = this.getEffectivePermissionSet(user);
        return user.getUser().isAdministrator() || permissionSet.hasPermission(type, identifier);
    }

    protected abstract ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser var1) throws GuacamoleException;

    protected Collection<InternalType> getObjectInstances(ModeledAuthenticatedUser currentUser, Collection<ModelType> models) throws GuacamoleException {
        ArrayList<InternalType> objects = new ArrayList<InternalType>(models.size());
        for (ObjectModel model : models) {
            objects.add(this.getObjectInstance(currentUser, model));
        }
        return objects;
    }

    protected void beforeCreate(ModeledAuthenticatedUser user, ExternalType object, ModelType model) throws GuacamoleException {
        if (!user.getUser().isAdministrator() && !this.hasCreatePermission(user)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }

    protected void beforeUpdate(ModeledAuthenticatedUser user, InternalType object, ModelType model) throws GuacamoleException {
        if (!this.hasObjectPermission(user, ((ObjectModel)model).getIdentifier(), ObjectPermission.Type.UPDATE)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }

    protected void beforeDelete(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        if (!this.hasObjectPermission(user, identifier, ObjectPermission.Type.DELETE)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }

    protected boolean isValidIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            if (Character.isDigit(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected Collection<String> filterIdentifiers(Collection<String> identifiers) {
        ArrayList<String> validIdentifiers = new ArrayList<String>(identifiers.size());
        for (String identifier : identifiers) {
            if (!this.isValidIdentifier(identifier)) continue;
            validIdentifiers.add(identifier);
        }
        return validIdentifiers;
    }

    @Override
    public InternalType retrieveObject(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        Collection<InternalType> objects = this.retrieveObjects(user, Collections.singleton(identifier));
        if (objects.isEmpty()) {
            return null;
        }
        assert (objects.size() == 1);
        return (InternalType)((ModeledDirectoryObject)objects.iterator().next());
    }

    @Override
    public Collection<InternalType> retrieveObjects(ModeledAuthenticatedUser user, Collection<String> identifiers) throws GuacamoleException {
        if ((identifiers = this.filterIdentifiers(identifiers)).isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ModelType> objects = user.getUser().isAdministrator() ? this.getObjectMapper().select(identifiers) : this.getObjectMapper().selectReadable((UserModel)user.getUser().getModel(), identifiers, user.getEffectiveUserGroups());
        return this.getObjectInstances(user, objects);
    }

    protected Collection<ObjectPermissionModel> getImplicitPermissions(ModeledAuthenticatedUser user, ModelType model) {
        ArrayList<ObjectPermissionModel> implicitPermissions = new ArrayList<ObjectPermissionModel>(IMPLICIT_OBJECT_PERMISSIONS.length);
        UserModel userModel = (UserModel)user.getUser().getModel();
        for (ObjectPermission.Type permission : IMPLICIT_OBJECT_PERMISSIONS) {
            ObjectPermissionModel permissionModel = new ObjectPermissionModel();
            permissionModel.setEntityID(userModel.getEntityID());
            permissionModel.setType(permission);
            permissionModel.setObjectIdentifier(((ObjectModel)model).getIdentifier());
            implicitPermissions.add(permissionModel);
        }
        return implicitPermissions;
    }

    @Override
    @Transactional
    public InternalType createObject(ModeledAuthenticatedUser user, ExternalType object) throws GuacamoleException {
        ModelType model = this.getModelInstance(user, object);
        this.beforeCreate(user, object, model);
        this.getObjectMapper().insert(model);
        object.setIdentifier(((ObjectModel)model).getIdentifier());
        this.getPermissionMapper().insert(this.getImplicitPermissions(user, model));
        if (((ObjectModel)model).hasArbitraryAttributes()) {
            this.getObjectMapper().insertAttributes(model);
        }
        return this.getObjectInstance(user, model);
    }

    @Override
    public void deleteObject(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        this.beforeDelete(user, identifier);
        this.getObjectMapper().delete(identifier);
    }

    @Override
    @Transactional
    public void updateObject(ModeledAuthenticatedUser user, InternalType object) throws GuacamoleException {
        ObjectModel model = (ObjectModel)((ModeledObject)object).getModel();
        this.beforeUpdate(user, object, model);
        this.getObjectMapper().update(model);
        this.getObjectMapper().deleteAttributes(model);
        if (model.hasArbitraryAttributes()) {
            this.getObjectMapper().insertAttributes(model);
        }
    }

    @Override
    public Set<String> getIdentifiers(ModeledAuthenticatedUser user) throws GuacamoleException {
        if (user.getUser().isAdministrator()) {
            return this.getObjectMapper().selectIdentifiers();
        }
        return this.getObjectMapper().selectReadableIdentifiers((UserModel)user.getUser().getModel(), user.getEffectiveUserGroups());
    }
}

