/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.activeconnection;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.sharing.ConnectionSharingService;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.credentials.UserCredentials;

public class TrackedActiveConnection
extends RestrictedObject
implements ActiveConnection {
    @Inject
    private ConnectionSharingService sharingService;
    private String identifier;
    private ActiveConnectionRecord connectionRecord;
    private ModeledConnection connection;
    private String sharingProfileIdentifier;
    private Date startDate;
    private String remoteHost;
    private String username;
    private GuacamoleTunnel tunnel;

    public void init(ModeledAuthenticatedUser currentUser, ActiveConnectionRecord activeConnectionRecord, boolean includeSensitiveInformation) {
        super.init(currentUser);
        this.connectionRecord = activeConnectionRecord;
        this.connection = activeConnectionRecord.getConnection();
        this.sharingProfileIdentifier = activeConnectionRecord.getSharingProfileIdentifier();
        this.identifier = activeConnectionRecord.getUUID().toString();
        this.startDate = activeConnectionRecord.getStartDate();
        if (includeSensitiveInformation) {
            this.remoteHost = activeConnectionRecord.getRemoteHost();
            this.tunnel = activeConnectionRecord.getTunnel();
            this.username = activeConnectionRecord.getUsername();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ModeledConnection getConnection() {
        return this.connection;
    }

    public String getConnectionIdentifier() {
        return this.connection.getIdentifier();
    }

    public void setConnectionIdentifier(String connnectionIdentifier) {
        throw new UnsupportedOperationException("The connection identifier of TrackedActiveConnection is inherited from the underlying connection.");
    }

    public String getSharingProfileIdentifier() {
        return this.sharingProfileIdentifier;
    }

    public void setSharingProfileIdentifier(String sharingProfileIdentifier) {
        this.sharingProfileIdentifier = sharingProfileIdentifier;
    }

    public UserCredentials getSharingCredentials(String identifier) throws GuacamoleException {
        return this.sharingService.generateTemporaryCredentials(this.getCurrentUser(), this.connectionRecord, identifier);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GuacamoleTunnel getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(GuacamoleTunnel tunnel) {
        this.tunnel = tunnel;
    }
}

