/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connectiongroup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupMapper;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupModel;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.auth.jdbc.permission.ConnectionGroupPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.protocol.GuacamoleClientInformation;

public class ConnectionGroupService
extends ModeledChildDirectoryObjectService<ModeledConnectionGroup, ConnectionGroup, ConnectionGroupModel> {
    @Inject
    private ConnectionGroupMapper connectionGroupMapper;
    @Inject
    private ConnectionGroupPermissionMapper connectionGroupPermissionMapper;
    @Inject
    private Provider<ModeledConnectionGroup> connectionGroupProvider;
    @Inject
    private GuacamoleTunnelService tunnelService;

    @Override
    protected ModeledDirectoryObjectMapper<ConnectionGroupModel> getObjectMapper() {
        return this.connectionGroupMapper;
    }

    @Override
    protected ObjectPermissionMapper getPermissionMapper() {
        return this.connectionGroupPermissionMapper;
    }

    @Override
    protected ModeledConnectionGroup getObjectInstance(ModeledAuthenticatedUser currentUser, ConnectionGroupModel model) {
        ModeledConnectionGroup connectionGroup = this.connectionGroupProvider.get();
        connectionGroup.init(currentUser, model);
        return connectionGroup;
    }

    @Override
    protected ConnectionGroupModel getModelInstance(ModeledAuthenticatedUser currentUser, ConnectionGroup object) {
        ConnectionGroupModel model = new ConnectionGroupModel();
        ModeledConnectionGroup connectionGroup = this.getObjectInstance(currentUser, model);
        connectionGroup.setParentIdentifier(object.getParentIdentifier());
        connectionGroup.setName(object.getName());
        connectionGroup.setType(object.getType());
        connectionGroup.setAttributes(object.getAttributes());
        return model;
    }

    @Override
    protected boolean hasCreatePermission(ModeledAuthenticatedUser user) throws GuacamoleException {
        SystemPermissionSet permissionSet = user.getUser().getEffectivePermissions().getSystemPermissions();
        return permissionSet.hasPermission(SystemPermission.Type.CREATE_CONNECTION_GROUP);
    }

    @Override
    protected ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getConnectionGroupPermissions();
    }

    @Override
    protected ObjectPermissionSet getParentEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getConnectionGroupPermissions();
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, ConnectionGroup object, ConnectionGroupModel model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Connection group names must not be blank.");
        }
        ConnectionGroupModel existing = this.connectionGroupMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null) {
            throw new GuacamoleClientException("The connection group \"" + model.getName() + "\" already exists.");
        }
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, ModeledConnectionGroup object, ConnectionGroupModel model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Connection group names must not be blank.");
        }
        ConnectionGroupModel existing = this.connectionGroupMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null && !existing.getObjectID().equals(model.getObjectID())) {
            throw new GuacamoleClientException("The connection group \"" + model.getName() + "\" already exists.");
        }
        String relativeParentIdentifier = model.getParentIdentifier();
        while (relativeParentIdentifier != null) {
            if (relativeParentIdentifier.equals(model.getIdentifier())) {
                throw new GuacamoleUnsupportedException("A connection group may not contain itself.");
            }
            ModeledConnectionGroup relativeParentGroup = (ModeledConnectionGroup)this.retrieveObject(user, relativeParentIdentifier);
            relativeParentIdentifier = ((ConnectionGroupModel)relativeParentGroup.getModel()).getParentIdentifier();
        }
    }

    public Set<String> getIdentifiersWithin(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        if (user.getUser().isAdministrator()) {
            return this.connectionGroupMapper.selectIdentifiersWithin(identifier);
        }
        return this.connectionGroupMapper.selectReadableIdentifiersWithin((UserModel)user.getUser().getModel(), identifier, user.getEffectiveUserGroups());
    }

    public GuacamoleTunnel connect(ModeledAuthenticatedUser user, ModeledConnectionGroup connectionGroup, GuacamoleClientInformation info) throws GuacamoleException {
        if (this.hasObjectPermission(user, connectionGroup.getIdentifier(), ObjectPermission.Type.READ)) {
            return this.tunnelService.getGuacamoleTunnel(user, connectionGroup, info);
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

