/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.activeconnection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.activeconnection.TrackedActiveConnection;
import org.apache.guacamole.auth.jdbc.base.DirectoryObjectService;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ActiveConnection;

public class ActiveConnectionService
implements DirectoryObjectService<TrackedActiveConnection, ActiveConnection> {
    @Inject
    private GuacamoleTunnelService tunnelService;
    @Inject
    private Provider<TrackedActiveConnection> trackedActiveConnectionProvider;

    @Override
    public TrackedActiveConnection retrieveObject(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        Collection<TrackedActiveConnection> objects = this.retrieveObjects(user, Collections.singleton(identifier));
        if (objects.isEmpty()) {
            return null;
        }
        assert (objects.size() == 1);
        return objects.iterator().next();
    }

    @Override
    public Collection<TrackedActiveConnection> retrieveObjects(ModeledAuthenticatedUser user, Collection<String> identifiers) throws GuacamoleException {
        String username = user.getIdentifier();
        boolean isAdmin = user.getUser().isAdministrator();
        HashSet<String> identifierSet = new HashSet<String>(identifiers);
        Collection<ActiveConnectionRecord> records = this.tunnelService.getActiveConnections(user);
        ArrayList<TrackedActiveConnection> activeConnections = new ArrayList<TrackedActiveConnection>(identifiers.size());
        for (ActiveConnectionRecord record : records) {
            boolean includeSensitiveInformation;
            boolean bl = includeSensitiveInformation = isAdmin || username.equals(record.getUsername());
            if (!identifierSet.contains(record.getUUID().toString())) continue;
            TrackedActiveConnection activeConnection = this.trackedActiveConnectionProvider.get();
            activeConnection.init(user, record, includeSensitiveInformation);
            activeConnections.add(activeConnection);
        }
        return activeConnections;
    }

    @Override
    public void deleteObject(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        GuacamoleTunnel tunnel;
        if (!user.getUser().isAdministrator()) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        TrackedActiveConnection activeConnection = this.retrieveObject(user, identifier);
        if (activeConnection != null && (tunnel = activeConnection.getTunnel()) != null && tunnel.isOpen()) {
            tunnel.close();
        }
    }

    @Override
    public Set<String> getIdentifiers(ModeledAuthenticatedUser user) throws GuacamoleException {
        Collection<ActiveConnectionRecord> records = this.tunnelService.getActiveConnections(user);
        HashSet<String> identifiers = new HashSet<String>(records.size());
        for (ActiveConnectionRecord record : records) {
            identifiers.add(record.getUUID().toString());
        }
        return identifiers;
    }

    @Override
    public TrackedActiveConnection createObject(ModeledAuthenticatedUser user, ActiveConnection object) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void updateObject(ModeledAuthenticatedUser user, TrackedActiveConnection object) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

