/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.activeconnection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.activeconnection.ActiveConnectionPermissionSet;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.permission.AbstractPermissionService;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionService;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;

public class ActiveConnectionPermissionService
extends AbstractPermissionService<ObjectPermissionSet, ObjectPermission>
implements ObjectPermissionService {
    @Inject
    private GuacamoleTunnelService tunnelService;
    @Inject
    private Provider<ActiveConnectionPermissionSet> activeConnectionPermissionSetProvider;

    @Override
    public boolean hasPermission(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, ObjectPermission.Type type, String identifier, Set<String> effectiveGroups) throws GuacamoleException {
        Set<ObjectPermission> permissions = this.retrievePermissions(user, targetEntity, effectiveGroups);
        ObjectPermission permission = new ObjectPermission(type, identifier);
        return permissions.contains(permission);
    }

    @Override
    public Set<ObjectPermission> retrievePermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Set<String> effectiveGroups) throws GuacamoleException {
        if (this.canReadPermissions(user, targetEntity)) {
            boolean isAdmin = targetEntity.isAdministrator();
            Collection<ActiveConnectionRecord> records = this.tunnelService.getActiveConnections(user);
            HashSet<ObjectPermission> permissions = new HashSet<ObjectPermission>();
            for (ActiveConnectionRecord record : records) {
                String identifier = record.getUUID().toString();
                permissions.add(new ObjectPermission(ObjectPermission.Type.READ, identifier));
                if (!isAdmin) continue;
                permissions.add(new ObjectPermission(ObjectPermission.Type.DELETE, identifier));
            }
            return permissions;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public Collection<String> retrieveAccessibleIdentifiers(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission.Type> permissionTypes, Collection<String> identifiers, Set<String> effectiveGroups) throws GuacamoleException {
        Set<ObjectPermission> permissions = this.retrievePermissions(user, targetEntity, effectiveGroups);
        ArrayList<String> accessibleObjects = new ArrayList<String>(permissions.size());
        block0: for (String identifier : identifiers) {
            for (ObjectPermission.Type permissionType : permissionTypes) {
                ObjectPermission permission = new ObjectPermission(permissionType, identifier);
                if (!permissions.contains(permission)) continue;
                accessibleObjects.add(identifier);
                continue block0;
            }
        }
        return accessibleObjects;
    }

    @Override
    public ObjectPermissionSet getPermissionSet(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Set<String> effectiveGroups) throws GuacamoleException {
        ActiveConnectionPermissionSet permissionSet = this.activeConnectionPermissionSetProvider.get();
        permissionSet.init(user, targetEntity, effectiveGroups);
        return permissionSet;
    }

    @Override
    public void createPermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void deletePermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

