/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.mysql;

import com.google.common.collect.ComparisonChain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLVersion {
    private final Pattern MARIADB_VERSION = Pattern.compile("^.*-([0-9]+)\\.([0-9]+)\\.([0-9]+)-MariaDB$");
    private final Pattern MYSQL_VERSION = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+).*$");
    private final boolean isMariaDB;
    private final int major;
    private final int minor;
    private final int patch;

    public MySQLVersion(int major, int minor, int patch, boolean isMariaDB) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.isMariaDB = isMariaDB;
    }

    public MySQLVersion(String version) throws IllegalArgumentException {
        Matcher mariadb = this.MARIADB_VERSION.matcher(version);
        if (mariadb.matches()) {
            this.major = Integer.parseInt(mariadb.group(1));
            this.minor = Integer.parseInt(mariadb.group(2));
            this.patch = Integer.parseInt(mariadb.group(3));
            this.isMariaDB = true;
            return;
        }
        Matcher mysql = this.MYSQL_VERSION.matcher(version);
        if (mysql.matches()) {
            this.major = Integer.parseInt(mysql.group(1));
            this.minor = Integer.parseInt(mysql.group(2));
            this.patch = Integer.parseInt(mysql.group(3));
            this.isMariaDB = false;
            return;
        }
        throw new IllegalArgumentException("Unrecognized MySQL / MariaDB version string.");
    }

    public boolean isAtLeast(MySQLVersion version) {
        if (this.isMariaDB != version.isMariaDB) {
            return false;
        }
        return ComparisonChain.start().compare(this.major, version.major).compare(this.minor, version.minor).compare(this.patch, version.patch).result() >= 0;
    }

    public String toString() {
        return String.format("%s %d.%d.%d", this.isMariaDB ? "MariaDB" : "MySQL", this.major, this.minor, this.patch);
    }
}

