/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Config block which registers CAS-specific field types.
 */
angular.module('guacCAS').config(['formServiceProvider',
        function guacCASConfig(formServiceProvider) {

    // Define field for ticket from CAS service
    formServiceProvider.registerFieldType("GUAC_CAS_TICKET", {
        templateUrl   : 'app/ext/guac-cas/templates/casTicketField.html',
        controller    : 'guacCASController',
        module        : 'guacCAS'
    });

}]);
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Controller for the "GUAC_CAS_TICKET" field which simply redirects the user
 * immediately to the authorization URI.
 */
angular.module('guacCAS').controller('guacCASController', ['$scope', 
    function guacCASController($scope) {

        // Redirect to authorization URI
        window.location = $scope.field.authorizationURI;

}]);
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Module which provides handling for CAS authentication.
 */
angular.module('guacCAS', [
    'form'
]);

// Ensure the CAS module is loaded along with the rest of the app
angular.module('index').requires.push('guacCAS');
angular.module('templates-main', ['app/ext/guac-cas/templates/casTicketField.html']);

angular.module('app/ext/guac-cas/templates/casTicketField.html', []).run(['$templateCache', function($templateCache) {
	$templateCache.put('app/ext/guac-cas/templates/casTicketField.html',
	"<div class=\"cas-ticket-field-container\">\n" +
	"    <div class=\"cas-ticket-field\">\n" +
	"        <p>{{ 'LOGIN.INFO_CAS_REDIRECT_PENDING' | translate }}</p>\n" +
	"    </div>\n" +
	"</div>");
}]);

