/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas.ticket;

import com.google.inject.Inject;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.cas.conf.ConfigurationService;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketValidationService {
    private static final Logger logger = LoggerFactory.getLogger(TicketValidationService.class);
    @Inject
    private ConfigurationService confService;

    public String validateTicket(String ticket, Credentials credentials) throws GuacamoleException {
        String casServerUrl = this.confService.getAuthorizationEndpoint();
        Cas20ProxyTicketValidator validator = new Cas20ProxyTicketValidator(casServerUrl);
        validator.setAcceptAnyProxy(true);
        validator.setEncoding("UTF-8");
        try {
            String clearPass;
            Object credObj;
            String confRedirectURI = this.confService.getRedirectURI();
            Assertion a = validator.validate(ticket, confRedirectURI);
            AttributePrincipal principal = a.getPrincipal();
            String username = principal.getName();
            if (username != null) {
                credentials.setUsername(username);
            }
            if ((credObj = principal.getAttributes().get("credential")) != null && (clearPass = this.decryptPassword(credObj.toString())) != null && !clearPass.isEmpty()) {
                credentials.setPassword(clearPass);
            }
            return username;
        }
        catch (TicketValidationException e) {
            throw new GuacamoleException("Ticket validation failed.", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error("Error validating ticket with CAS server: {}", (Object)t.getMessage());
            throw new GuacamoleInvalidCredentialsException("CAS login failed.", CredentialsInfo.USERNAME_PASSWORD);
        }
    }

    private final String decryptPassword(String encryptedPassword) throws GuacamoleException {
        if (encryptedPassword == null || encryptedPassword.isEmpty()) {
            logger.warn("No or empty encrypted password, no password will be available.");
            return null;
        }
        PrivateKey clearpassKey = this.confService.getClearpassKey();
        if (clearpassKey == null) {
            logger.debug("No private key available to decrypt password.");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(clearpassKey.getAlgorithm());
            if (cipher == null) {
                throw new GuacamoleServerException("Failed to initialize cipher object with private key.");
            }
            cipher.init(2, clearpassKey);
            byte[] pass64 = DatatypeConverter.parseBase64Binary((String)encryptedPassword);
            byte[] cipherData = cipher.doFinal(pass64);
            return new String(cipherData, Charset.forName("UTF-8"));
        }
        catch (BadPaddingException e) {
            throw new GuacamoleServerException("Bad padding when decrypting cipher data.", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new GuacamoleServerException("Illegal block size while opening private key.", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new GuacamoleServerException("Specified private key for ClearPass decryption is invalid.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuacamoleServerException("Unexpected algorithm for the private key.", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new GuacamoleServerException("No such padding trying to initialize cipher with private key.", (Throwable)e);
        }
    }
}

