/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas.form;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.guacamole.form.Field;

public class CASTicketField
extends Field {
    public static final String PARAMETER_NAME = "ticket";
    private static final String CAS_LOGIN_URI = "login";
    private final String authorizationURI;

    public CASTicketField(String authorizationEndpoint, String redirectURI) {
        super(PARAMETER_NAME, "GUAC_CAS_TICKET");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(authorizationEndpoint);
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(CAS_LOGIN_URI);
            sb.append("?service=");
            sb.append(URLEncoder.encode(redirectURI, "UTF-8"));
            this.authorizationURI = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }

    public String getAuthorizationURI() {
        return this.authorizationURI;
    }
}

