/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.groovy.contracts.ViolationTracker;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.generation.ContractExecutionTracker;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.contracts.util.ExpressionUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;

public abstract class BaseGenerator {
    public static final String INVARIANT_CLOSURE_PREFIX = "invariant";
    public static final String META_DATA_USE_INLINE_MODE = "org.apache.groovy.contracts.USE_INLINE_MODE";
    protected final ReaderSource source;

    protected BaseGenerator(ReaderSource source) {
        this.source = source;
    }

    public static String getInvariantMethodName(ClassNode classNode) {
        return "invariant_" + classNode.getName().replaceAll("\\.", "_");
    }

    public static MethodNode getInvariantMethodNode(ClassNode classNode) {
        return classNode.getDeclaredMethod(BaseGenerator.getInvariantMethodName(classNode), Parameter.EMPTY_ARRAY);
    }

    protected BlockStatement getInlineModeBlockStatement(BlockStatement blockStatement) {
        BooleanExpression combinedBooleanExpression = ExpressionUtils.getBooleanExpression(ExpressionUtils.getBooleanExpressionsFromAssertionStatements(blockStatement));
        return GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.varX((String)"$GCONTRACTS_ENABLED", (ClassNode)ClassHelper.boolean_TYPE)), (Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.notX((Expression)combinedBooleanExpression), (Statement)blockStatement)}))});
    }

    protected BlockStatement wrapAssertionBooleanExpression(ClassNode type, MethodNode methodNode, BooleanExpression classInvariantExpression, String assertionType) {
        ClassNode violationTrackerClassNode = ClassHelper.makeWithoutCaching(ViolationTracker.class);
        VariableExpression $_gc_result = GeneralUtils.varX((String)"$_gc_result", (ClassNode)ClassHelper.boolean_TYPE);
        $_gc_result.setAccessedVariable((Variable)$_gc_result);
        BlockStatement ifBlockStatement = GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.declS((Expression)$_gc_result, (Expression)ConstantExpression.FALSE), GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"init")), GeneralUtils.assignS((Expression)$_gc_result, (Expression)classInvariantExpression), GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.notX((Expression)GeneralUtils.callX((Expression)$_gc_result, (String)"booleanValue"))), (Statement)GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"violationsOccurred")), (Statement)GeneralUtils.tryCatchS((Statement)GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"rethrowFirst")), (Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"deinit"))}))))});
        TryCatchStatement lockTryCatchStatement = GeneralUtils.tryCatchS((Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)ClassHelper.make(ContractExecutionTracker.class)), (String)"track", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)type.getName()), GeneralUtils.constX((Object)methodNode.getTypeDescriptor()), GeneralUtils.constX((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE}))), (Statement)ifBlockStatement)}), (Statement)GeneralUtils.block((VariableScope)new VariableScope(), (Statement[])new Statement[]{GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)ClassHelper.make(ContractExecutionTracker.class)), (String)"clear", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)type.getName()), GeneralUtils.constX((Object)methodNode.getTypeDescriptor()), GeneralUtils.constX((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE})))}));
        return GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.varX((String)"$GCONTRACTS_ENABLED", (ClassNode)ClassHelper.boolean_TYPE)), (Statement)lockTryCatchStatement)});
    }

    protected BooleanExpression addCallsToSuperMethodNodeAnnotationClosure(ClassNode type, MethodNode methodNode, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression, boolean isPostcondition) {
        List<AnnotationNode> contractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(annotationType));
        if (contractElementAnnotations.isEmpty()) {
            methodNode.putNodeMetaData((Object)META_DATA_USE_INLINE_MODE, (Object)Boolean.TRUE);
        } else {
            for (AnnotationNode contractElementAnnotation : contractElementAnnotations) {
                ArgumentListExpression argumentList = new ArgumentListExpression();
                for (Parameter parameter : methodNode.getParameters()) {
                    argumentList.addExpression((Expression)GeneralUtils.varX((Variable)parameter));
                }
                if (isPostcondition && !methodNode.isVoidMethod()) {
                    argumentList.addExpression((Expression)GeneralUtils.localVarX((String)"result", (ClassNode)methodNode.getReturnType()));
                }
                if (isPostcondition && !methodNode.isConstructor()) {
                    argumentList.addExpression((Expression)GeneralUtils.localVarX((String)"old", (ClassNode)ClassHelper.MAP_TYPE.getPlainNodeReference()));
                }
                BooleanExpression predicate = BaseVisitor.asConditionExecution(contractElementAnnotation);
                ((MethodCallExpression)predicate.getExpression()).setArguments((Expression)argumentList);
                if (isPostcondition) {
                    booleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.andX((Expression)booleanExpression, (Expression)predicate));
                    continue;
                }
                booleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.orX((Expression)booleanExpression, (Expression)predicate));
            }
        }
        return booleanExpression;
    }
}

