/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.util.Strings;
import org.testng.xml.TestNGURLs;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlRun;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestNGContentHandler
extends DefaultHandler {
    private XmlSuite m_currentSuite = null;
    private XmlTest m_currentTest = null;
    private XmlDefine m_currentDefine = null;
    private XmlRun m_currentRun = null;
    private List<XmlClass> m_currentClasses = null;
    private int m_currentTestIndex = 0;
    private int m_currentClassIndex = 0;
    private int m_currentIncludeIndex = 0;
    private List<XmlPackage> m_currentPackages = null;
    private XmlPackage m_currentPackage = null;
    private final List<XmlSuite> m_suites = Lists.newArrayList();
    private XmlGroups m_currentGroups = null;
    private Map<String, String> m_currentTestParameters = null;
    private Map<String, String> m_currentSuiteParameters = null;
    private Map<String, String> m_currentClassParameters = null;
    private Include m_currentInclude;
    private final EntityResolver m_redirectionAwareResolver = (publicId, systemId) -> {
        URL url = new URL(systemId);
        InputStream stream = this.getClass().getResourceAsStream(url.getPath());
        if (stream == null) {
            String msg = String.format("Failed to read [%s] from CLASSPATH. Attempting to read from [%s].", url.getPath(), systemId);
            Logger.getLogger(this.getClass()).warn(msg);
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection conn = (HttpURLConnection)urlConnection;
                int status = conn.getResponseCode();
                if (status == 302 || status == 301 || status == 303) {
                    String newUrl = conn.getHeaderField("Location");
                    conn = (HttpURLConnection)new URL(newUrl).openConnection();
                }
                stream = conn.getInputStream();
            } else {
                stream = urlConnection.getInputStream();
            }
        }
        return new InputSource(Objects.requireNonNull(stream, "Failed to load DTD from " + systemId));
    };
    private final Stack<Location> m_locations = new Stack();
    private boolean isSuiteFileTag = false;
    private XmlClass m_currentClass = null;
    private ArrayList<XmlInclude> m_currentIncludedMethods = null;
    private List<String> m_currentExcludedMethods = null;
    private ArrayList<XmlMethodSelector> m_currentSelectors = null;
    private XmlMethodSelector m_currentSelector = null;
    private String m_currentLanguage = null;
    private String m_currentExpression = null;
    private final List<String> m_suiteFiles = Lists.newArrayList();
    private boolean m_enabledTest;
    private List<String> m_listeners;
    private final String m_fileName;
    private final boolean m_loadClasses;
    private boolean m_validate = false;
    private boolean m_hasWarn = false;

    public TestNGContentHandler(String fileName, boolean loadClasses) {
        this.m_fileName = fileName;
        this.m_loadClasses = loadClasses;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (TestNGContentHandler.skipConsideringSystemId(systemId)) {
            this.m_validate = true;
            InputStream is = this.loadDtdUsingClassLoader();
            if (is != null) {
                return new InputSource(is);
            }
            System.out.println("WARNING: couldn't find in classpath " + systemId + "\nFetching it from https://testng.org/testng-1.1.dtd");
            return this.m_redirectionAwareResolver.resolveEntity(publicId, "https://testng.org/testng-1.1.dtd");
        }
        if (RuntimeBehavior.useSecuredUrlForDtd() && TestNGContentHandler.isUnsecuredUrl(systemId)) {
            throw new TestNGException(RuntimeBehavior.unsecuredUrlDocumentation());
        }
        return this.m_redirectionAwareResolver.resolveEntity(publicId, systemId);
    }

    private static boolean skipConsideringSystemId(String systemId) {
        return Strings.isNullOrEmpty(systemId) || TestNGURLs.isDTDDomainInternallyKnownToTestNG(systemId) || TestNGContentHandler.isMalformedFileSystemBasedSystemId(systemId);
    }

    private static boolean isMalformedFileSystemBasedSystemId(String systemId) {
        try {
            URL url = new URL(URLDecoder.decode(systemId, StandardCharsets.UTF_8).trim());
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile());
                boolean isDirectory = file.isDirectory();
                boolean fileExists = file.exists();
                return isDirectory || !fileExists;
            }
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    private static boolean isUnsecuredUrl(String str) {
        URI uri;
        try {
            uri = new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri.getScheme() != null && uri.getScheme().equals("http");
    }

    private InputStream loadDtdUsingClassLoader() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("testng-1.1.dtd");
        if (is != null) {
            return is;
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.1.dtd");
    }

    private void xmlSuiteFile(boolean start, Attributes attributes) {
        if (start) {
            String path = attributes.getValue("path");
            this.pushLocation(Location.SUITE);
            this.m_suiteFiles.add(path);
            this.isSuiteFileTag = true;
        } else {
            this.m_currentSuite.setSuiteFiles(this.m_suiteFiles);
            this.popLocation();
            this.isSuiteFileTag = false;
        }
    }

    private void xmlSuite(boolean start, Attributes attributes) {
        if (start) {
            String allowReturnValues;
            String preserveOrder;
            String objectFactory;
            String dataProviderThreadCount;
            String threadCount;
            String skip;
            String groupByInstances;
            XmlSuite.FailurePolicy configFailurePolicy;
            String guiceStage;
            String parentModule;
            String parallel;
            String jUnit;
            this.pushLocation(Location.SUITE);
            String name = attributes.getValue("name");
            if (Utils.isStringBlank(name)) {
                throw new TestNGException("The <suite> tag must define the name attribute");
            }
            this.m_currentSuite = new XmlSuite();
            this.m_currentSuite.setFileName(this.m_fileName);
            this.m_currentSuite.setName(name);
            this.m_currentSuiteParameters = Maps.newHashMap();
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentSuite.setVerbose(Integer.parseInt(verbose));
            }
            if (null != (jUnit = attributes.getValue("junit"))) {
                TestNGContentHandler.warnSinceJUnitDetected();
            }
            if ((parallel = attributes.getValue("parallel")) != null) {
                XmlSuite.ParallelMode mode = XmlSuite.ParallelMode.getValidParallel(parallel);
                if (mode != null) {
                    this.m_currentSuite.setParallel(mode);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' at suite level: '" + parallel + "'.");
                }
            }
            if ((parentModule = attributes.getValue("parent-module")) != null) {
                this.m_currentSuite.setParentModule(parentModule);
            }
            if ((guiceStage = attributes.getValue("guice-stage")) != null) {
                this.m_currentSuite.setGuiceStage(guiceStage);
            }
            if (null != (configFailurePolicy = XmlSuite.FailurePolicy.getValidPolicy(attributes.getValue("configfailurepolicy")))) {
                this.m_currentSuite.setConfigFailurePolicy(configFailurePolicy);
            }
            if ((groupByInstances = attributes.getValue("group-by-instances")) != null) {
                this.m_currentSuite.setGroupByInstances(Boolean.parseBoolean(groupByInstances));
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentSuite.setSkipFailedInvocationCounts(Boolean.parseBoolean(skip));
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentSuite.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (dataProviderThreadCount = attributes.getValue("data-provider-thread-count"))) {
                this.m_currentSuite.setDataProviderThreadCount(Integer.parseInt(dataProviderThreadCount));
            }
            String shareThreadPoolForDataProviders = attributes.getValue("share-thread-pool-for-data-providers");
            Optional.ofNullable(shareThreadPoolForDataProviders).ifPresent(it -> this.m_currentSuite.setShareThreadPoolForDataProviders(Boolean.parseBoolean(shareThreadPoolForDataProviders)));
            String useGlobalThreadPool = attributes.getValue("use-global-thread-pool");
            Optional.ofNullable(useGlobalThreadPool).ifPresent(it -> this.m_currentSuite.shouldUseGlobalThreadPool(Boolean.parseBoolean(useGlobalThreadPool)));
            String timeOut = attributes.getValue("time-out");
            if (null != timeOut) {
                this.m_currentSuite.setTimeOut(timeOut);
            }
            if (null != (objectFactory = attributes.getValue("object-factory")) && this.m_loadClasses) {
                try {
                    this.m_currentSuite.setObjectFactoryClass(Class.forName(objectFactory));
                }
                catch (Exception e) {
                    Utils.log("Parser", 1, "[ERROR] Unable to create custom object factory '" + objectFactory + "' :" + e);
                }
            }
            if ((preserveOrder = attributes.getValue("preserve-order")) != null) {
                this.m_currentSuite.setPreserveOrder(Boolean.valueOf(preserveOrder));
            }
            if ((allowReturnValues = attributes.getValue("allow-return-values")) != null) {
                this.m_currentSuite.setAllowReturnValues(Boolean.valueOf(allowReturnValues));
            }
        } else {
            this.m_currentSuite.setParameters(this.m_currentSuiteParameters);
            this.m_suites.add(this.m_currentSuite);
            this.m_currentSuiteParameters = null;
            this.popLocation();
        }
    }

    private void xmlDefine(boolean start, Attributes attributes) {
        if (start) {
            String name = attributes.getValue("name");
            this.m_currentDefine = new XmlDefine();
            this.m_currentDefine.setName(name);
        } else {
            this.m_currentGroups.addDefine(this.m_currentDefine);
            this.m_currentDefine = null;
        }
    }

    private void xmlScript(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentLanguage = attributes.getValue("language");
            this.m_currentExpression = "";
        } else {
            XmlScript script = new XmlScript();
            script.setExpression(this.m_currentExpression);
            script.setLanguage(this.m_currentLanguage);
            this.m_currentSelector.setScript(script);
            if (this.m_locations.peek() == Location.TEST) {
                this.m_currentTest.setScript(script);
            }
            this.m_currentLanguage = null;
            this.m_currentExpression = null;
        }
    }

    private void xmlTest(boolean start, Attributes attributes) {
        if (start) {
            String timeOut;
            String threadCount;
            String parallel;
            String preserveOrder;
            String groupByInstances;
            String skip;
            String jUnit;
            this.m_currentTest = new XmlTest(this.m_currentSuite, this.m_currentTestIndex++);
            this.pushLocation(Location.TEST);
            this.m_currentTestParameters = Maps.newHashMap();
            String testName = attributes.getValue("name");
            if (Utils.isStringBlank(testName)) {
                throw new TestNGException("The <test> tag must define the name attribute");
            }
            this.m_currentTest.setName(attributes.getValue("name"));
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentTest.setVerbose(Integer.parseInt(verbose));
            }
            if (null != (jUnit = attributes.getValue("junit"))) {
                TestNGContentHandler.warnSinceJUnitDetected();
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentTest.setSkipFailedInvocationCounts(Boolean.parseBoolean(skip));
            }
            if ((groupByInstances = attributes.getValue("group-by-instances")) != null) {
                this.m_currentTest.setGroupByInstances(Boolean.parseBoolean(groupByInstances));
            }
            if ((preserveOrder = attributes.getValue("preserve-order")) != null) {
                this.m_currentTest.setPreserveOrder(Boolean.valueOf(preserveOrder));
            }
            if ((parallel = attributes.getValue("parallel")) != null) {
                XmlSuite.ParallelMode mode = XmlSuite.ParallelMode.getValidParallel(parallel);
                if (mode != null) {
                    this.m_currentTest.setParallel(mode);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' for test '" + this.m_currentTest.getName() + "': '" + parallel + "'");
                }
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentTest.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (timeOut = attributes.getValue("time-out"))) {
                this.m_currentTest.setTimeOut(Long.parseLong(timeOut));
            }
            this.m_enabledTest = true;
            String enabledTestString = attributes.getValue("enabled");
            if (null != enabledTestString) {
                this.m_enabledTest = Boolean.parseBoolean(enabledTestString);
            }
        } else {
            if (null != this.m_currentTestParameters && !this.m_currentTestParameters.isEmpty()) {
                this.m_currentTest.setParameters(this.m_currentTestParameters);
            }
            if (null != this.m_currentClasses) {
                this.m_currentTest.setXmlClasses(this.m_currentClasses);
            }
            this.m_currentClasses = null;
            this.m_currentTest = null;
            this.m_currentTestParameters = null;
            this.popLocation();
            if (!this.m_enabledTest) {
                List<XmlTest> tests = this.m_currentSuite.getTests();
                tests.remove(tests.size() - 1);
            }
        }
    }

    public void xmlClasses(boolean start) {
        if (start) {
            this.m_currentClasses = Lists.newArrayList();
            this.m_currentClassIndex = 0;
        } else {
            this.m_currentTest.setXmlClasses(this.m_currentClasses);
            this.m_currentClasses = null;
        }
    }

    public void xmlListeners(boolean start) {
        if (start) {
            this.m_listeners = Lists.newArrayList();
        } else if (null != this.m_listeners) {
            this.m_currentSuite.setListeners(this.m_listeners);
            this.m_listeners = null;
        }
    }

    public void xmlListener(boolean start, Attributes attributes) {
        if (start) {
            String listener = attributes.getValue("class-name");
            this.m_listeners.add(listener);
        }
    }

    public void xmlPackages(boolean start) {
        if (start) {
            this.m_currentPackages = Lists.newArrayList();
        } else {
            if (null != this.m_currentPackages) {
                Location location = this.m_locations.peek();
                switch (location) {
                    case TEST: {
                        this.m_currentTest.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case SUITE: {
                        this.m_currentSuite.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case CLASS: {
                        throw new UnsupportedOperationException("CLASS");
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected value: " + location));
                    }
                }
            }
            this.m_currentPackages = null;
            this.m_currentPackage = null;
        }
    }

    public void xmlMethodSelectors(boolean start) {
        if (start) {
            this.m_currentSelectors = new ArrayList();
            return;
        }
        if (this.m_locations.peek() == Location.TEST) {
            this.m_currentTest.setMethodSelectors(this.m_currentSelectors);
        } else {
            this.m_currentSuite.setMethodSelectors(this.m_currentSelectors);
        }
        this.m_currentSelectors = null;
    }

    public void xmlSelectorClass(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelector.setName(attributes.getValue("name"));
            String priority = attributes.getValue("priority");
            if (priority == null) {
                priority = "0";
            }
            this.m_currentSelector.setPriority(Integer.parseInt(priority));
        }
    }

    public void xmlMethodSelector(boolean start) {
        if (start) {
            this.m_currentSelector = new XmlMethodSelector();
        } else {
            this.m_currentSelectors.add(this.m_currentSelector);
            this.m_currentSelector = null;
        }
    }

    private void xmlMethod(boolean start) {
        if (start) {
            this.m_currentIncludedMethods = new ArrayList();
            this.m_currentExcludedMethods = Lists.newArrayList();
            this.m_currentIncludeIndex = 0;
        } else {
            this.m_currentClass.setIncludedMethods(this.m_currentIncludedMethods);
            this.m_currentClass.setExcludedMethods(this.m_currentExcludedMethods);
            this.m_currentIncludedMethods = null;
            this.m_currentExcludedMethods = null;
        }
    }

    public void xmlRun(boolean start) {
        if (start) {
            this.m_currentRun = new XmlRun();
        } else {
            this.m_currentGroups.setRun(this.m_currentRun);
            this.m_currentRun = null;
        }
    }

    public void xmlGroup(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentTest.addXmlDependencyGroup(attributes.getValue("name"), attributes.getValue("depends-on"));
        }
    }

    public void xmlGroups(boolean start) {
        if (start) {
            this.m_currentGroups = new XmlGroups();
        } else {
            if (this.m_currentTest == null) {
                this.m_currentSuite.setGroups(this.m_currentGroups);
            } else {
                this.m_currentTest.setGroups(this.m_currentGroups);
            }
            this.m_currentGroups = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!this.m_validate && !this.m_hasWarn) {
            String msg = String.format("It is strongly recommended to add \"<!DOCTYPE suite SYSTEM \"%s\" >\" at the top of the suite file [%s] otherwise TestNG may fail or not work as expected.", "https://testng.org/testng-1.1.dtd", this.m_fileName);
            Logger.getLogger(TestNGContentHandler.class).warn(msg);
            this.m_hasWarn = true;
        }
        String name = attributes.getValue("name");
        if ("suite".equals(qName)) {
            this.xmlSuite(true, attributes);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(true, attributes);
        } else if ("test".equals(qName)) {
            this.xmlTest(true, attributes);
        } else if ("script".equals(qName)) {
            this.xmlScript(true, attributes);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(true);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(true);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(true, attributes);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(true);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(true);
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(true);
        } else if ("listener".equals(qName)) {
            this.xmlListener(true, attributes);
        } else if ("class".equals(qName)) {
            if (null != this.m_currentClasses) {
                this.m_currentClass = new XmlClass(name, this.m_currentClassIndex++, this.m_loadClasses);
                this.m_currentClass.setXmlTest(this.m_currentTest);
                this.m_currentClassParameters = Maps.newHashMap();
                this.m_currentClasses.add(this.m_currentClass);
                this.pushLocation(Location.CLASS);
            }
        } else if ("package".equals(qName)) {
            if (null != this.m_currentPackages) {
                this.m_currentPackage = new XmlPackage();
                this.m_currentPackage.setName(name);
                this.m_currentPackages.add(this.m_currentPackage);
            }
        } else if ("define".equals(qName)) {
            this.xmlDefine(true, attributes);
        } else if ("run".equals(qName)) {
            this.xmlRun(true);
        } else if ("group".equals(qName)) {
            this.xmlGroup(true, attributes);
        } else if ("groups".equals(qName)) {
            this.xmlGroups(true);
        } else if ("methods".equals(qName)) {
            this.xmlMethod(true);
        } else if ("include".equals(qName)) {
            this.xmlInclude(true, attributes);
        } else if ("exclude".equals(qName)) {
            this.xmlExclude(true, attributes);
        } else if ("parameter".equals(qName)) {
            if (this.isSuiteFileTag) {
                Logger.getLogger(this.getClass()).warn("Ignoring the <parameter> tag because it is specified inside a <suite-file> tag.");
                return;
            }
            String value = TestNGContentHandler.expandValue(attributes.getValue("value"));
            Location location = this.m_locations.peek();
            switch (location) {
                case TEST: {
                    this.m_currentTestParameters.put(name, value);
                    break;
                }
                case SUITE: {
                    this.m_currentSuiteParameters.put(name, value);
                    break;
                }
                case CLASS: {
                    this.m_currentClassParameters.put(name, value);
                    break;
                }
                case INCLUDE: {
                    this.m_currentInclude.parameters.put(name, value);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + location));
                }
            }
        }
    }

    private void xmlInclude(boolean start, Attributes attributes) {
        if (start) {
            this.m_locations.push(Location.INCLUDE);
            this.m_currentInclude = new Include(attributes.getValue("name"), attributes.getValue("invocation-numbers"));
            this.m_currentInclude.description = attributes.getValue("description");
        } else {
            String name = this.m_currentInclude.name;
            if (null != this.m_currentIncludedMethods) {
                String in = this.m_currentInclude.invocationNumbers;
                XmlInclude include = !Utils.isStringEmpty(in) ? new XmlInclude(name, this.stringToList(in), this.m_currentIncludeIndex++) : new XmlInclude(name, this.m_currentIncludeIndex++);
                for (Map.Entry<String, String> entry : this.m_currentInclude.parameters.entrySet()) {
                    include.addParameter(entry.getKey(), entry.getValue());
                }
                include.setDescription(this.m_currentInclude.description);
                this.m_currentIncludedMethods.add(include);
            } else if (null != this.m_currentDefine) {
                this.m_currentDefine.onElement(name);
            } else if (null != this.m_currentRun) {
                this.m_currentRun.onInclude(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getInclude().add(name);
            }
            this.popLocation();
            this.m_currentInclude = null;
        }
    }

    private void xmlExclude(boolean start, Attributes attributes) {
        if (start) {
            this.m_locations.push(Location.EXCLUDE);
            String name = attributes.getValue("name");
            if (null != this.m_currentExcludedMethods) {
                this.m_currentExcludedMethods.add(name);
            } else if (null != this.m_currentRun) {
                this.m_currentRun.onExclude(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getExclude().add(name);
            }
        } else {
            this.popLocation();
        }
    }

    private void pushLocation(Location l) {
        this.m_locations.push(l);
    }

    private void popLocation() {
        this.m_locations.pop();
    }

    private List<Integer> stringToList(String in) {
        String[] numbers = in.split(" ");
        List<Integer> result = Lists.newArrayList();
        for (String n : numbers) {
            result.add(Integer.parseInt(n));
        }
        return result;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("suite".equals(qName)) {
            this.xmlSuite(false, null);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(false, null);
        } else if ("test".equals(qName)) {
            this.xmlTest(false, null);
        } else if ("define".equals(qName)) {
            this.xmlDefine(false, null);
        } else if ("run".equals(qName)) {
            this.xmlRun(false);
        } else if ("groups".equals(qName)) {
            this.xmlGroups(false);
        } else if ("methods".equals(qName)) {
            this.xmlMethod(false);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(false);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(false);
        } else if ("class".equals(qName)) {
            this.m_currentClass.setParameters(this.m_currentClassParameters);
            this.m_currentClassParameters = null;
            this.popLocation();
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(false);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(false);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(false);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(false, null);
        } else if ("script".equals(qName)) {
            this.xmlScript(false, null);
        } else if ("include".equals(qName)) {
            this.xmlInclude(false, null);
        } else if ("exclude".equals(qName)) {
            this.xmlExclude(false, null);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.m_validate) {
            throw e;
        }
    }

    private boolean areWhiteSpaces(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            if (c == '\n' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (null != this.m_currentLanguage && !this.areWhiteSpaces(ch, start, length)) {
            this.m_currentExpression = this.m_currentExpression + new String(ch, start, length);
        }
    }

    public XmlSuite getSuite() {
        return this.m_currentSuite;
    }

    private static String expandValue(String value) {
        int endIndex;
        int startIndex;
        StringBuilder result = null;
        int startPosition = 0;
        while ((startIndex = value.indexOf("${", startPosition)) > -1 && (endIndex = value.indexOf("}", startIndex + 3)) > -1) {
            String property = value.substring(startIndex + 2, endIndex);
            if (result == null) {
                result = new StringBuilder(value.substring(startPosition, startIndex));
            } else {
                result.append(value, startPosition, startIndex);
            }
            String propertyValue = System.getProperty(property);
            if (propertyValue == null) {
                propertyValue = System.getenv(property);
            }
            if (propertyValue != null) {
                result.append(propertyValue);
            } else {
                result.append("${");
                result.append(property);
                result.append("}");
            }
            startPosition = startIndex + 3 + property.length();
        }
        if (result != null) {
            result.append(value.substring(startPosition));
            return result.toString();
        }
        return value;
    }

    private static void warnSinceJUnitDetected() {
        String msg = "Ability to run JUnit tests via TestNG was deprecated in v7.7.0 and is NOW being removed permanently. If you would like to run a mixture of TestNG and JUnit tests then please take a look at  https://github.com/junit-team/testng-engine which is now maintained by the JUnit team";
        System.err.println(msg);
    }

    static enum Location {
        SUITE,
        TEST,
        CLASS,
        INCLUDE,
        EXCLUDE;

    }

    private static class Include {
        String name;
        String invocationNumbers;
        String description;
        Map<String, String> parameters = Maps.newHashMap();

        Include(String name, String numbers) {
            this.name = name;
            this.invocationNumbers = numbers;
        }
    }
}

