/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.reflect.Array;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.classgen.asm.util.TypeUtil;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class ParameterTypes {
    protected volatile Class[] nativeParamTypes;
    protected volatile CachedClass[] parameterTypes;
    protected boolean isVargsMethod;

    public ParameterTypes() {
    }

    public ParameterTypes(Class[] pt) {
        this.nativeParamTypes = pt;
    }

    public ParameterTypes(String[] pt) {
        this.nativeParamTypes = new Class[pt.length];
        for (int i = 0; i != pt.length; ++i) {
            try {
                this.nativeParamTypes[i] = Class.forName(pt[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                NoClassDefFoundError err = new NoClassDefFoundError();
                err.initCause(e);
                throw err;
            }
        }
    }

    public ParameterTypes(CachedClass[] parameterTypes) {
        this.setParametersTypes(parameterTypes);
    }

    protected final void setParametersTypes(CachedClass[] pt) {
        this.parameterTypes = pt;
        this.isVargsMethod = pt.length > 0 && pt[pt.length - 1].isArray;
    }

    public CachedClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.getParametersTypes0();
        }
        return this.parameterTypes;
    }

    private synchronized void getParametersTypes0() {
        Class[] npt;
        if (this.parameterTypes != null) {
            return;
        }
        Class[] classArray = npt = this.nativeParamTypes == null ? this.getPT() : this.nativeParamTypes;
        if (npt.length == 0) {
            this.nativeParamTypes = MetaClassHelper.EMPTY_TYPE_ARRAY;
            this.setParametersTypes(CachedClass.EMPTY_ARRAY);
        } else {
            CachedClass[] pt = new CachedClass[npt.length];
            for (int i = 0; i != npt.length; ++i) {
                pt[i] = ReflectionCache.getCachedClass(npt[i]);
            }
            this.nativeParamTypes = npt;
            this.setParametersTypes(pt);
        }
    }

    public Class[] getNativeParameterTypes() {
        if (this.nativeParamTypes == null) {
            this.getNativeParameterTypes0();
        }
        return this.nativeParamTypes;
    }

    private synchronized void getNativeParameterTypes0() {
        if (this.nativeParamTypes == null) {
            Class[] npt;
            if (this.parameterTypes == null) {
                npt = this.getPT();
            } else {
                npt = new Class[this.parameterTypes.length];
                for (int i = 0; i != this.parameterTypes.length; ++i) {
                    npt[i] = this.parameterTypes[i].getTheClass();
                }
            }
            this.nativeParamTypes = npt;
        }
    }

    protected Class[] getPT() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isVargsMethod() {
        return this.isVargsMethod;
    }

    public boolean isVargsMethod(Object[] arguments) {
        if (this.isVargsMethod) {
            int aCount = arguments.length;
            int pCount = this.parameterTypes.length;
            if (aCount > pCount || aCount == pCount - 1) {
                return true;
            }
            if (aCount == pCount) {
                Object last = arguments[aCount - 1];
                return last == null || !ParameterTypes.getArgClass(last).equals(this.parameterTypes[pCount - 1].getTheClass());
            }
        }
        return false;
    }

    public final Object[] coerceArgumentsToClasses(Object[] arguments) {
        arguments = this.correctArguments(arguments);
        for (int i = 0; i != arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument instanceof Wrapper) {
                argument = ((Wrapper)argument).unwrap();
            }
            if (argument != null) {
                arguments[i] = this.parameterTypes[i].coerceArgument(argument);
                continue;
            }
            if (!this.parameterTypes[i].isPrimitive()) continue;
            throw new IllegalArgumentException("Cannot call method with null for parameter " + i + ", which expects " + this.parameterTypes[i]);
        }
        return arguments;
    }

    public Object[] correctArguments(Object[] arguments) {
        CachedClass[] pt;
        if (arguments == null) {
            arguments = MetaClassHelper.EMPTY_ARRAY;
        }
        if ((pt = this.getParameterTypes()).length == 1 && arguments.length == 0) {
            if (!this.isVargsMethod) {
                return MetaClassHelper.ARRAY_WITH_NULL;
            }
            return new Object[]{Array.newInstance(pt[0].getTheClass().getComponentType(), 0)};
        }
        if (this.isVargsMethod(arguments)) {
            return ParameterTypes.fitToVargs(arguments, pt);
        }
        return arguments;
    }

    private static Object[] fitToVargs(Object[] arguments, CachedClass[] paramTypes) {
        int aCount = arguments.length;
        int pCount = paramTypes.length;
        Class vaType = paramTypes[pCount - 1].getTheClass();
        Object[] unwrappedArguments = (Object[])arguments.clone();
        MetaClassHelper.unwrap(unwrappedArguments);
        vaType = TypeUtil.autoboxType(vaType.getComponentType());
        if (aCount == pCount - 1) {
            Object[] args = new Object[pCount];
            System.arraycopy(unwrappedArguments, 0, args, 0, aCount);
            args[aCount] = Array.newInstance(vaType, 0);
            return args;
        }
        if (aCount == pCount) {
            Class<?> lastArgument = ParameterTypes.getArgClass(arguments[aCount - 1]);
            if (lastArgument != null && !lastArgument.isArray()) {
                Object[] args = new Object[pCount];
                System.arraycopy(unwrappedArguments, 0, args, 0, pCount - 1);
                args[pCount - 1] = ParameterTypes.makeCommonArray(unwrappedArguments, pCount - 1, vaType);
                return args;
            }
            return unwrappedArguments;
        }
        if (aCount > pCount) {
            Object[] args = new Object[pCount];
            System.arraycopy(unwrappedArguments, 0, args, 0, pCount - 1);
            args[pCount - 1] = ParameterTypes.makeCommonArray(unwrappedArguments, pCount - 1, vaType);
            return args;
        }
        throw new GroovyBugError("trying to call a vargs method without enough arguments");
    }

    private static Object makeCommonArray(Object[] arguments, int offset, Class<?> baseType) {
        Object[] result = (Object[])Array.newInstance(baseType, arguments.length - offset);
        for (int i = offset; i != arguments.length; ++i) {
            Object v = arguments[i];
            result[i - offset] = v = DefaultTypeTransformation.castToType(v, baseType);
        }
        return result;
    }

    public boolean isValidMethod(Class[] argumentTypes) {
        if (argumentTypes == null) {
            return true;
        }
        CachedClass[] pt = this.getParameterTypes();
        int nArguments = argumentTypes.length;
        int nParameters = pt.length;
        int nthParameter = nParameters - 1;
        if (this.isVargsMethod && nArguments >= nthParameter) {
            return ParameterTypes.isValidVargsMethod(argumentTypes, pt, nthParameter);
        }
        if (nArguments == nParameters) {
            return ParameterTypes.isValidExactMethod(argumentTypes, pt);
        }
        return nArguments == 0 && nParameters == 1 && !pt[0].isPrimitive;
    }

    private static boolean isValidExactMethod(Class[] arguments, CachedClass[] pt) {
        for (int i = 0; i != pt.length; ++i) {
            if (pt[i].isAssignableFrom(arguments[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isValidExactMethod(Object[] args) {
        this.getParametersTypes0();
        int size = args.length;
        if (size != this.parameterTypes.length) {
            return false;
        }
        for (int i = 0; i != size; ++i) {
            Object arg = args[i];
            if (arg == null || this.parameterTypes[i].isAssignableFrom(arg.getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean isValidExactMethod(Class[] args) {
        this.getParametersTypes0();
        int size = args.length;
        if (size != this.parameterTypes.length) {
            return false;
        }
        for (int i = 0; i != size; ++i) {
            Class arg = args[i];
            if (arg == null || this.parameterTypes[i].isAssignableFrom(arg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidVargsMethod(Class[] argumentTypes, CachedClass[] parameterTypes, int nthParameter) {
        Class argumentType;
        for (int i = 0; i < nthParameter; ++i) {
            if (parameterTypes[i].isAssignableFrom(argumentTypes[i])) continue;
            return false;
        }
        CachedClass arrayType = parameterTypes[nthParameter];
        CachedClass componentType = ReflectionCache.getCachedClass(arrayType.getTheClass().getComponentType());
        if (argumentTypes.length == parameterTypes.length && (arrayType.isAssignableFrom(argumentType = argumentTypes[nthParameter]) || argumentType.isArray() && componentType.isAssignableFrom(argumentType.getComponentType()))) {
            return true;
        }
        for (int i = nthParameter; i < argumentTypes.length; ++i) {
            if (componentType.isAssignableFrom(argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isValidMethod(Object[] arguments) {
        if (arguments == null) {
            return true;
        }
        CachedClass[] parameterTypes = this.getParameterTypes();
        int nArguments = arguments.length;
        int nParameters = parameterTypes.length;
        int nthParameter = nParameters - 1;
        if (nParameters > 0 && parameterTypes[nthParameter].isArray && nArguments >= nthParameter) {
            Class<?> argumentType;
            for (int i = 0; i < nthParameter; ++i) {
                if (parameterTypes[i].isAssignableFrom(ParameterTypes.getArgClass(arguments[i]))) continue;
                return false;
            }
            CachedClass arrayType = parameterTypes[nthParameter];
            CachedClass componentType = ReflectionCache.getCachedClass(arrayType.getTheClass().getComponentType());
            if (nArguments == parameterTypes.length && (arrayType.isAssignableFrom(argumentType = ParameterTypes.getArgClass(arguments[nthParameter])) || argumentType.isArray() && componentType.isAssignableFrom(argumentType.getComponentType()))) {
                return true;
            }
            for (int i = nthParameter; i < nArguments; ++i) {
                if (componentType.isAssignableFrom(ParameterTypes.getArgClass(arguments[i]))) continue;
                return false;
            }
            return true;
        }
        if (nArguments == nParameters) {
            for (int i = 0; i < nArguments; ++i) {
                if (parameterTypes[i].isAssignableFrom(ParameterTypes.getArgClass(arguments[i]))) continue;
                return false;
            }
            return true;
        }
        return nArguments == 0 && nParameters == 1 && !parameterTypes[0].isPrimitive;
    }

    private static Class<?> getArgClass(Object arg) {
        return arg == null ? null : (arg instanceof Wrapper ? ((Wrapper)arg).getType() : arg.getClass());
    }
}

