/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyCallable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MissingFieldException;
import groovy.lang.MissingPropertyException;
import groovy.lang.TrampolineClosure;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.apache.groovy.internal.util.UncheckedThrow;
import org.apache.groovy.io.StringBuilderWriter;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.reflection.stdclasses.CachedClosureClass;
import org.codehaus.groovy.runtime.ComposedClosure;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.callsite.BooleanClosureWrapper;
import org.codehaus.groovy.runtime.memoize.ConcurrentCommonCache;
import org.codehaus.groovy.runtime.memoize.ConcurrentSoftCache;
import org.codehaus.groovy.runtime.memoize.LRUCache;
import org.codehaus.groovy.runtime.memoize.Memoize;

public abstract class Closure<V>
extends GroovyObjectSupport
implements Cloneable,
Runnable,
GroovyCallable<V>,
Serializable {
    public static final int OWNER_FIRST = 0;
    public static final int DELEGATE_FIRST = 1;
    public static final int OWNER_ONLY = 2;
    public static final int DELEGATE_ONLY = 3;
    public static final int TO_SELF = 4;
    public static final int DONE = 1;
    public static final int SKIP = 2;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Closure IDENTITY = new Closure<Object>(null){
        private static final long serialVersionUID = 730973623329943963L;

        public Object doCall(Object args) {
            return args;
        }
    };
    private Object delegate;
    private Object owner;
    private Object thisObject;
    private int resolveStrategy = 0;
    private int directive;
    protected Class<?>[] parameterTypes;
    protected int maximumNumberOfParameters;
    private static final long serialVersionUID = 4368710879820278874L;
    private BooleanClosureWrapper bcw;

    public Closure(Object owner, Object thisObject) {
        this.owner = owner;
        this.delegate = owner;
        this.thisObject = thisObject;
        CachedClosureClass cachedClass = (CachedClosureClass)ReflectionCache.getCachedClass(this.getClass());
        this.parameterTypes = cachedClass.getParameterTypes();
        this.maximumNumberOfParameters = cachedClass.getMaximumNumberOfParameters();
    }

    public Closure(Object owner) {
        this(owner, null);
    }

    public void setResolveStrategy(int resolveStrategy) {
        this.resolveStrategy = resolveStrategy;
    }

    public int getResolveStrategy() {
        return this.resolveStrategy;
    }

    public Object getThisObject() {
        return this.thisObject;
    }

    private Class getThisType() {
        Class<?> thisType = this.getClass();
        while (GeneratedClosure.class.isAssignableFrom(thisType)) {
            thisType = thisType.getEnclosingClass();
        }
        return thisType;
    }

    @Override
    public Object getProperty(String property) {
        switch (property) {
            case "owner": {
                return this.getOwner();
            }
            case "delegate": {
                return this.getDelegate();
            }
            case "thisObject": {
                return this.getThisObject();
            }
            case "class": {
                return this.getClass();
            }
            case "metaClass": {
                return this.getMetaClass();
            }
            case "directive": {
                return this.getDirective();
            }
            case "parameterTypes": {
                return this.getParameterTypes();
            }
            case "resolveStrategy": {
                return this.getResolveStrategy();
            }
            case "maximumNumberOfParameters": {
                return this.getMaximumNumberOfParameters();
            }
        }
        switch (this.resolveStrategy) {
            case 1: {
                if (this.getDelegate() == null) {
                    return this.getProperty(this.getOwner(), property);
                }
                return this.getPropertyTryThese(this.getDelegate(), this.getOwner(), property);
            }
            case 3: {
                return this.getProperty(this.getDelegate(), property);
            }
            case 2: {
                return this.getProperty(this.getOwner(), property);
            }
            case 4: {
                return super.getProperty(property);
            }
        }
        return this.getPropertyTryThese(this.getOwner(), this.getDelegate(), property);
    }

    private Object getProperty(Object receiver, String property) {
        try {
            return InvokerHelper.getProperty(receiver, property);
        }
        catch (GroovyRuntimeException e1) {
            if (null != receiver && this != receiver && this instanceof GeneratedClosure && this.getThisType() != receiver.getClass() && this.getThisType().isInstance(receiver)) {
                try {
                    return ((GroovyObject)receiver).getMetaClass().getProperty(this.getThisType(), receiver, property, false, true);
                }
                catch (GroovyRuntimeException e2) {
                    e1.addSuppressed(e2);
                }
            }
            throw e1;
        }
    }

    private Object getPropertyTryThese(Object o1, Object o2, String property) {
        try {
            return this.getProperty(o1, property);
        }
        catch (MissingFieldException | MissingPropertyException e1) {
            if (o2 != null && o1 != this && o1 != o2) {
                try {
                    return this.getProperty(o2, property);
                }
                catch (GroovyRuntimeException e2) {
                    e1.addSuppressed(e2);
                }
            }
            throw e1;
        }
    }

    @Override
    public void setProperty(String property, Object newValue) {
        block6 : switch (property) {
            case "delegate": {
                this.setDelegate(newValue);
                break;
            }
            case "metaClass": {
                this.setMetaClass((MetaClass)newValue);
                break;
            }
            case "directive": {
                this.setDirective(((Number)newValue).intValue());
                break;
            }
            case "resolveStrategy": {
                this.setResolveStrategy(((Number)newValue).intValue());
                break;
            }
            default: {
                switch (this.resolveStrategy) {
                    case 1: {
                        if (this.getDelegate() == null) {
                            this.setProperty(this.getOwner(), property, newValue);
                            break block6;
                        }
                        this.setPropertyTryThese(this.getDelegate(), this.getOwner(), property, newValue);
                        break block6;
                    }
                    case 3: {
                        this.setProperty(this.getDelegate(), property, newValue);
                        break block6;
                    }
                    case 2: {
                        this.setProperty(this.getOwner(), property, newValue);
                        break block6;
                    }
                    case 4: {
                        super.setProperty(property, newValue);
                        break block6;
                    }
                }
                this.setPropertyTryThese(this.getOwner(), this.getDelegate(), property, newValue);
            }
        }
    }

    private void setProperty(Object receiver, String property, Object newValue) {
        try {
            InvokerHelper.setProperty(receiver, property, newValue);
        }
        catch (GroovyRuntimeException e1) {
            if (null != receiver && this != receiver && this instanceof GeneratedClosure && this.getThisType() != receiver.getClass() && this.getThisType().isInstance(receiver)) {
                try {
                    ((GroovyObject)receiver).getMetaClass().setProperty(this.getThisType(), receiver, property, newValue, false, true);
                    return;
                }
                catch (GroovyRuntimeException e2) {
                    e1.addSuppressed(e2);
                }
            }
            throw e1;
        }
    }

    private void setPropertyTryThese(Object o1, Object o2, String property, Object newValue) {
        try {
            this.setProperty(o1, property, newValue);
        }
        catch (GroovyRuntimeException e1) {
            if (o1 != null && o1 != this && o1 != o2) {
                try {
                    this.setProperty(o2, property, newValue);
                    return;
                }
                catch (GroovyRuntimeException e2) {
                    e1.addSuppressed(e2);
                }
            }
            throw e1;
        }
    }

    public boolean isCase(Object switchValue) {
        if (this.bcw == null) {
            this.bcw = new BooleanClosureWrapper(this);
        }
        return this.bcw.call(switchValue);
    }

    @Override
    public V call() {
        return this.call(EMPTY_OBJECT_ARRAY);
    }

    public V call(Object arguments) {
        return this.call(new Object[]{arguments});
    }

    public V call(Object ... arguments) {
        try {
            return (V)this.getMetaClass().invokeMethod((Object)this, "doCall", arguments);
        }
        catch (InvokerInvocationException e) {
            UncheckedThrow.rethrow(e.getCause());
            return null;
        }
        catch (Exception e) {
            return (V)Closure.throwRuntimeException(e);
        }
    }

    protected static Object throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new GroovyRuntimeException(throwable.getMessage(), throwable);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getMaximumNumberOfParameters() {
        return this.maximumNumberOfParameters;
    }

    public Closure asWritable() {
        return new WritableClosure();
    }

    @Override
    public void run() {
        this.call();
    }

    public Closure<V> curry(Object ... arguments) {
        return new CurriedClosure(this, arguments);
    }

    public Closure<V> curry(Object argument) {
        return this.curry(new Object[]{argument});
    }

    public Closure<V> rcurry(Object ... arguments) {
        return new CurriedClosure(-arguments.length, this, arguments);
    }

    public Closure<V> rcurry(Object argument) {
        return this.rcurry(new Object[]{argument});
    }

    public Closure<V> ncurry(int n, Object ... arguments) {
        return new CurriedClosure(n, this, arguments);
    }

    public Closure<V> ncurry(int n, Object argument) {
        return this.ncurry(n, new Object[]{argument});
    }

    public <W> Closure<W> rightShift(Closure<W> other) {
        return new ComposedClosure<W>(this, other);
    }

    public Closure<V> leftShift(Closure other) {
        return new ComposedClosure(other, this);
    }

    public <W> Closure<W> andThen(Closure<W> other) {
        return this.rightShift(other);
    }

    public Closure<V> andThenSelf() {
        return this.andThen(this);
    }

    public Closure<V> andThenSelf(int times) {
        if (times == 0) {
            return this;
        }
        if (times == 1) {
            return this.andThen(this);
        }
        return this.andThen(this.andThenSelf(times - 1));
    }

    public Closure<V> compose(Closure other) {
        return this.leftShift(other);
    }

    public Closure<V> composeSelf() {
        return this.compose(this);
    }

    public Closure<V> composeSelf(int times) {
        if (times == 0) {
            return this;
        }
        if (times == 1) {
            return this.compose(this);
        }
        return this.compose(this.composeSelf(times - 1));
    }

    public V leftShift(Object arg) {
        return this.call(arg);
    }

    public Closure<V> memoize() {
        return Memoize.buildMemoizeFunction(new ConcurrentCommonCache<Object, Object>(), this);
    }

    public Closure<V> memoizeAtMost(int maxCacheSize) {
        if (maxCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the maxCacheSize parameter for memoizeAtMost.");
        }
        return Memoize.buildMemoizeFunction(new LRUCache<Object, Object>(maxCacheSize), this);
    }

    public Closure<V> memoizeAtLeast(int protectedCacheSize) {
        if (protectedCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the protectedCacheSize parameter for memoizeAtLeast.");
        }
        return Memoize.buildSoftReferenceMemoizeFunction(protectedCacheSize, new ConcurrentSoftCache<Object, Object>(), this);
    }

    public Closure<V> memoizeBetween(int protectedCacheSize, int maxCacheSize) {
        if (protectedCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the protectedCacheSize parameter for memoizeBetween.");
        }
        if (maxCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the maxCacheSize parameter for memoizeBetween.");
        }
        if (protectedCacheSize > maxCacheSize) {
            throw new IllegalArgumentException("The maxCacheSize parameter to memoizeBetween is required to be greater or equal to the protectedCacheSize parameter.");
        }
        return Memoize.buildSoftReferenceMemoizeFunction(protectedCacheSize, new ConcurrentSoftCache<Object, Object>(maxCacheSize), this);
    }

    public Closure<V> trampoline(Object ... args) {
        return new TrampolineClosure<V>(this.curry(args));
    }

    public Closure<V> trampoline() {
        return new TrampolineClosure(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getDirective() {
        return this.directive;
    }

    public void setDirective(int directive) {
        this.directive = directive;
    }

    public Closure<V> dehydrate() {
        Closure result = (Closure)this.clone();
        result.delegate = null;
        result.owner = null;
        result.thisObject = null;
        return result;
    }

    public Closure<V> rehydrate(Object delegate, Object owner, Object thisObject) {
        Closure result = (Closure)this.clone();
        result.delegate = delegate;
        result.owner = owner;
        result.thisObject = thisObject;
        return result;
    }

    private class WritableClosure
    extends Closure
    implements Writable {
        private static final long serialVersionUID = -5749205698681690370L;

        public WritableClosure() {
            super(Closure.this);
        }

        @Override
        public Writer writeTo(Writer out) throws IOException {
            Closure.this.call(new Object[]{out});
            return out;
        }

        @Override
        public Object invokeMethod(String method, Object arguments) {
            if ("clone".equals(method)) {
                return this.clone();
            }
            if ("curry".equals(method)) {
                return this.curry((Object[])arguments);
            }
            if ("asWritable".equals(method)) {
                return this.asWritable();
            }
            return Closure.this.invokeMethod(method, arguments);
        }

        @Override
        public Object getProperty(String property) {
            return Closure.this.getProperty(property);
        }

        @Override
        public void setProperty(String property, Object newValue) {
            Closure.this.setProperty(property, newValue);
        }

        @Override
        public Object call() {
            return ((Closure)this.getOwner()).call();
        }

        public Object call(Object arguments) {
            return ((Closure)this.getOwner()).call(arguments);
        }

        public Object call(Object ... args) {
            return ((Closure)this.getOwner()).call(args);
        }

        public Object doCall(Object ... args) {
            return this.call(args);
        }

        @Override
        public Object getDelegate() {
            return Closure.this.getDelegate();
        }

        @Override
        public void setDelegate(Object delegate) {
            Closure.this.setDelegate(delegate);
        }

        public Class[] getParameterTypes() {
            return Closure.this.getParameterTypes();
        }

        @Override
        public int getMaximumNumberOfParameters() {
            return Closure.this.getMaximumNumberOfParameters();
        }

        @Override
        public Closure asWritable() {
            return this;
        }

        @Override
        public void run() {
            Closure.this.run();
        }

        @Override
        public Object clone() {
            return ((Closure)Closure.this.clone()).asWritable();
        }

        public int hashCode() {
            return Closure.this.hashCode();
        }

        public boolean equals(Object arg0) {
            return Closure.this.equals(arg0);
        }

        public String toString() {
            StringBuilderWriter writer = new StringBuilderWriter();
            try {
                this.writeTo(writer);
            }
            catch (IOException e) {
                return "";
            }
            return ((Object)writer).toString();
        }

        public Closure curry(Object ... arguments) {
            return new CurriedClosure(this, arguments).asWritable();
        }

        @Override
        public void setResolveStrategy(int resolveStrategy) {
            Closure.this.setResolveStrategy(resolveStrategy);
        }

        @Override
        public int getResolveStrategy() {
            return Closure.this.getResolveStrategy();
        }
    }
}

