/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.apache.groovy.lang.annotation.Incubating;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.RecordComponentNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.RecordTypeASTTransformation;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ClassNode
extends AnnotatedNode {
    public static final ClassNode[] EMPTY_ARRAY = new ClassNode[0];
    public static final ClassNode THIS = new ClassNode(Object.class);
    public static final ClassNode SUPER = new ClassNode(Object.class);
    private String name;
    private int modifiers;
    private ClassNode[] interfaces;
    private MixinNode[] mixins;
    private List<Statement> objectInitializers;
    private List<ConstructorNode> constructors;
    private final MapOfLists methods = new MapOfLists();
    private List<MethodNode> methodsList = Collections.emptyList();
    private List<FieldNode> fields;
    private List<PropertyNode> properties;
    private Map<String, FieldNode> fieldIndex;
    private ClassNode superClass;
    protected boolean isPrimaryNode;
    private List<ClassNode> permittedSubclasses = new ArrayList<ClassNode>();
    private List<RecordComponentNode> recordComponents = Collections.emptyList();
    protected final Object lazyInitLock = new Object();
    private volatile boolean lazyInitDone = true;
    protected Class<?> clazz;
    private ClassNode componentType;
    private ClassNode redirect;
    private List<InnerClassNode> innerClasses;
    private MethodNode enclosingMethod;
    private GenericsType[] genericsTypes;
    private boolean placeholder;
    private boolean usesGenerics;
    private boolean script;
    private boolean scriptBody;
    private boolean staticClass;
    private boolean syntheticPublic;
    private boolean annotated;
    private List<AnnotationNode> typeAnnotations = Collections.emptyList();
    private Map<CompilePhase, Map<Class<? extends ASTTransformation>, Set<ASTNode>>> transformInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyClassInit() {
        if (this.lazyInitDone) {
            return;
        }
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.redirect != null) {
                throw new GroovyBugError("lazyClassInit called on a proxy ClassNode. A redirect() call is missing somewhere!");
            }
            if (this.lazyInitDone) {
                return;
            }
            VMPluginFactory.getPlugin().configureClassNode(this.getCompileUnit(), this);
            this.lazyInitDone = true;
        }
    }

    public ClassNode(String name, int modifiers, ClassNode superClass, ClassNode[] interfaces, MixinNode[] mixins) {
        this.name = name;
        this.modifiers = modifiers;
        this.isPrimaryNode = true;
        this.setSuperClass(superClass);
        this.setInterfaces(interfaces);
        this.setMixins(mixins);
    }

    public ClassNode(String name, int modifiers, ClassNode superClass) {
        this(name, modifiers, superClass, EMPTY_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public ClassNode(Class<?> c) {
        this(c.getName(), c.getModifiers(), null, null, MixinNode.EMPTY_ARRAY);
        this.clazz = c;
        this.lazyInitDone = false;
        this.isPrimaryNode = false;
    }

    private ClassNode(Class<?> c, ClassNode componentType) {
        this(c);
        this.componentType = componentType;
    }

    private ClassNode(ClassNode componentType) {
        this(componentType.getName() + "[]", 1, ClassHelper.OBJECT_TYPE);
        this.componentType = componentType.redirect();
        this.isPrimaryNode = false;
    }

    public ClassNode redirect() {
        return this.redirect == null ? this : this.redirect.redirect();
    }

    public boolean isRedirectNode() {
        return this.redirect != null;
    }

    public void setRedirect(ClassNode node) {
        if (this.isPrimaryNode) {
            throw new GroovyBugError("tried to set a redirect for a primary ClassNode (" + this.getName() + "->" + node.getName() + ").");
        }
        if (node != null && !this.isGenericsPlaceHolder()) {
            node = node.redirect();
        }
        if (node == this) {
            return;
        }
        this.redirect = node;
    }

    public boolean isPrimaryClassNode() {
        return this.redirect().isPrimaryNode || this.componentType != null && this.componentType.isPrimaryClassNode();
    }

    public ClassNode getPlainNodeReference() {
        return this.getPlainNodeReference(true);
    }

    public ClassNode getPlainNodeReference(boolean skipPrimitives) {
        if (skipPrimitives && ClassHelper.isPrimitiveType(this)) {
            return this;
        }
        ClassNode n = new ClassNode(this.name, this.modifiers, this.superClass, null, null);
        n.isPrimaryNode = false;
        n.setRedirect(this.redirect());
        if (this.isArray()) {
            n.componentType = this.redirect().getComponentType();
        }
        return n;
    }

    public ModuleNode getModule() {
        return (ModuleNode)this.redirect().getNodeMetaData(ModuleNode.class);
    }

    public void setModule(ModuleNode module) {
        if (this.isPrimaryNode) {
            this.putNodeMetaData(ModuleNode.class, module);
        }
    }

    public CompileUnit getCompileUnit() {
        if (this.redirect != null) {
            return this.redirect.getCompileUnit();
        }
        return Optional.ofNullable(this.getModule()).map(ModuleNode::getUnit).orElse(null);
    }

    @Deprecated(forRemoval=true, since="5.0.0")
    protected void setCompileUnit(CompileUnit cu) {
        if (this.redirect != null) {
            this.redirect.setCompileUnit(cu);
        }
    }

    public PackageNode getPackage() {
        return Optional.ofNullable(this.getModule()).map(ModuleNode::getPackage).orElse(null);
    }

    public String getPackageName() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(0, idx);
        }
        return null;
    }

    public boolean hasPackageName() {
        return this.getName().indexOf(46) > 0;
    }

    public String getNameWithoutPackage() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(idx + 1);
        }
        return this.getName();
    }

    public String getUnresolvedName() {
        return this.name;
    }

    public ClassNode getUnresolvedSuperClass() {
        return this.getUnresolvedSuperClass(true);
    }

    public ClassNode getUnresolvedSuperClass(boolean deref) {
        if (deref) {
            if (this.redirect != null) {
                return this.redirect.getUnresolvedSuperClass(true);
            }
            this.lazyClassInit();
        }
        return this.superClass;
    }

    public void setUnresolvedSuperClass(ClassNode superClass) {
        this.superClass = superClass;
    }

    public ClassNode[] getUnresolvedInterfaces() {
        return this.getUnresolvedInterfaces(true);
    }

    public ClassNode[] getUnresolvedInterfaces(boolean deref) {
        if (deref) {
            if (this.redirect != null) {
                return this.redirect.getUnresolvedInterfaces(true);
            }
            this.lazyClassInit();
        }
        return this.interfaces;
    }

    @Override
    public String getText() {
        return this.getName();
    }

    public String getName() {
        return this.redirect().name;
    }

    public String setName(String name) {
        return this.redirect != null ? this.redirect.setName(name) : (this.name = name);
    }

    public int getModifiers() {
        return this.redirect().modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public ClassNode getSuperClass() {
        if (!this.lazyInitDone && !this.isResolved()) {
            throw new GroovyBugError("ClassNode#getSuperClass for " + this.getName() + " called before class resolving");
        }
        ClassNode sn = this.redirect().getUnresolvedSuperClass();
        if (sn != null) {
            sn = sn.redirect();
        }
        return sn;
    }

    public void setSuperClass(ClassNode superClass) {
        if (this.redirect != null) {
            this.redirect.setSuperClass(superClass);
        } else {
            this.superClass = superClass;
            if (superClass != null && !this.usesGenerics && this.isPrimaryNode) {
                this.usesGenerics = superClass.isUsingGenerics();
            }
        }
    }

    public ClassNode[] getInterfaces() {
        if (this.redirect != null) {
            return this.redirect.getInterfaces();
        }
        this.lazyClassInit();
        return this.interfaces;
    }

    public Set<ClassNode> getAllInterfaces() {
        LinkedHashSet<ClassNode> result = new LinkedHashSet<ClassNode>();
        if (this.isInterface()) {
            result.add(this);
        }
        this.getAllInterfaces(result);
        return result;
    }

    private void getAllInterfaces(Set<ClassNode> set) {
        for (ClassNode face : this.getInterfaces()) {
            if (!set.add(face)) continue;
            face.getAllInterfaces(set);
        }
    }

    public void setInterfaces(ClassNode[] interfaces) {
        if (this.redirect != null) {
            this.redirect.setInterfaces(interfaces);
        } else {
            this.interfaces = interfaces;
            if (interfaces != null && !this.usesGenerics && this.isPrimaryNode) {
                int n = interfaces.length;
                for (int i = 0; i < n; ++i) {
                    this.usesGenerics |= interfaces[i].isUsingGenerics();
                }
            }
        }
    }

    public MixinNode[] getMixins() {
        return this.redirect().mixins;
    }

    public void setMixins(MixinNode[] mixins) {
        if (this.redirect != null) {
            this.redirect.setMixins(mixins);
        } else {
            this.mixins = mixins;
        }
    }

    @Incubating
    public List<ClassNode> getPermittedSubclasses() {
        if (this.redirect != null) {
            return this.redirect.getPermittedSubclasses();
        }
        this.lazyClassInit();
        return this.permittedSubclasses;
    }

    @Incubating
    public void setPermittedSubclasses(List<ClassNode> permittedSubclasses) {
        if (this.redirect != null) {
            this.redirect.setPermittedSubclasses(permittedSubclasses);
        } else {
            this.permittedSubclasses = permittedSubclasses;
        }
    }

    @Incubating
    public List<RecordComponentNode> getRecordComponents() {
        if (this.redirect != null) {
            return this.redirect.getRecordComponents();
        }
        this.lazyClassInit();
        return this.recordComponents;
    }

    @Incubating
    public void setRecordComponents(List<RecordComponentNode> recordComponents) {
        if (this.redirect != null) {
            this.redirect.setRecordComponents(recordComponents);
        } else {
            this.recordComponents = recordComponents;
        }
    }

    public void addInterface(ClassNode node) {
        ClassNode[] interfaces;
        for (ClassNode face : interfaces = this.getInterfaces()) {
            if (!face.equals(node)) continue;
            return;
        }
        int n = interfaces.length;
        ClassNode[] classNodeArray = interfaces;
        interfaces = new ClassNode[n + 1];
        System.arraycopy(classNodeArray, 0, interfaces, 0, n);
        interfaces[n] = node;
        this.setInterfaces(interfaces);
    }

    public void addMixin(MixinNode node) {
        MixinNode[] mixins = this.getMixins();
        boolean skip = false;
        for (MixinNode existing : mixins) {
            if (!node.equals(existing)) continue;
            skip = true;
            break;
        }
        if (!skip) {
            MixinNode[] newMixins = new MixinNode[mixins.length + 1];
            System.arraycopy(mixins, 0, newMixins, 0, mixins.length);
            newMixins[mixins.length] = node;
            this.setMixins(newMixins);
        }
    }

    public void addField(FieldNode node) {
        this.addField(node, true);
    }

    private void addField(FieldNode node, boolean append) {
        ClassNode r = this.redirect();
        node.setDeclaringClass(r);
        node.setOwner(r);
        if (r.fields == null) {
            r.fields = new ArrayList<FieldNode>(4);
        }
        if (r.fieldIndex == null) {
            r.fieldIndex = new LinkedHashMap<String, FieldNode>();
        }
        if (append) {
            r.fields.add(node);
        } else {
            r.fields.add(0, node);
        }
        r.fieldIndex.put(node.getName(), node);
    }

    public FieldNode addField(String name, int modifiers, ClassNode type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.redirect(), initialValue);
        this.addField(node);
        return node;
    }

    public void addFieldFirst(FieldNode node) {
        this.addField(node, false);
    }

    public FieldNode addFieldFirst(String name, int modifiers, ClassNode type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.redirect(), initialValue);
        this.addFieldFirst(node);
        return node;
    }

    public void addProperty(PropertyNode node) {
        node.setDeclaringClass(this.redirect());
        this.addField(node.getField());
        this.getProperties().add(node);
    }

    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValue, Statement getterBlock, Statement setterBlock) {
        for (PropertyNode pn : this.getProperties()) {
            if (!pn.getName().equals(name)) continue;
            if (pn.getInitialExpression() == null && initialValue != null) {
                pn.getField().setInitialValueExpression(initialValue);
            }
            if (pn.getGetterBlock() == null && getterBlock != null) {
                pn.setGetterBlock(getterBlock);
            }
            if (pn.getSetterBlock() == null && setterBlock != null) {
                pn.setSetterBlock(setterBlock);
            }
            return pn;
        }
        PropertyNode node = new PropertyNode(name, modifiers, type, this.redirect(), initialValue, getterBlock, setterBlock);
        this.addProperty(node);
        return node;
    }

    public void addMethod(MethodNode node) {
        ClassNode r = this.redirect();
        node.setDeclaringClass(r);
        if (r.methodsList.isEmpty()) {
            r.methodsList = new ArrayList<MethodNode>(4);
        }
        r.methodsList.add(node);
        r.methods.put(node.getName(), node);
    }

    public MethodNode addMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode other = this.getDeclaredMethod(name, parameters);
        if (other != null) {
            return other;
        }
        MethodNode node = new MethodNode(name, modifiers, returnType, parameters, exceptions, code);
        this.addMethod(node);
        return node;
    }

    public MethodNode addSyntheticMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode node = this.addMethod(name, modifiers | 0x1000, returnType, parameters, exceptions, code);
        node.setSynthetic(true);
        return node;
    }

    public void addConstructor(ConstructorNode node) {
        ClassNode r = this.redirect();
        node.setDeclaringClass(r);
        if (r.constructors == null) {
            r.constructors = new ArrayList<ConstructorNode>(4);
        }
        r.constructors.add(node);
    }

    public ConstructorNode addConstructor(int modifiers, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        ConstructorNode node = new ConstructorNode(modifiers, parameters, exceptions, code);
        this.addConstructor(node);
        return node;
    }

    public void addObjectInitializerStatements(Statement statement) {
        this.getObjectInitializerStatements().add(statement);
    }

    public void addStaticInitializerStatements(List<Statement> statements, boolean fieldInit) {
        MethodNode method = this.getOrAddStaticInitializer();
        BlockStatement block = MethodNodeUtils.getCodeAsBlock(method);
        if (!fieldInit) {
            block.addStatements(statements);
        } else {
            List<Statement> blockStatements = block.getStatements();
            statements.addAll(blockStatements);
            blockStatements.clear();
            blockStatements.addAll(statements);
        }
    }

    public void positionStmtsAfterEnumInitStmts(List<Statement> staticFieldInitializerStatements) {
        MethodNode constructor = this.getOrAddStaticInitializer();
        Statement statement = constructor.getCode();
        if (statement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement;
            List<Statement> blockStatements = block.getStatements();
            ListIterator<Statement> it = blockStatements.listIterator();
            while (it.hasNext()) {
                FieldExpression fExp;
                BinaryExpression bExp;
                Statement stmt = it.next();
                if (!(stmt instanceof ExpressionStatement) || !(((ExpressionStatement)stmt).getExpression() instanceof BinaryExpression) || !((bExp = (BinaryExpression)((ExpressionStatement)stmt).getExpression()).getLeftExpression() instanceof FieldExpression) || !(fExp = (FieldExpression)bExp.getLeftExpression()).getFieldName().equals("$VALUES")) continue;
                for (Statement initStmt : staticFieldInitializerStatements) {
                    it.add(initStmt);
                }
            }
        }
    }

    private MethodNode getOrAddStaticInitializer() {
        MethodNode method;
        String classInitializer = "<clinit>";
        List<MethodNode> declaredMethods = this.getDeclaredMethods("<clinit>");
        if (declaredMethods.isEmpty()) {
            method = this.addMethod("<clinit>", 8, ClassHelper.VOID_TYPE, Parameter.EMPTY_ARRAY, EMPTY_ARRAY, new BlockStatement());
            method.setSynthetic(true);
        } else {
            method = declaredMethods.get(0);
        }
        return method;
    }

    public List<FieldNode> getFields() {
        if (this.redirect != null) {
            return this.redirect.getFields();
        }
        this.lazyClassInit();
        if (this.fields == null) {
            this.fields = new ArrayList<FieldNode>();
        }
        return this.fields;
    }

    public List<PropertyNode> getProperties() {
        if (this.redirect != null) {
            return this.redirect.getProperties();
        }
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyNode>();
        }
        return this.properties;
    }

    @Deprecated(forRemoval=true, since="5.0.0")
    public Map<String, FieldNode> getFieldIndex() {
        return this.fieldIndex;
    }

    public boolean hasProperty(String name) {
        return this.getProperties().stream().map(PropertyNode::getName).anyMatch(name::equals);
    }

    public PropertyNode getProperty(String name) {
        return this.getProperties().stream().filter(pn -> pn.getName().equals(name)).findFirst().orElse(null);
    }

    public List<MethodNode> getMethods() {
        if (this.redirect != null) {
            return this.redirect.getMethods();
        }
        this.lazyClassInit();
        return this.methodsList;
    }

    public List<MethodNode> getAbstractMethods() {
        return this.getDeclaredMethodsMap().values().stream().filter(MethodNode::isAbstract).collect(Collectors.toList());
    }

    public List<MethodNode> getAllDeclaredMethods() {
        return new ArrayList<MethodNode>(this.getDeclaredMethodsMap().values());
    }

    public Map<String, MethodNode> getDeclaredMethodsMap() {
        Map<String, MethodNode> result = ClassNodeUtils.getDeclaredMethodsFromSuper(this);
        ClassNodeUtils.addDeclaredMethodsFromInterfaces(this, result);
        for (MethodNode method : this.getMethods()) {
            result.put(method.getTypeDescriptor(), method);
        }
        return result;
    }

    public List<ConstructorNode> getDeclaredConstructors() {
        if (this.redirect != null) {
            return this.redirect.getDeclaredConstructors();
        }
        this.lazyClassInit();
        if (this.constructors == null) {
            this.constructors = new ArrayList<ConstructorNode>();
        }
        return this.constructors;
    }

    public ConstructorNode getDeclaredConstructor(Parameter[] parameters) {
        for (ConstructorNode constructor : this.getDeclaredConstructors()) {
            if (!this.parametersEqual(constructor.getParameters(), parameters)) continue;
            return constructor;
        }
        return null;
    }

    public boolean hasMethod(String name, Parameter[] parameters) {
        return this.getMethod(name, parameters) != null;
    }

    public boolean hasDeclaredMethod(String name, Parameter[] parameters) {
        return this.getDeclaredMethod(name, parameters) != null;
    }

    public FieldNode getDeclaredField(String name) {
        if (this.redirect != null) {
            return this.redirect.getDeclaredField(name);
        }
        this.lazyClassInit();
        return this.fieldIndex == null ? null : this.fieldIndex.get(name);
    }

    public FieldNode getField(String name) {
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            FieldNode fn = node.getDeclaredField(name);
            if (fn == null) continue;
            return fn;
        }
        return null;
    }

    public List<Statement> getObjectInitializerStatements() {
        if (this.objectInitializers == null) {
            this.objectInitializers = new ArrayList<Statement>();
        }
        return this.objectInitializers;
    }

    public List<MethodNode> getDeclaredMethods(String name) {
        if (this.redirect != null) {
            return this.redirect.getDeclaredMethods(name);
        }
        this.lazyClassInit();
        return this.methods.get(name);
    }

    public List<MethodNode> getMethods(String name) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            result.addAll(node.getDeclaredMethods(name));
        }
        return result;
    }

    public MethodNode getDeclaredMethod(String name, Parameter[] parameters) {
        for (MethodNode method : this.getDeclaredMethods(name)) {
            if (!this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public MethodNode getMethod(String name, Parameter[] parameters) {
        for (MethodNode method : this.getMethods(name)) {
            if (!this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public boolean isDerivedFrom(ClassNode type) {
        if (ClassHelper.isPrimitiveVoid(this)) {
            return ClassHelper.isPrimitiveVoid(type);
        }
        if (ClassHelper.isObjectType(type)) {
            return true;
        }
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            if (!type.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromGroovyObject() {
        return this.implementsInterface(ClassHelper.GROOVY_OBJECT_TYPE);
    }

    public boolean implementsAnyInterfaces(ClassNode ... classNodes) {
        for (ClassNode classNode : classNodes) {
            if (!this.implementsInterface(classNode)) continue;
            return true;
        }
        return false;
    }

    public boolean implementsInterface(ClassNode classNode) {
        ClassNode node = this.redirect();
        do {
            if (!node.declaresInterface(classNode)) continue;
            return true;
        } while ((node = node.getSuperClass()) != null);
        return false;
    }

    public boolean declaresAnyInterfaces(ClassNode ... classNodes) {
        for (ClassNode classNode : classNodes) {
            if (!this.declaresInterface(classNode)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresInterface(ClassNode classNode) {
        ClassNode[] interfaces;
        for (ClassNode face : interfaces = this.getInterfaces()) {
            if (!face.equals(classNode)) continue;
            return true;
        }
        for (ClassNode face : interfaces) {
            if (!face.declaresInterface(classNode)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="4.0.0")
    protected boolean parametersEqual(Parameter[] a, Parameter[] b) {
        return ParameterUtils.parametersEqual(a, b);
    }

    public MethodNode getGetterMethod(String getterName) {
        return this.getGetterMethod(getterName, true);
    }

    public MethodNode getGetterMethod(String getterName, boolean searchSuperClasses) {
        ClassNode parent;
        AnnotatedNode getterMethod = null;
        boolean booleanReturnOnly = getterName.startsWith("is");
        for (MethodNode method : this.getDeclaredMethods(getterName)) {
            if (!method.getName().equals(getterName) || method.getParameters().length != 0 || !(booleanReturnOnly ? ClassHelper.isPrimitiveBoolean(method.getReturnType()) : !method.isVoidMethod()) || getterMethod != null && !getterMethod.isSynthetic()) continue;
            getterMethod = method;
        }
        if (getterMethod != null) {
            return getterMethod;
        }
        if (searchSuperClasses && (parent = this.getSuperClass()) != null) {
            return parent.getGetterMethod(getterName);
        }
        return null;
    }

    public MethodNode getSetterMethod(String setterName) {
        return this.getSetterMethod(setterName, true);
    }

    public MethodNode getSetterMethod(String setterName, boolean voidOnly) {
        for (MethodNode method : this.getDeclaredMethods(setterName)) {
            if (!setterName.equals(method.getName()) || method.getParameters().length != 1 || voidOnly && !method.isVoidMethod()) continue;
            return method;
        }
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            return parent.getSetterMethod(setterName, voidOnly);
        }
        return null;
    }

    public boolean hasPossibleMethod(String name, Expression arguments) {
        int count = arguments instanceof TupleExpression ? ((TupleExpression)arguments).getExpressions().size() : 0;
        for (ClassNode cn = this; cn != null; cn = cn.getSuperClass()) {
            for (MethodNode mn : cn.getDeclaredMethods(name)) {
                if (mn.isStatic() || !ClassNode.hasCompatibleNumberOfArgs(mn, count)) continue;
                return true;
            }
            for (ClassNode in : cn.getAllInterfaces()) {
                for (MethodNode mn : in.getDeclaredMethods(name)) {
                    if (!mn.isDefault() || !ClassNode.hasCompatibleNumberOfArgs(mn, count)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public MethodNode tryFindPossibleMethod(String name, Expression arguments) {
        if (!(arguments instanceof TupleExpression)) {
            return null;
        }
        TupleExpression args = (TupleExpression)arguments;
        int nArgs = args.getExpressions().size();
        MethodNode method = null;
        for (ClassNode cn = this; cn != null; cn = cn.getSuperClass()) {
            for (MethodNode mn : cn.getDeclaredMethods(name)) {
                int i;
                if (!ClassNode.hasCompatibleNumberOfArgs(mn, nArgs)) continue;
                boolean match = true;
                for (i = 0; i < nArgs; ++i) {
                    if (ClassNode.hasCompatibleType(args, mn, i)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                if (method == null) {
                    method = mn;
                    continue;
                }
                if (cn.equals(this) || method.getParameters().length != nArgs) {
                    return null;
                }
                for (i = 0; i < nArgs; ++i) {
                    if (ClassNode.hasExactMatchingCompatibleType(method, mn, i)) continue;
                    return null;
                }
            }
        }
        return method;
    }

    private static boolean hasExactMatchingCompatibleType(MethodNode match, MethodNode maybe, int i) {
        int lastParamIndex = maybe.getParameters().length - 1;
        return i <= lastParamIndex && match.getParameters()[i].getType().equals(maybe.getParameters()[i].getType()) || i >= lastParamIndex && ClassNode.isPotentialVarArg(maybe, lastParamIndex) && match.getParameters()[i].getType().equals(maybe.getParameters()[lastParamIndex].getType().getComponentType());
    }

    private static boolean hasCompatibleType(TupleExpression args, MethodNode method, int i) {
        int lastParamIndex = method.getParameters().length - 1;
        return i <= lastParamIndex && args.getExpression(i).getType().isDerivedFrom(method.getParameters()[i].getType()) || i >= lastParamIndex && ClassNode.isPotentialVarArg(method, lastParamIndex) && args.getExpression(i).getType().isDerivedFrom(method.getParameters()[lastParamIndex].getType().getComponentType());
    }

    private static boolean hasCompatibleNumberOfArgs(MethodNode method, int nArgs) {
        int lastParamIndex = method.getParameters().length - 1;
        return nArgs == method.getParameters().length || nArgs >= lastParamIndex && ClassNode.isPotentialVarArg(method, lastParamIndex);
    }

    private static boolean isPotentialVarArg(MethodNode method, int lastParamIndex) {
        return lastParamIndex >= 0 && method.getParameters()[lastParamIndex].getType().isArray();
    }

    public boolean hasPossibleStaticMethod(String name, Expression arguments) {
        return ClassNodeUtils.hasPossibleStaticMethod(this, name, arguments, false);
    }

    public void renameField(String oldName, String newName) {
        ClassNode r = this.redirect();
        Map<String, FieldNode> index = r.fieldIndex;
        if (index != null) {
            index.put(newName, index.remove(oldName));
        }
    }

    public void removeField(String oldName) {
        ClassNode r = this.redirect();
        Map<String, FieldNode> index = r.fieldIndex;
        if (index != null) {
            r.fields.remove(index.remove(oldName));
        }
    }

    public void removeMethod(MethodNode node) {
        ClassNode r = this.redirect();
        if (!r.methodsList.isEmpty()) {
            r.methodsList.remove(node);
        }
        r.methods.remove(node.getName(), node);
    }

    public void removeConstructor(ConstructorNode node) {
        this.getDeclaredConstructors().remove(node);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof ClassNode)) {
            return false;
        }
        if (this.redirect != null) {
            return this.redirect.equals(that);
        }
        if (this.componentType != null) {
            return this.componentType.equals(((ClassNode)that).componentType);
        }
        return ((ClassNode)that).getText().equals(this.getText());
    }

    public int hashCode() {
        return this.redirect != null ? this.redirect.hashCode() : this.getText().hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showRedirect) {
        if (this.isArray()) {
            return this.getComponentType().toString(showRedirect) + "[]";
        }
        boolean placeholder = this.isGenericsPlaceHolder();
        StringBuilder ret = new StringBuilder(!placeholder ? this.getName() : this.getUnresolvedName());
        GenericsType[] genericsTypes = this.getGenericsTypes();
        if (!placeholder && genericsTypes != null) {
            ret.append('<');
            int n = genericsTypes.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    ret.append(", ");
                }
                ret.append(genericsTypes[i]);
            }
            ret.append('>');
        }
        if (showRedirect && this.redirect != null) {
            ret.append(" -> ").append(this.redirect);
        }
        return ret.toString();
    }

    public void visitContents(GroovyClassVisitor visitor) {
        for (PropertyNode pn : this.getProperties()) {
            visitor.visitProperty(pn);
        }
        for (FieldNode fn : this.getFields()) {
            visitor.visitField(fn);
        }
        for (ConstructorNode cn : this.getDeclaredConstructors()) {
            visitor.visitConstructor(cn);
        }
        this.visitMethods(visitor);
    }

    private void visitMethods(GroovyClassVisitor visitor) {
        ArrayList<MethodNode> changedMethodList;
        boolean changed;
        ArrayList<MethodNode> methodList = new ArrayList<MethodNode>(this.getMethods());
        for (MethodNode mn : methodList) {
            visitor.visitMethod(mn);
        }
        List<MethodNode> newMethodList = this.getMethods();
        if (newMethodList.size() > methodList.size() && (changed = (changedMethodList = new ArrayList<MethodNode>(newMethodList)).removeAll(methodList))) {
            for (MethodNode mn : changedMethodList) {
                visitor.visitMethod(mn);
            }
        }
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public boolean isAnnotationDefinition() {
        return this.isInterface() && (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Incubating
    public boolean isRecord() {
        return RecordTypeASTTransformation.recordNative(this);
    }

    @Incubating
    public boolean isSealed() {
        if (this.redirect != null) {
            return this.redirect.isSealed();
        }
        return !this.getAnnotations(ClassHelper.SEALED_TYPE).isEmpty() || !this.getPermittedSubclasses().isEmpty();
    }

    public boolean isResolved() {
        if (this.clazz != null) {
            return true;
        }
        if (this.redirect != null) {
            return this.redirect.isResolved();
        }
        return this.componentType != null && this.componentType.isResolved();
    }

    public Class getTypeClass() {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.redirect != null) {
            return this.redirect.getTypeClass();
        }
        ClassNode component = this.redirect().componentType;
        if (component != null && component.isResolved()) {
            return Array.newInstance(component.getTypeClass(), 0).getClass();
        }
        throw new GroovyBugError("ClassNode#getTypeClass for " + this.getName() + " called before the type class is set");
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public ClassNode makeArray() {
        ClassNode node;
        if (this.redirect != null) {
            node = this.redirect.makeArray();
            node.componentType = this;
        } else if (this.clazz != null) {
            Class<?> type = Array.newInstance(this.clazz, 0).getClass();
            node = new ClassNode(type, this);
        } else {
            node = new ClassNode(this);
        }
        return node;
    }

    public ClassNode getComponentType() {
        return this.componentType;
    }

    public ClassNode getOuterClass() {
        if (this.redirect != null) {
            return this.redirect.getOuterClass();
        }
        return null;
    }

    public List<ClassNode> getOuterClasses() {
        ClassNode outer = this.getOuterClass();
        if (outer == null) {
            return Collections.emptyList();
        }
        ArrayList<ClassNode> result = new ArrayList<ClassNode>(4);
        do {
            result.add(outer);
        } while ((outer = outer.getOuterClass()) != null);
        return result;
    }

    public FieldNode getOuterField(String name) {
        if (this.redirect != null) {
            return this.redirect.getOuterField(name);
        }
        return null;
    }

    void addInnerClass(InnerClassNode innerClass) {
        if (this.redirect != null) {
            this.redirect.addInnerClass(innerClass);
        } else {
            if (this.innerClasses == null) {
                this.innerClasses = new ArrayList<InnerClassNode>(4);
            }
            this.innerClasses.add(innerClass);
        }
    }

    public Iterator<InnerClassNode> getInnerClasses() {
        if (this.innerClasses == null) {
            return Collections.emptyIterator();
        }
        return Collections.unmodifiableList(this.innerClasses).iterator();
    }

    public MethodNode getEnclosingMethod() {
        return this.redirect().enclosingMethod;
    }

    public void setEnclosingMethod(MethodNode enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    public GenericsType asGenericsType() {
        if (!this.isGenericsPlaceHolder()) {
            return new GenericsType(this);
        }
        if (this.genericsTypes != null && this.genericsTypes[0].getUpperBounds() != null) {
            return this.genericsTypes[0];
        }
        ClassNode upper = this.redirect != null ? this.redirect : this;
        return new GenericsType(this, new ClassNode[]{upper}, null);
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.usesGenerics = this.usesGenerics || genericsTypes != null;
        this.genericsTypes = genericsTypes;
    }

    public boolean isGenericsPlaceHolder() {
        return this.placeholder;
    }

    public void setGenericsPlaceHolder(boolean placeholder) {
        this.usesGenerics = this.usesGenerics || placeholder;
        this.placeholder = placeholder;
    }

    public boolean isUsingGenerics() {
        return this.usesGenerics;
    }

    public void setUsingGenerics(boolean usesGenerics) {
        this.usesGenerics = usesGenerics;
    }

    public boolean isScript() {
        return this.redirect().script || this.isDerivedFrom(ClassHelper.SCRIPT_TYPE);
    }

    public void setScript(boolean script) {
        this.script = script;
    }

    public boolean isScriptBody() {
        return this.redirect().scriptBody;
    }

    public void setScriptBody(boolean scriptBody) {
        this.scriptBody = scriptBody;
    }

    public boolean isStaticClass() {
        return this.redirect().staticClass;
    }

    public void setStaticClass(boolean staticClass) {
        this.staticClass = staticClass;
    }

    public boolean isSyntheticPublic() {
        return this.syntheticPublic;
    }

    public void setSyntheticPublic(boolean syntheticPublic) {
        this.syntheticPublic = syntheticPublic;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        if (this.redirect != null) {
            return this.redirect.getAnnotations();
        }
        this.lazyClassInit();
        return super.getAnnotations();
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        if (this.redirect != null) {
            return this.redirect.getAnnotations(type);
        }
        this.lazyClassInit();
        return super.getAnnotations(type);
    }

    public List<AnnotationNode> getTypeAnnotations() {
        return new ArrayList<AnnotationNode>(this.typeAnnotations);
    }

    public List<AnnotationNode> getTypeAnnotations(ClassNode type) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        for (AnnotationNode node : this.typeAnnotations) {
            if (!type.equals(node.getClassNode())) continue;
            annotations.add(node);
        }
        return annotations;
    }

    public void addTypeAnnotation(AnnotationNode annotation) {
        if (!this.isPrimaryClassNode() && !this.isRedirectNode() && this.isResolved()) {
            throw new GroovyBugError("Adding type annotation @" + annotation.getClassNode().getNameWithoutPackage() + " to non-primary, non-redirect node: " + this.getName());
        }
        if (this.typeAnnotations == Collections.EMPTY_LIST) {
            this.typeAnnotations = new ArrayList<AnnotationNode>(3);
        }
        this.typeAnnotations.add(Objects.requireNonNull(annotation));
        this.setAnnotated(true);
    }

    public void addTypeAnnotations(List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            this.addTypeAnnotation(annotation);
        }
    }

    public void addTransform(Class<? extends ASTTransformation> transform, ASTNode node) {
        GroovyASTTransformation annotation = transform.getAnnotation(GroovyASTTransformation.class);
        if (annotation != null) {
            Map<Class<? extends ASTTransformation>, Set<ASTNode>> transforms = this.getTransforms(annotation.phase());
            Set nodes = transforms.computeIfAbsent(transform, k -> new LinkedHashSet());
            nodes.add(node);
        }
    }

    public Map<Class<? extends ASTTransformation>, Set<ASTNode>> getTransforms(CompilePhase phase) {
        return this.getTransformInstances().get((Object)phase);
    }

    private Map<CompilePhase, Map<Class<? extends ASTTransformation>, Set<ASTNode>>> getTransformInstances() {
        if (this.transformInstances == null) {
            this.transformInstances = new EnumMap<CompilePhase, Map<Class<? extends ASTTransformation>, Set<ASTNode>>>(CompilePhase.class);
            for (CompilePhase phase : CompilePhase.values()) {
                this.transformInstances.put(phase, new LinkedHashMap());
            }
        }
        return this.transformInstances;
    }

    private static class MapOfLists {
        Map<Object, List<MethodNode>> map;

        private MapOfLists() {
        }

        List<MethodNode> get(Object key) {
            return Optional.ofNullable(this.map).map(m -> (List)m.get(key)).orElseGet(Collections::emptyList);
        }

        void put(Object key, MethodNode value) {
            if (this.map == null) {
                this.map = new LinkedHashMap<Object, List<MethodNode>>();
            }
            this.map.computeIfAbsent(key, k -> new ArrayList(2)).add(value);
        }

        void remove(Object key, MethodNode value) {
            this.get(key).remove(value);
        }
    }
}

