/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.Utils;

class TestNgMethodUtils {
    private TestNgMethodUtils() {
    }

    static boolean isConfigurationMethod(ITestNGMethod method) {
        return TestNgMethodUtils.isConfigurationMethod(method, false);
    }

    private static boolean isConfigurationMethod(ITestNGMethod method, boolean includeGroupConfigs) {
        boolean flag;
        boolean bl = flag = method.isBeforeMethodConfiguration() || method.isAfterMethodConfiguration() || method.isBeforeTestConfiguration() || method.isAfterTestConfiguration() || method.isBeforeClassConfiguration() || method.isAfterClassConfiguration() || method.isBeforeSuiteConfiguration() || method.isAfterSuiteConfiguration();
        if (includeGroupConfigs) {
            flag = flag || method.isBeforeGroupsConfiguration() || method.isAfterGroupsConfiguration();
        }
        return flag;
    }

    private static boolean containsConfigurationMethod(ITestNGMethod method, List<ITestNGMethod> methods) {
        return TestNgMethodUtils.isConfigurationMethod(method, true) && methods.contains(method);
    }

    static ITestNGMethod[] filterBeforeTestMethods(Object instance, ITestClass testClass, BiPredicate<ITestNGMethod, IClass> predicate) {
        return TestNgMethodUtils.filterMethods(instance, testClass, testClass.getBeforeTestMethods(), predicate);
    }

    static ITestNGMethod[] filterAfterTestMethods(Object instance, ITestClass testClass, BiPredicate<ITestNGMethod, IClass> predicate) {
        return TestNgMethodUtils.filterMethods(instance, testClass, testClass.getAfterTestMethods(), predicate);
    }

    static ITestNGMethod[] filterMethods(Object instance, IClass testClass, ITestNGMethod[] methods, BiPredicate<ITestNGMethod, IClass> predicate) {
        List<ITestNGMethod> vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            String msg;
            if (predicate.test(tm, testClass) && TestNgMethodUtils.isSameInstance(tm, instance) && !TestNgMethodUtils.containsConfigurationMethod(tm, vResult)) {
                msg = Utils.getVerbose() < 10 ? "" : "Keeping method " + tm + " for class " + testClass;
                vResult.add(tm);
            } else {
                msg = Utils.getVerbose() < 10 ? "" : "Filtering out method " + tm + " for class " + testClass;
            }
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 10, msg);
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    private static boolean isSameInstance(ITestNGMethod tm, Object instance) {
        if (instance == null) {
            return true;
        }
        Object tmObject = Optional.ofNullable(tm).map(ITestNGMethod::getInstance).orElse(new Object());
        return instance.equals(tmObject);
    }

    static ITestNGMethod[] filterSetupConfigurationMethods(ITestNGMethod tm, ITestNGMethod[] methods) {
        List result = Lists.newArrayList();
        for (ITestNGMethod m : methods) {
            ConfigurationMethod cm = (ConfigurationMethod)m;
            if (!TestNgMethodUtils.doesSetupMethodPassFirstTimeFilter(cm, tm) || !TestNgMethodUtils.doesConfigMethodPassGroupFilters(cm, tm)) continue;
            result.add(m);
        }
        return result.toArray(new ITestNGMethod[0]);
    }

    static ITestNGMethod[] filterTeardownConfigurationMethods(ITestNGMethod tm, ITestNGMethod[] methods) {
        List result = Lists.newArrayList();
        for (ITestNGMethod m : methods) {
            ConfigurationMethod cm = (ConfigurationMethod)m;
            if (!TestNgMethodUtils.doesTeardownMethodPassLastTimeFilter(cm, tm) || !TestNgMethodUtils.doesConfigMethodPassGroupFilters(cm, tm)) continue;
            result.add(m);
        }
        return result.toArray(new ITestNGMethod[0]);
    }

    static boolean cannotRunMethodIndependently(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        return null != methods && methods.length > 0;
    }

    static Object getMethodInvocationToken(ITestNGMethod method, Object instance) {
        return String.format("%s+%d+%d", instance.toString(), method.getCurrentInvocationCount(), method.getParameterInvocationCount());
    }

    private static boolean doesSetupMethodPassFirstTimeFilter(ConfigurationMethod cm, ITestNGMethod tm) {
        return !cm.isFirstTimeOnly() || cm.isFirstTimeOnly() && tm.getCurrentInvocationCount() == 0;
    }

    private static boolean doesTeardownMethodPassLastTimeFilter(ConfigurationMethod cm, ITestNGMethod tm) {
        return !cm.isLastTimeOnly() || cm.isLastTimeOnly() && !tm.hasMoreInvocation();
    }

    private static boolean doesConfigMethodPassGroupFilters(ConfigurationMethod cm, ITestNGMethod tm) {
        String[] groupFilters = cm.getGroupFilters();
        if (groupFilters.length == 0) {
            return true;
        }
        String[] groups = tm.getGroups();
        if (groups.length == 0) {
            return false;
        }
        return !Collections.disjoint(Sets.newHashSet(groups), Sets.newHashSet(groupFilters));
    }
}

