/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.groovy.util.SystemUtil;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.vmplugin.v8.MethodHandleWrapper;

public class CacheableCallSite
extends MutableCallSite {
    private static final int CACHE_SIZE = SystemUtil.getIntegerSafe("groovy.indy.callsite.cache.size", 4);
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = (int)Math.ceil((float)CACHE_SIZE / 0.75f) + 1;
    private final MethodHandles.Lookup lookup;
    private volatile SoftReference<MethodHandleWrapper> latestHitMethodHandleWrapperSoftReference = null;
    private final AtomicLong fallbackCount = new AtomicLong();
    private MethodHandle defaultTarget;
    private MethodHandle fallbackTarget;
    private final Map<String, SoftReference<MethodHandleWrapper>> lruCache = new LinkedHashMap<String, SoftReference<MethodHandleWrapper>>(INITIAL_CAPACITY, 0.75f, true){
        private static final long serialVersionUID = 7785958879964294463L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > CACHE_SIZE;
        }
    };
    private static final BlockingQueue<Runnable> CACHE_CLEANER_QUEUE = new LinkedBlockingQueue<Runnable>();

    public CacheableCallSite(MethodType type, MethodHandles.Lookup lookup) {
        super(type);
        this.lookup = lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHandleWrapper getAndPut(String className, MemoizeCache.ValueProvider<? super String, ? extends MethodHandleWrapper> valueProvider) {
        MethodHandleWrapper methodHandleWrapper;
        SoftReference<MethodHandleWrapper> resultSoftReference;
        MethodHandleWrapper result = null;
        Map<String, SoftReference<MethodHandleWrapper>> map = this.lruCache;
        synchronized (map) {
            resultSoftReference = this.lruCache.get(className);
            if (null != resultSoftReference && null == (result = resultSoftReference.get())) {
                this.removeAllStaleEntriesOfLruCache();
            }
            if (null == result) {
                result = valueProvider.provide(className);
                resultSoftReference = new SoftReference<MethodHandleWrapper>(result);
                this.lruCache.put(className, resultSoftReference);
            }
        }
        SoftReference<MethodHandleWrapper> mhwsr = this.latestHitMethodHandleWrapperSoftReference;
        MethodHandleWrapper methodHandleWrapper2 = methodHandleWrapper = null == mhwsr ? null : mhwsr.get();
        if (methodHandleWrapper == result) {
            result.incrementLatestHitCount();
        } else {
            result.resetLatestHitCount();
            if (null != methodHandleWrapper) {
                methodHandleWrapper.resetLatestHitCount();
            }
            this.latestHitMethodHandleWrapperSoftReference = resultSoftReference;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHandleWrapper put(String name, MethodHandleWrapper mhw) {
        Map<String, SoftReference<MethodHandleWrapper>> map = this.lruCache;
        synchronized (map) {
            SoftReference<MethodHandleWrapper> methodHandleWrapperSoftReference = this.lruCache.put(name, new SoftReference<MethodHandleWrapper>(mhw));
            if (null == methodHandleWrapperSoftReference) {
                return null;
            }
            MethodHandleWrapper methodHandleWrapper = methodHandleWrapperSoftReference.get();
            if (null == methodHandleWrapper) {
                this.removeAllStaleEntriesOfLruCache();
            }
            return methodHandleWrapper;
        }
    }

    private void removeAllStaleEntriesOfLruCache() {
        CACHE_CLEANER_QUEUE.offer(() -> {
            Map<String, SoftReference<MethodHandleWrapper>> map = this.lruCache;
            synchronized (map) {
                this.lruCache.values().removeIf(v -> null == v.get());
            }
        });
    }

    public long incrementFallbackCount() {
        return this.fallbackCount.incrementAndGet();
    }

    public void resetFallbackCount() {
        this.fallbackCount.set(0L);
    }

    public MethodHandle getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(MethodHandle defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public MethodHandle getFallbackTarget() {
        return this.fallbackTarget;
    }

    public void setFallbackTarget(MethodHandle fallbackTarget) {
        this.fallbackTarget = fallbackTarget;
    }

    public MethodHandles.Lookup getLookup() {
        return this.lookup;
    }

    static {
        Thread cacheCleaner = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        CACHE_CLEANER_QUEUE.take().run();
                    }
                }
                catch (Throwable ignore) {
                    Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest(DefaultGroovyMethods.asString(ignore));
                    continue;
                }
                break;
            }
        }, "PIC-Cleaner");
        cacheCleaner.setDaemon(true);
        cacheCleaner.start();
    }
}

