/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;

public final class InstanceCreator {
    private static final String CANNOT_INSTANTIATE_CLASS = "Cannot instantiate class ";

    private InstanceCreator() {
    }

    public static <T> T newInstance(String className, Object ... parameters) {
        Class<?> clazz = ClassHelper.forName(className);
        Objects.requireNonNull(clazz, "Could not find a valid class");
        return (T)InstanceCreator.newInstance(clazz, parameters);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e.getCause());
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + constructor.getDeclaringClass().getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> cls, Object ... parameters) {
        Constructor<?> ctor = null;
        for (Constructor<?> c : cls.getConstructors()) {
            if (c.getParameterTypes().length != parameters.length) continue;
            ctor = c;
            break;
        }
        if (ctor == null) {
            throw new TestNGException("Couldn't find a constructor in " + cls);
        }
        return InstanceCreator.newInstance(ctor, parameters);
    }
}

