/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.List;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.classgen.asm.MopWriter;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class MethodCallExpressionTransformer {
    private static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    private final StaticCompilationTransformer staticCompilationTransformer;

    public MethodCallExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    Expression transformMethodCallExpression(MethodCallExpression expr) {
        Optional<FieldNode> field;
        Expression trn = MethodCallExpressionTransformer.tryTransformIsToCompareIdentity(expr);
        if (trn != null) {
            return trn;
        }
        Object superCallReceiver = expr.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED);
        if (superCallReceiver instanceof ClassNode) {
            return this.transformMethodCallExpression(MethodCallExpressionTransformer.transformToMopSuperCall((ClassNode)superCallReceiver, expr));
        }
        if (MethodCallExpressionTransformer.isCallOnClosure(expr) && (field = Optional.ofNullable(this.staticCompilationTransformer.getClassNode()).map(cn -> cn.getField(expr.getMethodAsString()))).isPresent()) {
            MethodCallExpression result = new MethodCallExpression((Expression)new VariableExpression(field.get()), "call", this.staticCompilationTransformer.transform(expr.getArguments()));
            result.setImplicitThis(false);
            result.setSourcePosition(expr);
            result.setSafe(expr.isSafe());
            result.setSpreadSafe(expr.isSpreadSafe());
            result.setMethodTarget(StaticTypeCheckingVisitor.CLOSURE_CALL_VARGS);
            result.copyNodeMetaData(expr);
            return result;
        }
        return this.staticCompilationTransformer.superTransform(expr);
    }

    private static MethodCallExpression transformToMopSuperCall(ClassNode superCallReceiver, MethodCallExpression expr) {
        MethodNode mn = (MethodNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        String mopName = MopWriter.getMopMethodName(mn, false);
        MethodNode direct = new MethodNode(mopName, 4097, mn.getReturnType(), mn.getParameters(), mn.getExceptions(), EmptyStatement.INSTANCE);
        direct.setDeclaringClass(superCallReceiver);
        MethodCallExpression result = new MethodCallExpression((Expression)new VariableExpression("this"), mopName, expr.getArguments());
        result.setImplicitThis(true);
        result.setSpreadSafe(false);
        result.setSafe(false);
        result.setSourcePosition(expr);
        result.setMethodTarget(direct);
        return result;
    }

    private static boolean isCallOnClosure(MethodCallExpression expr) {
        MethodNode target = (MethodNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        return expr.isImplicitThis() && !"call".equals(expr.getMethodAsString()) && (target == StaticTypeCheckingVisitor.CLOSURE_CALL_VARGS || target == StaticTypeCheckingVisitor.CLOSURE_CALL_NO_ARG || target == StaticTypeCheckingVisitor.CLOSURE_CALL_ONE_ARG);
    }

    private static Expression tryTransformIsToCompareIdentity(MethodCallExpression call) {
        ArgumentListExpression arguments;
        List<Expression> exprs;
        Expression args;
        ClassNode owner;
        if (call.isSafe()) {
            return null;
        }
        MethodNode methodTarget = call.getMethodTarget();
        if (methodTarget instanceof ExtensionMethodNode && "is".equals(methodTarget.getName()) && methodTarget.getParameters().length == 1 && DGM_CLASSNODE.equals(owner = (methodTarget = ((ExtensionMethodNode)methodTarget).getExtensionMethodNode()).getDeclaringClass()) && (args = call.getArguments()) instanceof ArgumentListExpression && (exprs = (arguments = (ArgumentListExpression)args).getExpressions()).size() == 1) {
            CompareIdentityExpression cid = new CompareIdentityExpression(call.getObjectExpression(), exprs.get(0));
            cid.setSourcePosition(call);
            return cid;
        }
        return null;
    }
}

