/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;

public class LoggableTextifier
extends Textifier {
    private final CompilerConfiguration compilerConfiguration;
    private final PrintWriter out;
    private int lineCount;

    public LoggableTextifier() {
        this(CompilerConfiguration.DEFAULT);
    }

    public LoggableTextifier(CompilerConfiguration compilerConfiguration) {
        super(589824);
        this.compilerConfiguration = compilerConfiguration;
        this.out = Optional.ofNullable(compilerConfiguration.getOutput()).orElseGet(() -> new PrintWriter(System.out, true));
    }

    protected Textifier createTextifier() {
        return new LoggableTextifier(this.compilerConfiguration);
    }

    protected void log() {
        int textSize = this.text.size();
        ArrayList bcList = new ArrayList();
        for (int i = this.lineCount; i < textSize; ++i) {
            Object bc = this.text.get(i);
            if (bc instanceof List && ((List)bc).isEmpty()) continue;
            bcList.add(bc);
        }
        if (!bcList.isEmpty()) {
            this.out.print(this.getInvocationPositionInfo());
            for (Object bc : bcList) {
                this.out.print(bc);
            }
        }
        this.lineCount = textSize;
    }

    private String getInvocationPositionInfo() {
        int maxDepth = this.compilerConfiguration.getLogClassgenStackTraceMaxDepth();
        return maxDepth <= 0 ? "" : Arrays.stream(new Throwable().getStackTrace()).filter(stackTraceElement -> stackTraceElement.getClassName().contains(".groovy.") && !stackTraceElement.getClassName().endsWith(".LoggableTextifier")).map(stackTraceElement -> String.format("%30s// %s#%s:%s%n", "", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber())).limit(maxDepth).collect(Collectors.joining());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.log();
    }

    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        this.log();
    }

    public Printer visitModule(String name, int access, String version) {
        Printer p = super.visitModule(name, access, version);
        this.log();
        return p;
    }

    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
        this.log();
    }

    public Textifier visitClassAnnotation(String desc, boolean visible) {
        Textifier t = super.visitClassAnnotation(desc, visible);
        this.log();
        return t;
    }

    public Printer visitClassTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer t = super.visitClassTypeAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public void visitClassAttribute(Attribute attr) {
        super.visitClassAttribute(attr);
        this.log();
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        this.log();
    }

    public Textifier visitField(int access, String name, String desc, String signature, Object value) {
        Textifier t = super.visitField(access, name, desc, signature, value);
        this.log();
        return t;
    }

    public Textifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Textifier t = super.visitMethod(access, name, desc, signature, exceptions);
        this.log();
        return t;
    }

    public void visitClassEnd() {
        super.visitClassEnd();
        this.log();
    }

    public void visitRequire(String require, int access, String version) {
        super.visitRequire(require, access, version);
        this.log();
    }

    public void visitExport(String export, int access, String ... modules) {
        super.visitExport(export, access, modules);
        this.log();
    }

    public void visitUse(String use) {
        super.visitUse(use);
        this.log();
    }

    public void visitProvide(String provide, String ... providers) {
        super.visitProvide(provide, providers);
        this.log();
    }

    public void visitModuleEnd() {
        super.visitModuleEnd();
        this.log();
    }

    public void visit(String name, Object value) {
        super.visit(name, value);
        this.log();
    }

    public void visitEnum(String name, String desc, String value) {
        super.visitEnum(name, desc, value);
        this.log();
    }

    public Textifier visitAnnotation(String name, String desc) {
        Textifier t = super.visitAnnotation(name, desc);
        this.log();
        return t;
    }

    public Textifier visitArray(String name) {
        Textifier t = super.visitArray(name);
        this.log();
        return t;
    }

    public void visitAnnotationEnd() {
        super.visitAnnotationEnd();
        this.log();
    }

    public Textifier visitFieldAnnotation(String desc, boolean visible) {
        Textifier t = super.visitFieldAnnotation(desc, visible);
        this.log();
        return t;
    }

    public Printer visitFieldTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer t = super.visitFieldTypeAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public void visitFieldAttribute(Attribute attr) {
        super.visitFieldAttribute(attr);
        this.log();
    }

    public void visitFieldEnd() {
        super.visitFieldEnd();
        this.log();
    }

    public void visitParameter(String name, int access) {
        super.visitParameter(name, access);
        this.log();
    }

    public Textifier visitAnnotationDefault() {
        Textifier t = super.visitAnnotationDefault();
        this.log();
        return t;
    }

    public Textifier visitMethodAnnotation(String desc, boolean visible) {
        Textifier t = super.visitMethodAnnotation(desc, visible);
        this.log();
        return t;
    }

    public Printer visitMethodTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer t = super.visitMethodTypeAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public Textifier visitParameterAnnotation(int parameter, String desc, boolean visible) {
        Textifier t = super.visitParameterAnnotation(parameter, desc, visible);
        this.log();
        return t;
    }

    public void visitMethodAttribute(Attribute attr) {
        super.visitMethodAttribute(attr);
        this.log();
    }

    public void visitCode() {
        super.visitCode();
        this.log();
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super.visitFrame(type, nLocal, local, nStack, stack);
        this.log();
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.log();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.log();
    }

    public void visitVarInsn(int opcode, int varIndex) {
        super.visitVarInsn(opcode, varIndex);
        this.log();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.log();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        this.log();
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        this.log();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.log();
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.log();
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.log();
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.log();
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.log();
    }

    public void visitIincInsn(int varIndex, int increment) {
        super.visitIincInsn(varIndex, increment);
        this.log();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.log();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.log();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.log();
    }

    public Printer visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer t = super.visitInsnAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        this.log();
    }

    public Printer visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer t = super.visitTryCatchAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        this.log();
    }

    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        Printer t = super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
        this.log();
        return t;
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.log();
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
        this.log();
    }

    public void visitMethodEnd() {
        super.visitMethodEnd();
        this.log();
    }

    public Textifier visitAnnotation(String desc, boolean visible) {
        Textifier t = super.visitAnnotation(desc, visible);
        this.log();
        return t;
    }

    public Textifier visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Textifier t = super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        this.log();
        return t;
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        this.log();
    }

    public void visitNestHost(String nestHost) {
        super.visitNestHost(nestHost);
        this.log();
    }

    public void visitNestMember(String nestMember) {
        super.visitNestMember(nestMember);
        this.log();
    }

    public void visitMainClass(String mainClass) {
        super.visitMainClass(mainClass);
        this.log();
    }

    public void visitPackage(String packaze) {
        super.visitPackage(packaze);
        this.log();
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        super.visitOpen(packaze, access, modules);
        this.log();
    }

    public Textifier visitAnnotableParameterCount(int parameterCount, boolean visible) {
        Textifier t = super.visitAnnotableParameterCount(parameterCount, visible);
        this.log();
        return t;
    }

    public Printer visitRecordComponent(String name, String descriptor, String signature) {
        Printer p = super.visitRecordComponent(name, descriptor, signature);
        this.log();
        return p;
    }

    public Textifier visitRecordComponentAnnotation(String descriptor, boolean visible) {
        Textifier t = super.visitRecordComponentAnnotation(descriptor, visible);
        this.log();
        return t;
    }

    public Printer visitRecordComponentTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        Printer p = super.visitRecordComponentTypeAnnotation(typeRef, typePath, descriptor, visible);
        this.log();
        return p;
    }

    public void visitRecordComponentAttribute(Attribute attribute) {
        super.visitRecordComponentAttribute(attribute);
        this.log();
    }

    public void visitRecordComponentEnd() {
        super.visitRecordComponentEnd();
        this.log();
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        super.visitPermittedSubclass(permittedSubclass);
        this.log();
    }
}

