/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.groovy.test;

import junit.framework.Test;
import junit.framework.TestResult;
import org.codehaus.groovy.runtime.InvokerHelper;

/**
 * An adapter to make any Groovy Script class an instance of a JUnit Test
 */
public class ScriptTestAdapter implements Test {
    private Class scriptClass;
    private String[] arguments;

    public ScriptTestAdapter(Class scriptClass, String[] arguments) {
        this.scriptClass = scriptClass;
        this.arguments = arguments;
    }

    @Override
    public int countTestCases() {
        return 1;
    }

    @Override
    public void run(TestResult result) {
        try {
            result.startTest(this);

            // let's run the script
            InvokerHelper.runScript(scriptClass, arguments);
            result.endTest(this);
        } catch (Exception e) {
            result.addError(this, e);
        }
    }

    @Override
    public String toString() {
        return "TestCase for script: " + scriptClass.getName();
    }
}
