/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.groovy.contracts.ViolationTracker;
import org.apache.groovy.contracts.generation.ContractExecutionTracker;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.contracts.util.ExpressionUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.Token;

public abstract class BaseGenerator {
    public static final String INVARIANT_CLOSURE_PREFIX = "invariant";
    public static final String META_DATA_USE_INLINE_MODE = "org.apache.groovy.contracts.USE_INLINE_MODE";
    protected final ReaderSource source;

    public BaseGenerator(ReaderSource source) {
        this.source = source;
    }

    public static String getInvariantMethodName(ClassNode classNode) {
        return "invariant_" + classNode.getName().replaceAll("\\.", "_");
    }

    public static MethodNode getInvariantMethodNode(ClassNode classNode) {
        return classNode.getDeclaredMethod(BaseGenerator.getInvariantMethodName(classNode), Parameter.EMPTY_ARRAY);
    }

    protected BlockStatement getInlineModeBlockStatement(BlockStatement blockStatement) {
        BooleanExpression combinedBooleanExpression = ExpressionUtils.getBooleanExpression(ExpressionUtils.getBooleanExpressionsFromAssertionStatements(blockStatement));
        return GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.varX((String)"$GCONTRACTS_ENABLED", (ClassNode)ClassHelper.boolean_TYPE)), (Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.notX((Expression)combinedBooleanExpression), (Statement)blockStatement)}))});
    }

    protected BlockStatement wrapAssertionBooleanExpression(ClassNode type, MethodNode methodNode, BooleanExpression classInvariantExpression, String assertionType) {
        ClassNode violationTrackerClassNode = ClassHelper.makeWithoutCaching(ViolationTracker.class);
        VariableExpression $_gc_result = GeneralUtils.varX((String)"$_gc_result", (ClassNode)ClassHelper.boolean_TYPE);
        $_gc_result.setAccessedVariable((Variable)$_gc_result);
        BlockStatement ifBlockStatement = GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.declS((Expression)$_gc_result, (Expression)ConstantExpression.FALSE), GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"init")), GeneralUtils.assignS((Expression)$_gc_result, (Expression)classInvariantExpression), GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.notX((Expression)GeneralUtils.callX((Expression)$_gc_result, (String)"booleanValue"))), (Statement)GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"violationsOccurred")), (Statement)GeneralUtils.tryCatchS((Statement)GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"rethrowFirst")), (Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)violationTrackerClassNode), (String)"deinit"))}))))});
        TryCatchStatement lockTryCatchStatement = GeneralUtils.tryCatchS((Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)ClassHelper.make(ContractExecutionTracker.class)), (String)"track", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)type.getName()), GeneralUtils.constX((Object)methodNode.getTypeDescriptor()), GeneralUtils.constX((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE}))), (Statement)ifBlockStatement)}), (Statement)GeneralUtils.block((VariableScope)new VariableScope(), (Statement[])new Statement[]{GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)ClassHelper.make(ContractExecutionTracker.class)), (String)"clear", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)type.getName()), GeneralUtils.constX((Object)methodNode.getTypeDescriptor()), GeneralUtils.constX((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE})))}));
        return GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.ifS((Expression)GeneralUtils.boolX((Expression)GeneralUtils.varX((String)"$GCONTRACTS_ENABLED", (ClassNode)ClassHelper.boolean_TYPE)), (Statement)lockTryCatchStatement)});
    }

    protected BooleanExpression addCallsToSuperMethodNodeAnnotationClosure(ClassNode type, MethodNode methodNode, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression, boolean isPostcondition) {
        List<AnnotationNode> nextContractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(annotationType));
        if (nextContractElementAnnotations.isEmpty()) {
            if (methodNode.getNodeMetaData((Object)META_DATA_USE_INLINE_MODE) == null) {
                methodNode.setNodeMetaData((Object)META_DATA_USE_INLINE_MODE, (Object)Boolean.TRUE);
            }
            return booleanExpression;
        }
        for (AnnotationNode nextContractElementAnnotation : nextContractElementAnnotations) {
            ClassExpression classExpression = (ClassExpression)nextContractElementAnnotation.getMember("value");
            if (classExpression == null) continue;
            ArgumentListExpression callArgumentList = new ArgumentListExpression();
            for (Parameter parameter : methodNode.getParameters()) {
                callArgumentList.addExpression((Expression)GeneralUtils.varX((Variable)parameter));
            }
            if (isPostcondition && !ClassHelper.isPrimitiveVoid((ClassNode)methodNode.getReturnType()) && !(methodNode instanceof ConstructorNode)) {
                callArgumentList.addExpression((Expression)GeneralUtils.localVarX((String)"result", (ClassNode)methodNode.getReturnType()));
            }
            if (isPostcondition && !(methodNode instanceof ConstructorNode)) {
                callArgumentList.addExpression((Expression)GeneralUtils.localVarX((String)"old", (ClassNode)new ClassNode(Map.class)));
            }
            ArgumentListExpression newInstanceArguments = GeneralUtils.args((Expression[])new Expression[]{classExpression, new ArrayExpression(ClassHelper.DYNAMIC_TYPE, Arrays.asList(VariableExpression.THIS_EXPRESSION, VariableExpression.THIS_EXPRESSION))});
            MethodCallExpression doCall = GeneralUtils.callX((Expression)GeneralUtils.callX((ClassNode)ClassHelper.makeWithoutCaching(InvokerHelper.class), (String)"invokeConstructorOf", (Expression)newInstanceArguments), (String)"doCall", (Expression)callArgumentList);
            doCall.setMethodTarget((MethodNode)classExpression.getType().getMethods("doCall").get(0));
            booleanExpression.setSourcePosition((ASTNode)nextContractElementAnnotation);
            booleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.binX((Expression)booleanExpression, (Token)(isPostcondition ? Token.newSymbol((int)164, (int)-1, (int)-1) : Token.newSymbol((int)162, (int)-1, (int)-1)), (Expression)GeneralUtils.boolX((Expression)doCall)));
        }
        return booleanExpression;
    }
}

