/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.tailrec;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.tailrec.AstHelper;
import org.codehaus.groovy.transform.tailrec.UsedVariableTracker;
import org.codehaus.groovy.transform.tailrec.VariableAccessReplacer;

public class ReturnStatementToIterationConverter {
    private Statement recurStatement = AstHelper.recurStatement();

    public ReturnStatementToIterationConverter() {
    }

    public ReturnStatementToIterationConverter(Statement recurStatement) {
        this.recurStatement = recurStatement;
    }

    public Statement convert(ReturnStatement statement, final Map<Integer, Map> positionMapping) {
        Expression recursiveCall = statement.getExpression();
        if (!this.isAMethodCalls(recursiveCall)) {
            return statement;
        }
        final LinkedHashMap<String, Map> tempMapping = new LinkedHashMap<String, Map>();
        final LinkedHashMap tempDeclarations = new LinkedHashMap();
        final ArrayList<ExpressionStatement> argAssignments = new ArrayList<ExpressionStatement>();
        final BlockStatement result = new BlockStatement();
        result.copyStatementLabels(statement);
        DefaultGroovyMethods.eachWithIndex(this.getArguments(recursiveCall), (Closure)new Closure<Void>((Object)this, (Object)this){

            public void doCall(Expression expression, int index) {
                ExpressionStatement tempDeclaration = ReturnStatementToIterationConverter.this.createTempDeclaration(index, positionMapping, tempMapping, tempDeclarations);
                result.addStatement(tempDeclaration);
            }
        });
        DefaultGroovyMethods.eachWithIndex(this.getArguments(recursiveCall), (Closure)new Closure<Void>((Object)this, (Object)this){

            public void doCall(Expression expression, int index) {
                ExpressionStatement argAssignment = ReturnStatementToIterationConverter.this.createAssignmentToIterationVariable(expression, index, positionMapping);
                argAssignments.add(argAssignment);
                result.addStatement(argAssignment);
            }
        });
        Set<String> unusedTemps = this.replaceAllArgUsages(argAssignments, tempMapping);
        for (String temp : unusedTemps) {
            result.getStatements().remove(tempDeclarations.get(temp));
        }
        result.addStatement(this.recurStatement);
        return result;
    }

    private ExpressionStatement createAssignmentToIterationVariable(Expression expression, int index, Map<Integer, Map> positionMapping) {
        String argName = (String)positionMapping.get(index).get("name");
        ClassNode argAndTempType = DefaultGroovyMethods.asType(positionMapping.get(index).get("type"), ClassNode.class);
        ExpressionStatement argAssignment = (ExpressionStatement)GeneralUtils.assignS(GeneralUtils.varX(argName, argAndTempType), expression);
        return argAssignment;
    }

    private ExpressionStatement createTempDeclaration(int index, Map<Integer, Map> positionMapping, Map<String, Map> tempMapping, Map<String, ExpressionStatement> tempDeclarations) {
        String argName = (String)positionMapping.get(index).get("name");
        String tempName = "_" + argName + "_";
        ClassNode argAndTempType = DefaultGroovyMethods.asType(positionMapping.get(index).get("type"), ClassNode.class);
        ExpressionStatement tempDeclaration = AstHelper.createVariableAlias(tempName, argAndTempType, argName);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("name", tempName);
        map.put("type", argAndTempType);
        tempMapping.put(argName, map);
        tempDeclarations.put(tempName, tempDeclaration);
        return tempDeclaration;
    }

    private List<Expression> getArguments(Expression recursiveCall) {
        if (recursiveCall instanceof MethodCallExpression) {
            return ((TupleExpression)((MethodCallExpression)recursiveCall).getArguments()).getExpressions();
        }
        if (recursiveCall instanceof StaticMethodCallExpression) {
            return ((TupleExpression)((StaticMethodCallExpression)recursiveCall).getArguments()).getExpressions();
        }
        return null;
    }

    private boolean isAMethodCalls(Expression expression) {
        Class<?> clazz = expression.getClass();
        return MethodCallExpression.class == clazz || StaticMethodCallExpression.class == clazz;
    }

    private Set<String> replaceAllArgUsages(List<ExpressionStatement> iterationVariablesAssignmentNodes, Map<String, Map> tempMapping) {
        Set<String> unusedTempNames = DefaultGroovyMethods.asType(DefaultGroovyMethods.collect(tempMapping.values(), new Closure<String>((Object)this, (Object)this){

            public String doCall(Map nameAndType) {
                return (String)nameAndType.get("name");
            }
        }), Set.class);
        UsedVariableTracker tracker = new UsedVariableTracker();
        for (ExpressionStatement statement : iterationVariablesAssignmentNodes) {
            this.replaceArgUsageByTempUsage((BinaryExpression)statement.getExpression(), tempMapping, tracker);
        }
        unusedTempNames = DefaultGroovyMethods.minus(unusedTempNames, tracker.getUsedVariableNames());
        return unusedTempNames;
    }

    private void replaceArgUsageByTempUsage(BinaryExpression binary, Map tempMapping, UsedVariableTracker tracker) {
        VariableAccessReplacer replacer = new VariableAccessReplacer(tempMapping, tracker);
        replacer.replaceIn(binary);
    }

    public Statement getRecurStatement() {
        return this.recurStatement;
    }

    public void setRecurStatement(Statement recurStatement) {
        this.recurStatement = recurStatement;
    }
}

