/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private MethodNode currentMethod;
    private SourceUnit sourceUnit;
    private boolean inSpecialConstructorCall;
    private boolean inClosure;
    private boolean inPropertyExpression;
    private Expression foundConstant;
    private Expression foundArgs;
    private boolean inAnnotation;
    private boolean inLeftExpression;

    public void visitClass(ClassNode classNode, SourceUnit sourceUnit) {
        this.currentClass = classNode;
        this.sourceUnit = sourceUnit;
        this.visitClass(classNode);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = null;
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        boolean oldInAnnotation = this.inAnnotation;
        this.inAnnotation = true;
        super.visitAnnotations(node);
        this.inAnnotation = oldInAnnotation;
    }

    @Override
    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        Class<?> clazz = exp.getClass();
        if (clazz == VariableExpression.class) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (clazz == BinaryExpression.class) {
            return this.transformBinaryExpression((BinaryExpression)exp);
        }
        if (clazz == PropertyExpression.class) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (clazz == MethodCallExpression.class) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        if (clazz == ClosureExpression.class) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (clazz == ConstructorCallExpression.class) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        if (clazz == ArgumentListExpression.class) {
            Expression result = exp.transformExpression(this);
            if (this.foundArgs == null && this.inPropertyExpression) {
                this.foundArgs = result;
            }
            return result;
        }
        if (exp instanceof ConstantExpression) {
            ConstantExpression ce;
            Expression result = exp.transformExpression(this);
            if (this.foundConstant == null && this.inPropertyExpression) {
                this.foundConstant = result;
            }
            if (this.inAnnotation && exp instanceof AnnotationConstantExpression && (ce = (ConstantExpression)result).getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                Map<String, Expression> attributes = an.getMembers();
                for (Map.Entry<String, Expression> entry : attributes.entrySet()) {
                    Expression attrExpr = this.transform(entry.getValue());
                    entry.setValue(attrExpr);
                }
            }
            return result;
        }
        return exp.transformExpression(this);
    }

    private Expression transformMapEntryExpression(MapEntryExpression me, ClassNode constructorCallType) {
        ImportNode importNode;
        Map<String, ImportNode> importNodes;
        Expression key = me.getKeyExpression();
        Expression value = me.getValueExpression();
        ModuleNode module = this.currentClass.getModule();
        if (module != null && key instanceof ConstantExpression && (importNodes = module.getStaticImports()).containsKey(key.getText()) && (importNode = importNodes.get(key.getText())).getType().equals(constructorCallType)) {
            String newKey = importNode.getFieldName();
            return new MapEntryExpression(new ConstantExpression(newKey), value.transformExpression(this));
        }
        return me;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left;
        int type = be.getOperation().getType();
        Expression right = this.transform(be.getRightExpression());
        be.setRightExpression(right);
        if (type == 100 && be.getLeftExpression() instanceof VariableExpression) {
            boolean oldInLeftExpression = this.inLeftExpression;
            this.inLeftExpression = true;
            left = this.transform(be.getLeftExpression());
            this.inLeftExpression = oldInLeftExpression;
            if (left instanceof StaticMethodCallExpression) {
                StaticMethodCallExpression smce = (StaticMethodCallExpression)left;
                StaticMethodCallExpression result = new StaticMethodCallExpression(smce.getOwnerType(), smce.getMethod(), right);
                result.copyNodeMetaData(smce);
                StaticImportVisitor.setSourcePosition(result, be);
                return result;
            }
        } else {
            left = this.transform(be.getLeftExpression());
        }
        be.setLeftExpression(left);
        return be;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            Expression result = this.findStaticFieldOrPropAccessorImportFromModule(v.getName());
            if (result != null) {
                StaticImportVisitor.setSourcePosition(result, ve);
                if (this.inAnnotation) {
                    result = ExpressionUtils.transformInlineConstants(result);
                }
                return result;
            }
        } else if (v instanceof FieldNode && this.inSpecialConstructorCall) {
            FieldNode fn = (FieldNode)v;
            ClassNode declaringClass = fn.getDeclaringClass();
            if (fn.isStatic() && this.currentClass.isDerivedFrom(declaringClass)) {
                PropertyExpression result = new PropertyExpression((Expression)new ClassExpression(declaringClass), v.getName());
                StaticImportVisitor.setSourcePosition(result, ve);
                return result;
            }
        }
        return ve;
    }

    private static void setSourcePosition(Expression toSet, Expression origNode) {
        toSet.setSourcePosition(origNode);
        if (toSet instanceof PropertyExpression) {
            ((PropertyExpression)toSet).getProperty().setSourcePosition(origNode);
        }
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression result;
        boolean staticWrtCurrent;
        Expression object = this.transform(mce.getObjectExpression());
        Expression method = this.transform(mce.getMethod());
        Expression args = this.transform(mce.getArguments());
        boolean bl = staticWrtCurrent = this.inSpecialConstructorCall || this.currentMethod != null && this.currentMethod.isStatic();
        if (mce.isImplicitThis()) {
            boolean thisOrSuperMethod;
            String name = mce.getMethodAsString();
            boolean bl2 = staticWrtCurrent ? ClassNodeUtils.hasPossibleStaticMethod(this.currentClass, name, args, true) : (thisOrSuperMethod = this.currentClass.tryFindPossibleMethod(name, args) != null);
            if (!thisOrSuperMethod && !StaticImportVisitor.hasPossibleOuterMethod(this.currentClass, name, args)) {
                result = this.findStaticMethodImportFromModule(method, args);
                if (result != null) {
                    result.setSourcePosition(mce);
                    return result;
                }
                if (name != null && !this.inLeftExpression && (result = this.findStaticFieldOrPropAccessorImportFromModule(name)) != null) {
                    StaticImportVisitor.setSourcePosition(result, method);
                    result = new MethodCallExpression(result, "call", args);
                    ((MethodCallExpression)result).setImplicitThis(false);
                    result.setSourcePosition(mce);
                    return result;
                }
            }
        } else if (staticWrtCurrent && ExpressionUtils.isSuperExpression(object)) {
            MethodCallExpression result2 = new MethodCallExpression((Expression)new ClassExpression(this.currentClass.getSuperClass()), method, args);
            ((ASTNode)result2).setSourcePosition(mce);
            return result2;
        }
        if (method instanceof ConstantExpression && ((ConstantExpression)method).getValue() instanceof String && (mce.isImplicitThis() || ExpressionUtils.isThisOrSuper(object))) {
            boolean foundInstanceMethod;
            String methodName = (String)((ConstantExpression)method).getValue();
            boolean bl3 = foundInstanceMethod = !staticWrtCurrent && this.currentClass.hasPossibleMethod(methodName, args);
            if (mce.isImplicitThis()) {
                if (ClassNodeUtils.isInnerClass(this.currentClass)) {
                    if (this.inSpecialConstructorCall && !foundInstanceMethod) {
                        if (this.currentClass.getOuterClass().hasPossibleMethod(methodName, args)) {
                            object = new PropertyExpression((Expression)new ClassExpression(this.currentClass.getOuterClass()), new ConstantExpression("this"));
                        } else if (StaticImportVisitor.hasPossibleStaticMember(this.currentClass.getOuterClass(), methodName, args)) {
                            result = new StaticMethodCallExpression(this.currentClass.getOuterClass(), methodName, args);
                            result.setSourcePosition(mce);
                            return result;
                        }
                    }
                } else if ((this.inSpecialConstructorCall || !this.inClosure && !foundInstanceMethod && !methodName.equals("call")) && StaticImportVisitor.hasPossibleStaticMember(this.currentClass, methodName, args)) {
                    result = new StaticMethodCallExpression(this.currentClass, methodName, args);
                    result.setSourcePosition(mce);
                    return result;
                }
            }
        }
        MethodCallExpression result3 = new MethodCallExpression(object, method, args);
        result3.setGenericsTypes(mce.getGenericsTypes());
        result3.setMethodTarget(mce.getMethodTarget());
        result3.setImplicitThis(mce.isImplicitThis());
        result3.setSpreadSafe(mce.isSpreadSafe());
        result3.setSafe(mce.isSafe());
        result3.setSourcePosition(mce);
        return result3;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        TupleExpression tuple;
        this.inSpecialConstructorCall = cce.isSpecialCall();
        Expression expression = cce.getArguments();
        if (expression instanceof TupleExpression && (tuple = (TupleExpression)expression).getExpressions().size() == 1 && (expression = tuple.getExpression(0)) instanceof NamedArgumentListExpression) {
            NamedArgumentListExpression namedArgs = (NamedArgumentListExpression)expression;
            List<MapEntryExpression> entryExpressions = namedArgs.getMapEntryExpressions();
            for (int i = 0; i < entryExpressions.size(); ++i) {
                entryExpressions.set(i, (MapEntryExpression)this.transformMapEntryExpression(entryExpressions.get(i), cce.getType()));
            }
        }
        Expression ret = cce.transformExpression(this);
        this.inSpecialConstructorCall = false;
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        for (Parameter p : ClosureUtils.getParametersSafe(ce)) {
            if (!p.hasInitialExpression()) continue;
            p.setInitialExpression(this.transform(p.getInitialExpression()));
        }
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression result;
        if (this.currentMethod != null && this.currentMethod.isStatic() && ExpressionUtils.isSuperExpression(pe.getObjectExpression())) {
            PropertyExpression pexp = new PropertyExpression((Expression)new ClassExpression(this.currentClass.getUnresolvedSuperClass()), this.transform(pe.getProperty()));
            pexp.setSourcePosition(pe);
            return pexp;
        }
        boolean oldInPropertyExpression = this.inPropertyExpression;
        Expression oldFoundConstant = this.foundConstant;
        Expression oldFoundArgs = this.foundArgs;
        this.inPropertyExpression = true;
        this.foundConstant = null;
        this.foundArgs = null;
        Expression objectExpression = this.transform(pe.getObjectExpression());
        if (this.foundArgs != null && this.foundConstant != null && !this.foundConstant.getText().trim().isEmpty() && objectExpression instanceof MethodCallExpression && ((MethodCallExpression)objectExpression).isImplicitThis() && (result = this.findStaticMethodImportFromModule(this.foundConstant, this.foundArgs)) != null) {
            objectExpression = result;
            objectExpression.setSourcePosition(pe);
        }
        this.inPropertyExpression = oldInPropertyExpression;
        this.foundConstant = oldFoundConstant;
        this.foundArgs = oldFoundArgs;
        pe.setObjectExpression(objectExpression);
        return pe;
    }

    private Expression findStaticFieldOrPropAccessorImportFromModule(String name) {
        Expression expression;
        String accessorName;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return null;
        }
        Map<String, ImportNode> importNodes = module.getStaticImports();
        if (importNodes.containsKey(accessorName = this.getAccessorName(name)) && (expression = this.findStaticProperty(importNodes, accessorName)) != null) {
            return expression;
        }
        if (accessorName.startsWith("get") && importNodes.containsKey(accessorName = "is" + accessorName.substring(3)) && (expression = this.findStaticProperty(importNodes, accessorName)) != null) {
            return expression;
        }
        if (importNodes.containsKey(name)) {
            ImportNode importNode = importNodes.get(name);
            expression = this.findStaticPropertyAccessor(importNode.getType(), importNode.getFieldName());
            if (expression != null) {
                return expression;
            }
            expression = StaticImportVisitor.findStaticField(importNode.getType(), importNode.getFieldName());
            if (expression != null) {
                return expression;
            }
        }
        for (ImportNode importNode : module.getStaticStarImports().values()) {
            ClassNode node = importNode.getType();
            expression = this.findStaticPropertyAccessor(node, name);
            if (expression != null) {
                return expression;
            }
            expression = StaticImportVisitor.findStaticField(node, name);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    private Expression findStaticProperty(Map<String, ImportNode> importNodes, String accessorName) {
        String importMember;
        Expression result = null;
        ImportNode importNode = importNodes.get(accessorName);
        ClassNode importClass = importNode.getType();
        result = this.findStaticPropertyAccessorByFullName(importClass, importMember = importNode.getFieldName());
        if (result == null) {
            result = this.findStaticPropertyAccessor(importClass, ClassNodeUtils.getPropNameForAccessor(importMember));
        }
        return result;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args) {
        ClassNode starImportType;
        String propName;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map<String, ImportNode> importNodes = module.getStaticImports();
        ConstantExpression ce = (ConstantExpression)method;
        Object value = ce.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String name = (String)value;
        if (importNodes.containsKey(name)) {
            ImportNode importNode = importNodes.get(name);
            expression = StaticImportVisitor.findStaticMethod(importNode.getType(), importNode.getFieldName(), args);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessorGivenArgs(importNode.getType(), ClassNodeUtils.getPropNameForAccessor(importNode.getFieldName()), args);
            if (expression != null) {
                return StaticImportVisitor.newStaticMethodCallX(importNode.getType(), importNode.getFieldName(), args);
            }
        }
        if (ClassNodeUtils.isValidAccessorName(name) && importNodes.containsKey(propName = ClassNodeUtils.getPropNameForAccessor(name))) {
            ImportNode importNode = importNodes.get(propName);
            ClassNode importClass = importNode.getType();
            String importMember = importNode.getFieldName();
            expression = StaticImportVisitor.findStaticMethod(importClass, StaticImportVisitor.prefix(name) + MetaClassHelper.capitalize(importMember), args);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessorGivenArgs(importClass, importMember, args);
            if (expression != null) {
                return StaticImportVisitor.newStaticMethodCallX(importClass, StaticImportVisitor.prefix(name) + MetaClassHelper.capitalize(importMember), args);
            }
        }
        Map<String, ImportNode> starImports = module.getStaticStarImports();
        if (this.currentClass.isEnum() && starImports.containsKey(this.currentClass.getName())) {
            ImportNode importNode = starImports.get(this.currentClass.getName());
            starImportType = importNode == null ? null : importNode.getType();
            expression = StaticImportVisitor.findStaticMethod(starImportType, name, args);
            return expression;
        }
        for (ImportNode importNode : starImports.values()) {
            starImportType = importNode == null ? null : importNode.getType();
            expression = StaticImportVisitor.findStaticMethod(starImportType, name, args);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessorGivenArgs(starImportType, ClassNodeUtils.getPropNameForAccessor(name), args);
            if (expression == null) continue;
            return StaticImportVisitor.newStaticMethodCallX(starImportType, name, args);
        }
        return null;
    }

    private static String prefix(String name) {
        return name.startsWith("is") ? "is" : name.substring(0, 3);
    }

    private String getAccessorName(String name) {
        return (this.inLeftExpression ? "set" : "get") + MetaClassHelper.capitalize(name);
    }

    private Expression findStaticPropertyAccessorGivenArgs(ClassNode staticImportType, String propName, Expression args) {
        return this.findStaticPropertyAccessor(staticImportType, propName);
    }

    private Expression findStaticPropertyAccessor(ClassNode staticImportType, String propName) {
        String accessorName = this.getAccessorName(propName);
        Expression accessor = this.findStaticPropertyAccessorByFullName(staticImportType, accessorName);
        if (accessor == null && accessorName.startsWith("get")) {
            accessor = this.findStaticPropertyAccessorByFullName(staticImportType, "is" + accessorName.substring(3));
        }
        if (accessor == null && ClassNodeUtils.hasStaticProperty(staticImportType, propName)) {
            accessor = this.inLeftExpression ? StaticImportVisitor.newStaticMethodCallX(staticImportType, accessorName, ArgumentListExpression.EMPTY_ARGUMENTS) : StaticImportVisitor.newStaticPropertyX(staticImportType, propName);
        }
        return accessor;
    }

    private Expression findStaticPropertyAccessorByFullName(ClassNode staticImportType, String accessorMethodName) {
        ArgumentListExpression dummyArgs = new ArgumentListExpression();
        dummyArgs.addExpression(EmptyExpression.INSTANCE);
        return StaticImportVisitor.findStaticMethod(staticImportType, accessorMethodName, this.inLeftExpression ? dummyArgs : ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    private static Expression findStaticField(ClassNode staticImportType, String fieldName) {
        FieldNode field;
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && (field = ClassNodeUtils.getField(staticImportType, fieldName)) != null && field.isStatic()) {
            return StaticImportVisitor.newStaticPropertyX(staticImportType, fieldName);
        }
        return null;
    }

    private static Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args)) {
            return StaticImportVisitor.newStaticMethodCallX(staticImportType, methodName, args);
        }
        return null;
    }

    private static boolean hasPossibleStaticMember(ClassNode type, String name, Expression args) {
        if (ClassNodeUtils.hasPossibleStaticMethod(type, name, args, true)) {
            return true;
        }
        return args instanceof TupleExpression && ((TupleExpression)args).getExpressions().isEmpty() && ClassNodeUtils.hasPossibleStaticProperty(type, name);
    }

    private static boolean hasPossibleOuterMethod(ClassNode type, String name, Expression args) {
        for (ClassNode outerClass : type.getOuterClasses()) {
            if (outerClass.tryFindPossibleMethod(name, args) == null) continue;
            return true;
        }
        return false;
    }

    private static PropertyExpression newStaticPropertyX(ClassNode type, String name) {
        return new PropertyExpression((Expression)new ClassExpression(type.getPlainNodeReference()), name);
    }

    private static StaticMethodCallExpression newStaticMethodCallX(ClassNode type, String name, Expression args) {
        return new StaticMethodCallExpression(type.getPlainNodeReference(), name, args);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }
}

