/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import groovy.lang.Script;
import groovy.lang.SpreadMap;
import groovy.lang.SpreadMapEvaluatingException;
import groovy.lang.Tuple;
import groovy.lang.Writable;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.groovy.io.StringBuilderWriter;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExecutionFailed;
import org.codehaus.groovy.runtime.powerassert.PowerAssertionError;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.PojoWrapper;
import org.w3c.dom.Element;

public class InvokerHelper {
    public static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Object[] EMPTY_ARGUMENTS = EMPTY_ARGS;
    protected static final Class[] EMPTY_TYPES = new Class[0];
    private static final int ITEM_ALLOCATE_SIZE = 5;
    public static final MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();
    public static final String MAIN_METHOD_NAME = "main";
    private static Set<String> DEFAULT_IMPORT_PKGS = new HashSet<String>();
    private static Set<String> DEFAULT_IMPORT_CLASSES = new HashSet<String>();

    public static void removeClass(Class clazz) {
        metaRegistry.removeMetaClass(clazz);
        ClassInfo.remove(clazz);
        Introspector.flushFromCaches(clazz);
    }

    public static Object invokeMethodSafe(Object object, String methodName, Object arguments) {
        if (object != null) {
            return InvokerHelper.invokeMethod(object, methodName, arguments);
        }
        return null;
    }

    public static Object invokeStaticMethod(String klass, String methodName, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeStaticMethod(type, methodName, arguments);
    }

    public static Object invokeStaticNoArgumentsMethod(Class type, String methodName) {
        return InvokerHelper.invokeStaticMethod(type, methodName, (Object)EMPTY_ARGS);
    }

    public static Object invokeConstructorOf(String klass, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeConstructorOf(type, arguments);
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) {
        return InvokerHelper.invokeConstructorOf(type, (Object)EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments) {
        return InvokerHelper.invokeMethod(closure, "doCall", arguments);
    }

    public static List asList(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof Enumeration) {
            Enumeration e = (Enumeration)value;
            ArrayList answer = new ArrayList();
            while (e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value);
    }

    public static String toString(Object arguments) {
        return InvokerHelper.format(arguments, false, -1, false);
    }

    public static String inspect(Object self) {
        return InvokerHelper.format(self, true);
    }

    public static Object getAttribute(Object object, String attribute) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            return metaRegistry.getMetaClass((Class)object).getAttribute(object, attribute);
        }
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass().getAttribute(object, attribute);
        }
        return metaRegistry.getMetaClass(object.getClass()).getAttribute(object, attribute);
    }

    public static void setAttribute(Object object, String attribute, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setAttribute(object, attribute, newValue);
        } else if (object instanceof GroovyObject) {
            ((GroovyObject)object).getMetaClass().setAttribute(object, attribute, newValue);
        } else {
            metaRegistry.getMetaClass(object.getClass()).setAttribute(object, attribute, newValue);
        }
    }

    public static Object getProperty(Object object, String property) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Class) {
            Class c = (Class)object;
            return metaRegistry.getMetaClass(c).getProperty(object, property);
        }
        return ((MetaClassRegistryImpl)metaRegistry).getMetaClass(object).getProperty(object, property);
    }

    public static Object getPropertySafe(Object object, String property) {
        if (object != null) {
            return InvokerHelper.getProperty(object, property);
        }
        return null;
    }

    public static void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setProperty(object, property, newValue);
        } else {
            ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object).setProperty(object, property, newValue);
        }
    }

    public static void setProperty2(Object newValue, Object object, String property) {
        InvokerHelper.setProperty(object, property, newValue);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object, String property) {
        object.setProperty(property, newValue);
    }

    public static Object getGroovyObjectProperty(GroovyObject object, String property) {
        return object.getProperty(property);
    }

    public static void setPropertySafe2(Object newValue, Object object, String property) {
        if (object != null) {
            InvokerHelper.setProperty2(newValue, object, property);
        }
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        if (object == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return new MethodClosure(object, methodName);
    }

    public static Object unaryMinus(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return -number.intValue();
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return -number.longValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof Double) {
            Double number = (Double)value;
            return -number.doubleValue();
        }
        if (value instanceof Float) {
            Float number = (Float)value;
            return Float.valueOf(-number.floatValue());
        }
        if (value instanceof Short) {
            Short number = (Short)value;
            return -number.shortValue();
        }
        if (value instanceof Byte) {
            Byte number = (Byte)value;
            return -number.byteValue();
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object o : (ArrayList)value) {
                newlist.add(InvokerHelper.unaryMinus(o));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "negative", EMPTY_ARGS);
    }

    public static Object unaryPlus(Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof BigDecimal || value instanceof Double || value instanceof Float || value instanceof Short || value instanceof Byte) {
            return value;
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object o : (ArrayList)value) {
                newlist.add(InvokerHelper.unaryPlus(o));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "positive", EMPTY_ARGS);
    }

    public static Matcher findRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : InvokerHelper.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = InvokerHelper.toString(right);
        }
        return Pattern.compile(regexToCompareTo).matcher(stringToCompare);
    }

    public static boolean matchRegex(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(InvokerHelper.toString(right));
        String stringToCompare = InvokerHelper.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public static Tuple createTuple(Object[] array) {
        return new Tuple<Object>(array);
    }

    public static SpreadMap spreadMap(Object value) {
        if (value instanceof Map) {
            Object[] values = new Object[((Map)value).keySet().size() * 2];
            int index = 0;
            for (Object key : ((Map)value).keySet()) {
                values[index++] = key;
                values[index++] = ((Map)value).get(key);
            }
            return new SpreadMap(values);
        }
        throw new SpreadMapEvaluatingException("Cannot spread the map " + InvokerHelper.typeName(value) + ", value " + value);
    }

    public static List createList(Object[] values) {
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        answer.addAll(Arrays.asList(values));
        return answer;
    }

    public static Map createMap(Object[] values) {
        LinkedHashMap<Object, Object> answer = new LinkedHashMap<Object, Object>(values.length / 2);
        int i = 0;
        while (i < values.length - 1) {
            if (values[i] instanceof SpreadMap && values[i + 1] instanceof Map) {
                Map smap = (Map)values[i + 1];
                Iterator iterator = smap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e;
                    Map.Entry entry = e = iterator.next();
                    answer.put(entry.getKey(), entry.getValue());
                }
                i += 2;
                continue;
            }
            answer.put(values[i++], values[i++]);
        }
        return answer;
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new PowerAssertionError(expression.toString());
        }
        throw new AssertionError((Object)(message + ". Expression: " + expression));
    }

    public static Object runScript(Class scriptClass, String[] args) {
        Binding context = new Binding(args);
        Script script = InvokerHelper.createScript(scriptClass, context);
        return InvokerHelper.invokeMethod(script, "run", EMPTY_ARGS);
    }

    public static Script createScript(Class scriptClass, Binding context) {
        if (scriptClass == null) {
            return new NullScript(context);
        }
        try {
            Script script;
            if (Script.class.isAssignableFrom(scriptClass)) {
                script = InvokerHelper.newScript(scriptClass, context);
            } else {
                try {
                    Class<?> glBinding = scriptClass.getClassLoader().loadClass(Binding.class.getName());
                    Constructor contextualConstructor = scriptClass.getDeclaredConstructor(glBinding);
                    final Object object = contextualConstructor.newInstance(glBinding.getDeclaredConstructor(Map.class).newInstance(context.getVariables()));
                    script = new Script(){

                        @Override
                        public Object run() {
                            return InvokerHelper.invokeMethod(object, "run", EMPTY_ARGUMENTS);
                        }
                    };
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ignore) {
                    final Object object = scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    script = new Script(context){

                        @Override
                        public Object run() {
                            Object[] mainArgs = new Object[]{new String[0]};
                            try {
                                Object args = this.getProperty("args");
                                if (args instanceof String[]) {
                                    mainArgs[0] = args;
                                }
                            }
                            catch (MissingPropertyException missingPropertyException) {
                                // empty catch block
                            }
                            return InvokerHelper.invokeMethod(object, InvokerHelper.MAIN_METHOD_NAME, mainArgs);
                        }
                    };
                    MetaClass mc = InvokerHelper.getMetaClass(object);
                    Map variables = context.getVariables();
                    for (Map.Entry o : variables.entrySet()) {
                        Map.Entry entry = o;
                        String key = entry.getKey().toString();
                        InvokerHelper.setPropertySafe(key.startsWith("_") ? script : object, mc, key, entry.getValue());
                    }
                }
            }
            return script;
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Failed to create Script instance for class: " + scriptClass + ". Reason: " + e, e);
        }
    }

    public static Script newScript(Class<?> scriptClass, Binding context) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Script script;
        try {
            Constructor<?> constructor = scriptClass.getConstructor(Binding.class);
            script = (Script)constructor.newInstance(context);
        }
        catch (NoSuchMethodException e) {
            script = (Script)scriptClass.newInstance();
            script.setBinding(context);
        }
        return script;
    }

    public static void setProperties(Object object, Map map) {
        MetaClass mc = InvokerHelper.getMetaClass(object);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setPropertySafe(object, mc, key, value);
        }
    }

    private static void setPropertySafe(Object object, MetaClass mc, String key, Object value) {
        block3: {
            try {
                mc.setProperty(object, key, value);
            }
            catch (MissingPropertyException missingPropertyException) {
            }
            catch (InvokerInvocationException iie) {
                Throwable cause = iie.getCause();
                if (cause instanceof IllegalArgumentException) break block3;
                throw iie;
            }
        }
    }

    public static void write(Writer out, Object object) throws IOException {
        if (object instanceof String) {
            out.write((String)object);
        } else if (object instanceof Object[]) {
            out.write(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.write(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.write(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            writable.writeTo(out);
        } else if (object instanceof InputStream || object instanceof Reader) {
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            try (Reader r = reader;){
                int i;
                char[] chars = new char[8192];
                while ((i = r.read(chars)) != -1) {
                    out.write(chars, 0, i);
                }
            }
        } else {
            out.write(InvokerHelper.toString(object));
        }
    }

    public static void append(Appendable out, Object object) throws IOException {
        if (object instanceof String) {
            out.append((String)object);
        } else if (object instanceof Object[]) {
            out.append(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.append(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.append(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            StringBuilderWriter stringWriter = new StringBuilderWriter();
            writable.writeTo(stringWriter);
            out.append(((Object)stringWriter).toString());
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                for (int j = 0; j < i; ++j) {
                    out.append(chars[j]);
                }
            }
            reader.close();
        } else {
            out.append(InvokerHelper.toString(object));
        }
    }

    public static Iterator<Object> asIterator(Object o) {
        return (Iterator)InvokerHelper.invokeMethod(o, "iterator", EMPTY_ARGS);
    }

    protected static String format(Object arguments, boolean verbose) {
        return InvokerHelper.format(arguments, verbose, -1);
    }

    public static String format(Object arguments, boolean verbose, int maxSize) {
        return InvokerHelper.format(arguments, verbose, maxSize, false);
    }

    public static String format(Object arguments, boolean verbose, int maxSize, boolean safe) {
        if (arguments == null) {
            NullObject nullObject = NullObject.getNullObject();
            return (String)nullObject.getMetaClass().invokeMethod((Object)nullObject, "toString", EMPTY_ARGS);
        }
        if (arguments.getClass().isArray()) {
            if (arguments instanceof Object[]) {
                return InvokerHelper.toArrayString((Object[])arguments, verbose, maxSize, safe);
            }
            if (arguments instanceof char[]) {
                return new String((char[])arguments);
            }
            return InvokerHelper.formatCollection(DefaultTypeTransformation.arrayAsCollection(arguments), verbose, maxSize, safe);
        }
        if (arguments instanceof Range) {
            Range range = (Range)arguments;
            try {
                if (verbose) {
                    return range.inspect();
                }
                return range.toString();
            }
            catch (RuntimeException ex) {
                if (!safe) {
                    throw ex;
                }
                return InvokerHelper.handleFormattingException(arguments, ex);
            }
            catch (Exception ex) {
                if (!safe) {
                    throw new GroovyRuntimeException(ex);
                }
                return InvokerHelper.handleFormattingException(arguments, ex);
            }
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.formatCollection((Collection)arguments, verbose, maxSize, safe);
        }
        if (arguments instanceof Map) {
            return InvokerHelper.formatMap((Map)arguments, verbose, maxSize, safe);
        }
        if (arguments instanceof Element) {
            try {
                Method serialize = Class.forName("groovy.xml.XmlUtil").getMethod("serialize", Element.class);
                return (String)serialize.invoke(null, arguments);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (arguments instanceof String) {
            if (verbose) {
                String arg = InvokerHelper.escapeBackslashes((String)arguments).replaceAll("'", "\\\\'");
                return "'" + arg + "'";
            }
            return (String)arguments;
        }
        try {
            return arguments.toString();
        }
        catch (RuntimeException ex) {
            if (!safe) {
                throw ex;
            }
            return InvokerHelper.handleFormattingException(arguments, ex);
        }
        catch (Exception ex) {
            if (!safe) {
                throw new GroovyRuntimeException(ex);
            }
            return InvokerHelper.handleFormattingException(arguments, ex);
        }
    }

    public static String escapeBackslashes(String orig) {
        return orig.replace("\\", "\\\\").replace("\n", "\\n").replaceAll("\\r", "\\\\r").replaceAll("\\t", "\\\\t").replaceAll("\\f", "\\\\f");
    }

    private static String handleFormattingException(Object item, Exception ex) {
        String hash;
        try {
            hash = Integer.toHexString(item.hashCode());
        }
        catch (Exception ignored) {
            hash = "????";
        }
        return "<" + InvokerHelper.typeName(item) + "@" + hash + ">";
    }

    private static String formatMap(Map map, boolean verbose, int maxSize, boolean safe) {
        if (map.isEmpty()) {
            return "[:]";
        }
        StringBuilder buffer = new StringBuilder(5 * map.size() * 2);
        buffer.append('[');
        boolean first = true;
        for (Map.Entry o : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            Map.Entry entry = o;
            if (entry.getKey() == map) {
                buffer.append("(this Map)");
            } else {
                buffer.append(InvokerHelper.format(entry.getKey(), verbose, InvokerHelper.sizeLeft(maxSize, buffer), safe));
            }
            buffer.append(":");
            if (entry.getValue() == map) {
                buffer.append("(this Map)");
                continue;
            }
            buffer.append(InvokerHelper.format(entry.getValue(), verbose, InvokerHelper.sizeLeft(maxSize, buffer), safe));
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static int sizeLeft(int maxSize, StringBuilder buffer) {
        return maxSize == -1 ? maxSize : Math.max(0, maxSize - buffer.length());
    }

    private static String formatCollection(Collection collection, boolean verbose, int maxSize, boolean safe) {
        StringBuilder buffer = new StringBuilder(5 * collection.size());
        buffer.append('[');
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            if (item == collection) {
                buffer.append("(this Collection)");
                continue;
            }
            buffer.append(InvokerHelper.format(item, verbose, InvokerHelper.sizeLeft(maxSize, buffer), safe));
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String toTypeString(Object[] arguments) {
        return InvokerHelper.toTypeString(arguments, -1);
    }

    public static String toTypeString(Object[] arguments, int maxSize) {
        if (arguments == null) {
            return "null";
        }
        StringBuilder argBuf = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (maxSize != -1 && argBuf.length() > maxSize) {
                argBuf.append("...");
                break;
            }
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments[i] != null ? InvokerHelper.typeName(arguments[i]) : "null");
        }
        return argBuf.toString();
    }

    private static String typeName(Object argument) {
        Class<?> aClass = argument.getClass();
        String pkgName = aClass.getPackage() == null ? "" : aClass.getPackage().getName();
        boolean useShort = DEFAULT_IMPORT_PKGS.contains(pkgName) || DEFAULT_IMPORT_CLASSES.contains(aClass.getName());
        return useShort ? aClass.getSimpleName() : aClass.getName();
    }

    public static String toMapString(Map arg) {
        return InvokerHelper.toMapString(arg, -1);
    }

    public static String toMapString(Map arg, int maxSize) {
        return InvokerHelper.formatMap(arg, false, maxSize, false);
    }

    public static String toListString(Collection arg) {
        return InvokerHelper.toListString(arg, -1);
    }

    public static String toListString(Collection arg, int maxSize) {
        return InvokerHelper.toListString(arg, maxSize, false);
    }

    public static String toListString(Collection arg, int maxSize, boolean safe) {
        return InvokerHelper.formatCollection(arg, false, maxSize, safe);
    }

    public static String toArrayString(Object[] arguments) {
        return InvokerHelper.toArrayString(arguments, false, -1, false);
    }

    private static String toArrayString(Object[] array, boolean verbose, int maxSize, boolean safe) {
        if (array == null) {
            return "null";
        }
        boolean first = true;
        StringBuilder argBuf = new StringBuilder(array.length);
        argBuf.append('[');
        for (Object item : array) {
            if (first) {
                first = false;
            } else {
                argBuf.append(", ");
            }
            if (maxSize != -1 && argBuf.length() > maxSize) {
                argBuf.append("...");
                break;
            }
            if (item == array) {
                argBuf.append("(this array)");
                continue;
            }
            argBuf.append(InvokerHelper.format(item, verbose, InvokerHelper.sizeLeft(maxSize, argBuf), safe));
        }
        argBuf.append(']');
        return argBuf.toString();
    }

    public static String toArrayString(Object[] arguments, int maxSize, boolean safe) {
        return InvokerHelper.toArrayString(arguments, false, maxSize, safe);
    }

    public static List createRange(Object from, Object to, boolean inclusive) {
        try {
            return ScriptBytecodeAdapter.createRange(from, to, inclusive);
        }
        catch (Error | RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object bitwiseNegate(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return ~number.intValue();
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return number ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).not();
        }
        if (value instanceof String) {
            return StringGroovyMethods.bitwiseNegate(value.toString());
        }
        if (value instanceof GString) {
            return StringGroovyMethods.bitwiseNegate(value.toString());
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object o : (ArrayList)value) {
                newlist.add(InvokerHelper.bitwiseNegate(o));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "bitwiseNegate", EMPTY_ARGS);
    }

    public static MetaClassRegistry getMetaRegistry() {
        return metaRegistry;
    }

    public static MetaClass getMetaClass(Object object) {
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass();
        }
        return ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object);
    }

    public static MetaClass getMetaClass(Class cls) {
        return metaRegistry.getMetaClass(cls);
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, InvokerHelper.asArray(arguments));
        }
        if (!(object instanceof GroovyObject)) {
            return InvokerHelper.invokePojoMethod(object, methodName, arguments);
        }
        return InvokerHelper.invokePogoMethod(object, methodName, arguments);
    }

    static Object invokePojoMethod(Object object, String methodName, Object arguments) {
        MetaClass metaClass = InvokerHelper.getMetaClass(object);
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
    }

    static Object invokePogoMethod(Object object, String methodName, Object arguments) {
        GroovyObject groovy = (GroovyObject)object;
        boolean intercepting = groovy instanceof GroovyInterceptable;
        try {
            if (intercepting) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            return groovy.getMetaClass().invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
        }
        catch (MissingMethodException e) {
            if (e instanceof MissingMethodExecutionFailed) {
                throw (MissingMethodException)e.getCause();
            }
            if (!intercepting && e.getMethod().equals(methodName) && object.getClass() == e.getType()) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            throw e;
        }
    }

    public static Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
    }

    public static Object invokeStaticMethod(Class type, String method, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, InvokerHelper.asArray(arguments));
    }

    public static Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(InvokerHelper.asArray(arguments));
    }

    public static Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public static Object[] asUnwrappedArray(Object arguments) {
        Object[] args = InvokerHelper.asArray(arguments);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof PojoWrapper)) continue;
            args[i] = ((PojoWrapper)args[i]).unwrap();
        }
        return args;
    }

    static {
        for (String pkgName : ResolveVisitor.DEFAULT_IMPORTS) {
            DEFAULT_IMPORT_PKGS.add(pkgName.substring(0, pkgName.length() - 1));
        }
        DEFAULT_IMPORT_CLASSES.add("java.math.BigDecimal");
        DEFAULT_IMPORT_CLASSES.add("java.math.BigInteger");
    }

    static class NullScript
    extends Script {
        public NullScript(Binding context) {
            super(context);
        }

        public NullScript() {
            this(new Binding());
        }

        @Override
        public Object run() {
            return null;
        }
    }
}

