/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.spi.connector.ColumnHandle;
import java.util.Objects;
import org.apache.gravitino.trino.connector.GravitinoHandle;

public final class GravitinoColumnHandle
implements ColumnHandle,
GravitinoHandle<ColumnHandle> {
    private final String columnName;
    private GravitinoHandle.HandleWrapper<ColumnHandle> handleWrapper = new GravitinoHandle.HandleWrapper<Class<ColumnHandle>>(ColumnHandle.class);

    @JsonCreator
    public GravitinoColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="handleString") String handleString) {
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (Object)"schemaName is not null");
        Preconditions.checkArgument((handleString != null ? 1 : 0) != 0, (Object)"internalHandle is not null");
        this.columnName = columnName;
        this.handleWrapper = this.handleWrapper.fromJson(handleString);
    }

    public GravitinoColumnHandle(String columnName, ColumnHandle internalColumnHandle) {
        this.columnName = columnName;
        this.handleWrapper = new GravitinoHandle.HandleWrapper<ColumnHandle>(internalColumnHandle);
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    @JsonProperty
    public String getHandleString() {
        return this.handleWrapper.toJson();
    }

    @Override
    public ColumnHandle getInternalHandle() {
        return this.handleWrapper.getHandle();
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GravitinoColumnHandle other = (GravitinoColumnHandle)obj;
        return Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return this.columnName + "->" + this.getInternalHandle().toString();
    }
}

