/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableIntStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.IntArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableIntStackFactoryImpl
implements MutableIntStackFactory {
    public static final MutableIntStackFactory INSTANCE = new MutableIntStackFactoryImpl();

    public MutableIntStack empty() {
        return new IntArrayStack();
    }

    public MutableIntStack of() {
        return this.empty();
    }

    public MutableIntStack with() {
        return this.empty();
    }

    public MutableIntStack of(int ... items) {
        return this.with(items);
    }

    public MutableIntStack with(int ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return IntArrayStack.newStackWith(items);
    }

    public MutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public MutableIntStack withAll(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStack(items);
    }

    public MutableIntStack ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    public MutableIntStack withAll(Iterable<Integer> iterable) {
        MutableIntStack stack = IntStacks.mutable.empty();
        Iterate.forEach(iterable, arg_0 -> ((MutableIntStack)stack).push(arg_0));
        return stack;
    }

    public MutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    public MutableIntStack withAllReversed(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStackFromTopToBottom(items);
    }

    public MutableIntStack ofAll(IntStream items) {
        return this.withAll(items);
    }

    public MutableIntStack withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

