/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions;

import java.util.Arrays;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.expressions.Expression;

@Evolving
public interface NamedReference
extends Expression {
    public static FieldReference field(String[] fieldName) {
        return new FieldReference(fieldName);
    }

    public static FieldReference field(String columnName) {
        return NamedReference.field(new String[]{columnName});
    }

    public static MetadataField metadataField(String[] fieldNames) {
        return new MetadataField(fieldNames);
    }

    public String[] fieldName();

    @Override
    default public Expression[] children() {
        return EMPTY_EXPRESSION;
    }

    @Override
    default public NamedReference[] references() {
        return new NamedReference[]{this};
    }

    public static final class FieldReference
    implements NamedReference {
        private final String[] fieldName;

        private FieldReference(String[] fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldReference that = (FieldReference)o;
            return Arrays.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldName);
        }

        public String toString() {
            return String.join((CharSequence)".", this.fieldName);
        }
    }

    public static final class MetadataField
    implements NamedReference {
        public static final MetadataField PARTITION_NAME_FIELD = new MetadataField(new String[]{"partition_name"});
        private final String[] fieldName;

        MetadataField(String[] fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataField that = (MetadataField)o;
            return Arrays.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldName);
        }

        public String toString() {
            return String.join((CharSequence)".", this.fieldName);
        }
    }
}

