/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package page.user

import geb.module.Checkbox
import geb.module.PasswordInput
import geb.module.TextInput
import page.CreatePage

class UserCreatePage extends CreatePage {

	static url = 'user/create'
	static typeName = { 'User' }
	static at = { waitFor { title == 'Create User' } }
	static content = {
		username { $('#username').module(TextInput) }
		password { $('#password').module(PasswordInput) }
		enabled { $(name: 'enabled').module(Checkbox) }
		accountExpired { $(name: 'accountExpired').module(Checkbox) }
		accountLocked { $(name: 'accountLocked').module(Checkbox) }
		passwordExpired { $(name: 'passwordExpired').module(Checkbox) }
	}
}
