/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.consumer.Whitelist;
import kafka.log.LogConfig$;
import kafka.server.OffsetManager$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TopicCommand$ {
    public static final TopicCommand$ MODULE$;

    static {
        new TopicCommand$();
    }

    public void main(String[] args) {
        int actions;
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Create, delete, describe, or change a topic.");
        }
        if ((actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.listOpt(), opts.alterOpt(), opts.describeOpt(), opts.deleteOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        })) != 1) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --create, --alter or --delete");
        }
        opts.checkArgs();
        ZkClient zkClient = new ZkClient((String)opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createTopic(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterTopic(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                    this.listTopics(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeTopic(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    this.deleteTopic(zkClient, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
        }
        finally {
            zkClient.close();
        }
    }

    private Seq<String> getTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)ZkUtils$.MODULE$.getAllTopics(zkClient).sorted((Ordering)Ordering.String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter((Function1)new Serializable(topicsFilter){
                public static final long serialVersionUID = 0L;
                private final Whitelist topicsFilter$1;

                public final boolean apply(String x$1) {
                    return this.topicsFilter$1.isTopicAllowed(x$1, false);
                }
                {
                    this.topicsFilter$1 = topicsFilter$1;
                }
            });
        } else {
            seq = allTopics;
        }
        return seq;
    }

    public void createTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        String topic = (String)opts.options().valueOf(opts.topicOpt());
        Properties configs = this.parseTopicConfigsToBeAdded(opts);
        if (opts.options().has(opts.replicaAssignmentOpt())) {
            Map<Object, List<Object>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, assignment, configs, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        } else {
            CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
            int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
            int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
            AdminUtils$.MODULE$.createTopic(zkClient, topic, partitions, replicas, configs);
        }
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    public void alterTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1)new Serializable(zkClient, opts){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            private final TopicCommand.TopicCommandOptions opts$2;

            public final void apply(String topic) {
                Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$1, topic);
                if (this.opts$2.options().has(this.opts$2.configOpt()) || this.opts$2.options().has(this.opts$2.deleteConfigOpt())) {
                    Properties configsToBeAdded = TopicCommand$.MODULE$.parseTopicConfigsToBeAdded(this.opts$2);
                    Seq<String> configsToBeDeleted = TopicCommand$.MODULE$.parseTopicConfigsToBeDeleted(this.opts$2);
                    configs.putAll((java.util.Map<?, ?>)configsToBeAdded);
                    configsToBeDeleted.foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(String config) {
                            return this.configs$1.remove(config);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    AdminUtils$.MODULE$.changeTopicConfig(this.zkClient$1, topic, configs);
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Updated config for topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                if (this.opts$2.options().has(this.opts$2.partitionsOpt())) {
                    String string = topic;
                    String string2 = OffsetManager$.MODULE$.OffsetsTopicName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new IllegalArgumentException("The number of partitions for the offsets topic cannot be changed.");
                    }
                    Predef$.MODULE$.println((Object)"WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
                    int nPartitions = (Integer)this.opts$2.options().valueOf(this.opts$2.partitionsOpt());
                    String replicaAssignmentStr = (String)this.opts$2.options().valueOf(this.opts$2.replicaAssignmentOpt());
                    ZkClient x$8 = this.zkClient$1;
                    String x$9 = topic;
                    int x$10 = nPartitions;
                    String x$11 = replicaAssignmentStr;
                    Properties x$12 = configs;
                    boolean x$13 = AdminUtils$.MODULE$.addPartitions$default$5();
                    AdminUtils$.MODULE$.addPartitions(x$8, x$9, x$10, x$11, x$13, x$12);
                    Predef$.MODULE$.println((Object)"Adding partitions succeeded!");
                }
            }
            {
                this.zkClient$1 = zkClient$1;
                this.opts$2 = opts$2;
            }
        });
    }

    public void listTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$2;

            public final void apply(String topic) {
                if (ZkUtils$.MODULE$.pathExists(this.zkClient$2, ZkUtils$.MODULE$.getDeleteTopicPath(topic))) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s - marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                } else {
                    Predef$.MODULE$.println((Object)topic);
                }
            }
            {
                this.zkClient$2 = zkClient$2;
            }
        });
    }

    public void deleteTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        if (topics.length() == 0) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.options().valueOf(opts.topicOpt())})));
        }
        topics.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$4;

            public final void apply(String topic) {
                try {
                    ZkUtils$.MODULE$.createPersistentPath(this.zkClient$4, ZkUtils$.MODULE$.getDeleteTopicPath(topic), ZkUtils$.MODULE$.createPersistentPath$default$3());
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    Predef$.MODULE$.println((Object)"Note: This will have no impact if delete.topic.enable is not set to true.");
                }
                catch (Throwable throwable) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Error while deleting topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is already marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
            }
            {
                this.zkClient$4 = zkClient$4;
            }
        });
    }

    public void describeTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean reportUnderReplicatedPartitions = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers2 = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$2) {
                return x$2.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1)new Serializable(zkClient, reportUnderReplicatedPartitions, reportUnavailablePartitions, reportOverriddenConfigs, liveBrokers2){
            public static final long serialVersionUID = 0L;
            public final ZkClient zkClient$3;
            public final boolean reportUnderReplicatedPartitions$1;
            public final boolean reportUnavailablePartitions$1;
            private final boolean reportOverriddenConfigs$1;
            public final Set liveBrokers$1;

            public final void apply(String topic) {
                Option option;
                block9: {
                    block8: {
                        block7: {
                            BoxedUnit boxedUnit;
                            option = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(this.zkClient$3, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            Map topicPartitionAssignment = (Map)some.x();
                            boolean describeConfigs = !this.reportUnavailablePartitions$1 && !this.reportUnderReplicatedPartitions$1;
                            boolean describePartitions = !this.reportOverriddenConfigs$1;
                            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                                }
                            });
                            if (describeConfigs) {
                                Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$3, topic);
                                if (!this.reportOverriddenConfigs$1 || configs.size() != 0) {
                                    int numPartitions = topicPartitionAssignment.size();
                                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor), ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Tuple2<String, String> kv) {
                                            return new StringBuilder().append((Object)((String)kv._1())).append((Object)"=").append(kv._2()).toString();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                                }
                            }
                            if (describePartitions) {
                                sortedPartitions.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<Object, Seq<Object>> check$ifrefutable$1) {
                                        Tuple2<Object, Seq<Object>> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.describeTopic.1 $outer;
                                    private final String topic$1;

                                    public final void apply(Tuple2<Object, Seq<Object>> x$3) {
                                        Tuple2<Object, Seq<Object>> tuple2 = x$3;
                                        if (tuple2 != null) {
                                            BoxedUnit boxedUnit;
                                            int partitionId = tuple2._1$mcI$sp();
                                            Seq assignedReplicas = (Seq)tuple2._2();
                                            Seq<Object> inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.$outer.zkClient$3, this.topic$1, partitionId);
                                            Option<Object> leader = ZkUtils$.MODULE$.getLeaderForPartition(this.$outer.zkClient$3, this.topic$1, partitionId);
                                            if ((this.$outer.reportUnderReplicatedPartitions$1 || this.$outer.reportUnavailablePartitions$1) && (!this.$outer.reportUnderReplicatedPartitions$1 || inSyncReplicas.size() >= assignedReplicas.size()) && (!this.$outer.reportUnavailablePartitions$1 || leader.isDefined() && this.$outer.liveBrokers$1.contains(leader.get()))) {
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tTopic: ").append((Object)this.topic$1).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tPartition: ").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tLeader: ").append(leader.isDefined() ? leader.get() : "none").toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tReplicas: ").append((Object)assignedReplicas.mkString(",")).toString());
                                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\tIsr: ").append((Object)inSyncReplicas.mkString(",")).toString());
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = topic$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block8;
                        }
                        if (!None$.MODULE$.equals(option)) break block9;
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Topic ").append((Object)topic).append((Object)" doesn't exist!").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$3 = zkClient$3;
                this.reportUnderReplicatedPartitions$1 = reportUnderReplicatedPartitions$1;
                this.reportUnavailablePartitions$1 = reportUnavailablePartitions$1;
                this.reportOverriddenConfigs$1 = reportOverriddenConfigs$1;
                this.liveBrokers$1 = liveBrokers$1;
            }
        });
    }

    public String formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)Utils.formatAddress((String)broker.host(), (Integer)Predef$.MODULE$.int2Integer(broker.port()))).append((Object)")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.configOpt())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$4) {
                return x$4.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        });
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] pair) {
                return this.props$1.setProperty(pair[0].trim(), pair[1].trim());
            }
            {
                this.props$1 = props$1;
            }
        });
        LogConfig$.MODULE$.validate(props);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfigOpt())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$5) {
                    return x$5.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$6) {
                    return this.propsToBeDeleted$1.setProperty(x$6, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            LogConfig$.MODULE$.validateNames(propsToBeDeleted);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList = replicaAssignmentList.split(",");
        HashMap ret = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])partitionList).size()).foreach$mVc$sp((Function1)new Serializable(partitionList, ret){
            public static final long serialVersionUID = 0L;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[i].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s) {
                        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                Iterable<T> duplicateBrokers = Utils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
                if (duplicateBrokers.nonEmpty()) {
                    throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateBrokers.mkString(",")})));
                }
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
            }
            {
                this.partitionList$1 = partitionList$1;
                this.ret$1 = ret$1;
            }
        });
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    private TopicCommand$() {
        MODULE$ = this;
    }
}

