/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.local;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.TimingEvent;
import org.apache.gobblin.runtime.AbstractJobLauncher;
import org.apache.gobblin.runtime.GobblinMultiTaskAttempt;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.local.LocalTaskStateTracker;
import org.apache.gobblin.runtime.util.MultiWorkUnitUnpackingIterator;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJobLauncher
extends AbstractJobLauncher {
    private static final Logger log = LoggerFactory.getLogger(LocalJobLauncher.class);
    private static final Logger LOG = LoggerFactory.getLogger(LocalJobLauncher.class);
    private final TaskExecutor taskExecutor;
    private final TaskStateTracker taskStateTracker;
    private final ServiceManager serviceManager;

    public LocalJobLauncher(Properties jobProps) throws Exception {
        this(jobProps, (SharedResourcesBroker<GobblinScopeTypes>)null);
    }

    public LocalJobLauncher(Properties jobProps, SharedResourcesBroker<GobblinScopeTypes> instanceBroker) throws Exception {
        super(jobProps, (List<? extends Tag<?>>)ImmutableList.of(), instanceBroker);
        log.debug("Local job launched with properties: {}", (Object)jobProps);
        TimingEvent jobLocalSetupTimer = this.eventSubmitter.getTimingEvent("JobLocalSetupTimer");
        this.taskExecutor = new TaskExecutor(jobProps);
        this.taskStateTracker = new LocalTaskStateTracker(jobProps, this.jobContext.getJobState(), this.taskExecutor, this.eventBus);
        this.serviceManager = new ServiceManager((Iterable)Lists.newArrayList((Object[])new Service[]{this.taskExecutor, this.taskStateTracker}));
        this.serviceManager.startAsync().awaitHealthy(5L, TimeUnit.SECONDS);
        this.startCancellationExecutor();
        jobLocalSetupTimer.stop();
    }

    public LocalJobLauncher(Configurable instanceConf, JobSpec jobSpec) throws Exception {
        this(JobConfigurationUtils.combineSysAndJobProperties((Properties)instanceConf.getConfigAsProperties(), (Properties)jobSpec.getConfigAsProperties()));
    }

    @Override
    public void close() throws IOException {
        try {
            this.serviceManager.stopAsync().awaitStopped(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            LOG.warn("Timed out while waiting for the service manager to be stopped", (Throwable)te);
        }
        finally {
            super.close();
        }
    }

    @Override
    protected void runWorkUnits(List<WorkUnit> workUnits) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runWorkUnitStream(WorkUnitStream workUnitStream) throws Exception {
        String jobId = this.jobContext.getJobId();
        final JobState jobState = this.jobContext.getJobState();
        Iterator workUnitIterator = workUnitStream.getWorkUnits();
        if (!workUnitIterator.hasNext()) {
            LOG.warn("No work units to run");
            return;
        }
        TimingEvent workUnitsRunTimer = this.eventSubmitter.getTimingEvent("WorkUnitsRunTimer");
        MultiWorkUnitUnpackingIterator flattenedWorkUnits = new MultiWorkUnitUnpackingIterator(workUnitStream.getWorkUnits());
        Iterator workUnitsWithJobState = Iterators.transform((Iterator)flattenedWorkUnits, (Function)new Function<WorkUnit, WorkUnit>(){

            public WorkUnit apply(WorkUnit workUnit) {
                workUnit.addAllIfNotExist((State)jobState);
                return workUnit;
            }
        });
        GobblinMultiTaskAttempt.runWorkUnits(this.jobContext, workUnitsWithJobState, this.taskStateTracker, this.taskExecutor, GobblinMultiTaskAttempt.CommitPolicy.IMMEDIATE);
        if (this.cancellationRequested) {
            Object object = this.cancellationExecution;
            synchronized (object) {
                if (this.cancellationExecuted) {
                    return;
                }
            }
        }
        workUnitsRunTimer.stop();
        LOG.info(String.format("All tasks of job %s have completed", jobId));
        if (jobState.getState() == JobState.RunningState.RUNNING) {
            jobState.setState(JobState.RunningState.SUCCESSFUL);
        }
    }

    @Override
    protected void executeCancellation() {
    }
}

